/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.formation.target;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageHitResult;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.particles.barrages.api.DamagedBarrage;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcn/coostack/usefulmagic/formation/target/BarrageTargetOption;", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "target", "Lcn/coostack/cooparticlesapi/barrages/Barrage;", "<init>", "(Lcn/coostack/cooparticlesapi/barrages/Barrage;)V", "getTarget", "()Lcn/coostack/cooparticlesapi/barrages/Barrage;", "getUniqueID", "Ljava/util/UUID;", "getOwnerUUID", "getWorld", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "movementVec", "damage", "", "amount", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "hit", "setVelocity", "dir", "isValid", "", "usefulmagic-neoforge-1.21.1"})
public final class BarrageTargetOption
implements FormationTargetOption {
    @NotNull
    private final Barrage target;

    public BarrageTargetOption(@NotNull Barrage target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @NotNull
    public final Barrage getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public UUID getUniqueID() {
        return this.target.getUuid();
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        Object object = this.target.getShooter();
        if (object == null || (object = object.getUUID()) == null) {
            BarrageTargetOption it = this;
            boolean bl = false;
            object = this.target instanceof DamagedBarrage ? ((DamagedBarrage)this.target).getOfflineShooter() : null;
        }
        return object;
    }

    @Override
    @NotNull
    public Level getWorld() {
        return (Level)this.target.getWorld();
    }

    @Override
    @NotNull
    public Vec3 pos() {
        return this.target.getLoc();
    }

    @Override
    @NotNull
    public Vec3 movementVec() {
        Vec3 vec3;
        if (this.target.getOptions().getEnableSpeed()) {
            Vec3 vec32 = this.target.getDirection().normalize().scale(this.target.getOptions().getSpeed());
            Intrinsics.checkNotNull((Object)vec32);
            vec3 = vec32;
        } else {
            vec3 = this.target.getDirection();
        }
        return vec3;
    }

    @Override
    public void damage(float amount, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.target.hit(new BarrageHitResult());
    }

    public final void hit() {
        this.target.hit(new BarrageHitResult());
    }

    @Override
    public void setVelocity(@NotNull Vec3 dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.target.setDirection(dir);
    }

    @Override
    public boolean isValid() {
        return this.target.getValid();
    }
}

