/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.formation.target;

import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcn/coostack/usefulmagic/formation/target/LivingEntityTargetOption;", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "touch", "", "<init>", "(Lnet/minecraft/world/entity/LivingEntity;Z)V", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "getTouch", "()Z", "getUniqueID", "Ljava/util/UUID;", "getOwnerUUID", "getWorld", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "movementVec", "damage", "", "amount", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "setVelocity", "dir", "isValid", "usefulmagic-neoforge-1.21.1"})
public final class LivingEntityTargetOption
implements FormationTargetOption {
    @NotNull
    private final LivingEntity target;
    private final boolean touch;

    public LivingEntityTargetOption(@NotNull LivingEntity target, boolean touch) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        this.touch = touch;
    }

    public /* synthetic */ LivingEntityTargetOption(LivingEntity livingEntity, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(livingEntity, bl);
    }

    @NotNull
    public final LivingEntity getTarget() {
        return this.target;
    }

    public final boolean getTouch() {
        return this.touch;
    }

    @Override
    @NotNull
    public UUID getUniqueID() {
        UUID uUID = this.target.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return uUID;
    }

    @Override
    @NotNull
    public UUID getOwnerUUID() {
        UUID uUID = this.target.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return uUID;
    }

    @Override
    @NotNull
    public Level getWorld() {
        Level level = this.target.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return level;
    }

    @Override
    @NotNull
    public Vec3 pos() {
        Vec3 vec3 = this.target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 movementVec() {
        Vec3 vec3 = this.target.getKnownMovement();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getKnownMovement(...)");
        return vec3;
    }

    @Override
    public void damage(float amount, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.target.hurt(source, amount);
        this.target.invulnerableTime = 0;
    }

    @Override
    public void setVelocity(@NotNull Vec3 dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.target.setDeltaMovement(dir);
        this.target.hurtMarked = true;
        this.target.move(MoverType.PLAYER, dir);
    }

    @Override
    public boolean isValid() {
        return !this.target.noPhysics && this.target.isAlive();
    }
}

