/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.formation.target;

import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.meteorite.Meteorite;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcn/coostack/usefulmagic/formation/target/MeteoriteEntityTargetOption;", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "meteorite", "Lcn/coostack/usefulmagic/meteorite/Meteorite;", "<init>", "(Lcn/coostack/usefulmagic/meteorite/Meteorite;)V", "getMeteorite", "()Lcn/coostack/usefulmagic/meteorite/Meteorite;", "getUniqueID", "Ljava/util/UUID;", "getOwnerUUID", "getWorld", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "movementVec", "damage", "", "amount", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "setVelocity", "dir", "isValid", "", "usefulmagic-neoforge-1.21.1"})
public final class MeteoriteEntityTargetOption
implements FormationTargetOption {
    @NotNull
    private final Meteorite meteorite;

    public MeteoriteEntityTargetOption(@NotNull Meteorite meteorite) {
        Intrinsics.checkNotNullParameter((Object)meteorite, (String)"meteorite");
        this.meteorite = meteorite;
    }

    @NotNull
    public final Meteorite getMeteorite() {
        return this.meteorite;
    }

    @Override
    @NotNull
    public UUID getUniqueID() {
        Object object = this.meteorite.getShooter();
        if (object == null || (object = object.getUUID()) == null) {
            UUID uUID = UUID.randomUUID();
            object = uUID;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        }
        return object;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        Object object = this.meteorite.getShooter();
        if (object == null || (object = object.getUUID()) == null) {
            object = UUID.randomUUID();
        }
        return object;
    }

    @Override
    @NotNull
    public Level getWorld() {
        ServerLevel serverLevel = this.meteorite.getWorld();
        Intrinsics.checkNotNull((Object)serverLevel);
        return (Level)serverLevel;
    }

    @Override
    @NotNull
    public Vec3 pos() {
        return this.meteorite.getOrigin();
    }

    @Override
    @NotNull
    public Vec3 movementVec() {
        return this.meteorite.getDirection().toVector();
    }

    @Override
    public void damage(float amount, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.meteorite.onHit(this.meteorite.getOrigin());
    }

    @Override
    public void setVelocity(@NotNull Vec3 dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.meteorite.setDirection(RelativeLocation.Companion.of(dir));
    }

    @Override
    public boolean isValid() {
        return this.meteorite.getValid();
    }
}

