/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.formation.target;

import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcn/coostack/usefulmagic/formation/target/ProjectileEntityTargetOption;", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "target", "Lnet/minecraft/world/entity/projectile/Projectile;", "<init>", "(Lnet/minecraft/world/entity/projectile/Projectile;)V", "getTarget", "()Lnet/minecraft/world/entity/projectile/Projectile;", "getUniqueID", "Ljava/util/UUID;", "getOwnerUUID", "getWorld", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "movementVec", "damage", "", "amount", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "setVelocity", "dir", "isValid", "", "usefulmagic-neoforge-1.21.1"})
public final class ProjectileEntityTargetOption
implements FormationTargetOption {
    @NotNull
    private final Projectile target;

    public ProjectileEntityTargetOption(@NotNull Projectile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    @NotNull
    public final Projectile getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public UUID getUniqueID() {
        UUID uUID = this.target.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return uUID;
    }

    @Override
    @NotNull
    public UUID getOwnerUUID() {
        UUID uUID;
        if (this.target.getOwner() != null) {
            Entity entity = this.target.getOwner();
            Intrinsics.checkNotNull((Object)entity);
            UUID uUID2 = entity.getUUID();
            Intrinsics.checkNotNull((Object)uUID2);
            uUID = uUID2;
        } else {
            UUID uUID3 = this.target.getUUID();
            Intrinsics.checkNotNull((Object)uUID3);
            uUID = uUID3;
        }
        return uUID;
    }

    @Override
    @NotNull
    public Level getWorld() {
        Level level = this.target.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return level;
    }

    @Override
    @NotNull
    public Vec3 pos() {
        Vec3 vec3 = this.target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 movementVec() {
        Vec3 vec3 = this.target.getKnownMovement();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getKnownMovement(...)");
        return vec3;
    }

    @Override
    public void damage(float amount, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.target.hurt(source, amount);
    }

    @Override
    public void setVelocity(@NotNull Vec3 dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.target.setDeltaMovement(dir);
        this.target.hurtMarked = true;
    }

    @Override
    public boolean isValid() {
        return this.target.isAlive();
    }
}

