/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.gui.guildbook.widget.button;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0010H\u0014J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014\u00a8\u0006("}, d2={"Lcn/coostack/usefulmagic/gui/guildbook/widget/button/ItemTextureButton;", "Lnet/minecraft/client/gui/components/Button;", "x", "", "y", "width", "height", "item", "Lnet/minecraft/world/item/ItemStack;", "pressAction", "Lnet/minecraft/client/gui/components/Button$OnPress;", "<init>", "(IIIILnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/gui/components/Button$OnPress;)V", "getItem", "()Lnet/minecraft/world/item/ItemStack;", "scale", "", "getScale", "()F", "setScale", "(F)V", "clickSound", "Lnet/minecraft/sounds/SoundEvent;", "getClickSound", "()Lnet/minecraft/sounds/SoundEvent;", "setClickSound", "(Lnet/minecraft/sounds/SoundEvent;)V", "pitch", "getPitch", "setPitch", "renderWidget", "", "context", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "delta", "playDownSound", "soundManager", "Lnet/minecraft/client/sounds/SoundManager;", "usefulmagic-neoforge-1.21.1"})
public final class ItemTextureButton
extends Button {
    @NotNull
    private final ItemStack item;
    private float scale;
    @NotNull
    private SoundEvent clickSound;
    private float pitch;

    public ItemTextureButton(int x, int y, int width, int height, @NotNull ItemStack item, @NotNull Button.OnPress pressAction) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)pressAction, (String)"pressAction");
        super(x, y, width, height, (Component)Component.empty(), pressAction, Button.DEFAULT_NARRATION);
        this.item = item;
        this.scale = 1.0f;
        Object object = SoundEvents.UI_BUTTON_CLICK.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        this.clickSound = (SoundEvent)object;
        this.pitch = 1.0f;
    }

    @NotNull
    public final ItemStack getItem() {
        return this.item;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    @NotNull
    public final SoundEvent getClickSound() {
        return this.clickSound;
    }

    public final void setClickSound(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"<set-?>");
        this.clickSound = soundEvent;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    protected void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.scale(this.scale, this.scale, 1.0f);
        matrices.translate(-((float)this.getX()), -((float)this.getY()), 0.0f);
        matrices.translate((float)this.getX() / this.scale, (float)this.getY() / this.scale, 0.0f);
        context.renderItem(this.item, this.getX(), this.getY());
        if (this.isHovered) {
            context.fillGradient(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, Integer.MAX_VALUE, Integer.MAX_VALUE, 0);
        }
        matrices.popPose();
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)this.pitch));
    }
}

