/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.PresetLaserEmitters;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.server.ServerRenderEntityManager;
import cn.coostack.cooparticlesapi.scheduler.CooScheduler;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.blocks.entity.AltarEntity;
import cn.coostack.usefulmagic.blocks.entity.MagicCoreBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.formation.FormationCoreBlockEntity;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.meteorite.impl.TestMeteorite;
import cn.coostack.usefulmagic.particles.emitters.explosion.ExplosionLineEmitters;
import cn.coostack.usefulmagic.particles.style.LightStyle;
import cn.coostack.usefulmagic.particles.style.TestStyle;
import cn.coostack.usefulmagic.particles.style.explosion.ExplosionMagicBallStyle;
import cn.coostack.usefulmagic.particles.style.explosion.ExplosionMagicStyle;
import cn.coostack.usefulmagic.particles.style.explosion.ExplosionStarStyle;
import cn.coostack.usefulmagic.renderer.SkyFallingRenderEntity;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020 J\u0016\u0010!\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%J\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u0016\u0010*\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u001e\u0010+\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010,\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010-\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010.\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010/\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00060"}, d2={"Lcn/coostack/usefulmagic/items/DebuggerItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "testShader", "", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/server/level/ServerPlayer;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "testFormation", "block", "Lnet/minecraft/core/BlockPos;", "testFormationEnergy", "entity", "Lcn/coostack/usefulmagic/blocks/entity/formation/EnergyCrystalsBlockEntity;", "testFormationCore", "Lcn/coostack/usefulmagic/blocks/entity/formation/FormationCoreBlockEntity;", "testMagic", "testExplosionMagicBallStyle", "testExplosionMagicStyle", "rotate", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "testImpact", "toPoint", "Lnet/minecraft/world/phys/Vec3;", "testStar", "testEmitters", "testBlock", "testLight", "testMath", "testMeteorite", "testMana", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDebuggerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerItem.kt\ncn/coostack/usefulmagic/items/DebuggerItem\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,339:1\n216#2,2:340\n*S KotlinDebug\n*F\n+ 1 DebuggerItem.kt\ncn/coostack/usefulmagic/items/DebuggerItem\n*L\n308#1:340,2\n*E\n"})
public final class DebuggerItem
extends Item {
    @NotNull
    private final Random random = RandomKt.Random((long)System.currentTimeMillis());

    public DebuggerItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder res = super.use(world, user, hand);
        if (world.isClientSide) {
            Intrinsics.checkNotNull((Object)res);
            return res;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        ServerPlayer cfr_ignored_1 = (ServerPlayer)user;
        this.testShader((ServerLevel)world, (ServerPlayer)user);
        Intrinsics.checkNotNull((Object)res);
        return res;
    }

    public final void testShader(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Level level = (Level)world;
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        SkyFallingRenderEntity shader = new SkyFallingRenderEntity(level, vec3);
        ServerRenderEntityManager.INSTANCE.spawn((RenderEntity)shader);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos block = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player user = player;
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)world;
        ServerPlayer serverPlayer = (ServerPlayer)user;
        Intrinsics.checkNotNull((Object)block);
        this.testFormation(serverLevel, serverPlayer, block);
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final void testFormation(@NotNull ServerLevel world, @NotNull ServerPlayer user, @NotNull BlockPos block) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BlockEntity blockEntity = world.getBlockEntity(block);
        if (blockEntity == null) {
            return;
        }
        BlockEntity entity = blockEntity;
        BlockEntity blockEntity2 = entity;
        if (blockEntity2 instanceof FormationCoreBlockEntity) {
            this.testFormationCore(world, user, (FormationCoreBlockEntity)entity);
        } else if (blockEntity2 instanceof EnergyCrystalsBlockEntity) {
            this.testFormationEnergy(world, user, (EnergyCrystalsBlockEntity)entity);
        }
    }

    private final void testFormationEnergy(ServerLevel world, ServerPlayer user, EnergyCrystalsBlockEntity entity) {
        user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                    \u80fd\u91cf\u6c34\u6676\u4fe1\u606f\n                    \u8574\u542b\u80fd\u91cf: " + entity.getCurrentMana() + "\n                    \u6700\u5927\u80fd\u91cf: " + entity.getMaxMana() + "\n                "))));
    }

    public final void testFormationCore(@NotNull ServerLevel world, @NotNull ServerPlayer user, @NotNull FormationCoreBlockEntity entity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        String string2 = entity.getFormation().getScale().name();
        float f = entity.getFormation().getFormationHealth();
        boolean bl = entity.getFormation().isActiveFormation();
        boolean bl2 = entity.getFormation().canBeFormation();
        int n = entity.getFormation().getActiveCrystals().size();
        if (entity.getFormation().getOwner() == null) {
            string = "";
        } else {
            ServerPlayer serverPlayer = world.getServer().getPlayerList().getPlayer(entity.getFormation().getOwner());
            string = serverPlayer != null ? serverPlayer.getName() : null;
        }
        user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                    \u6838\u5fc3\u65b9\u5757\u4fe1\u606f\n                    \u9635\u6cd5\u89c4\u6a21: " + string2 + "\n                    \u9635\u6cd5\u751f\u547d\u503c: " + f + "\n                    \u9635\u6cd5\u662f\u5426\u6fc0\u6d3b " + bl + "\n                    \u9635\u6cd5\u662f\u5426\u53ef\u6fc0\u6d3b " + bl2 + "\n                    \u9635\u6cd5\u4e2d\u6c34\u6676\u4e2a\u6570 " + n + "\n                    \u9635\u6cd5\u6fc0\u6d3b\u4e3b\u4eba" + string + "\n                    \u9635\u6cd5\u8303\u56f4: " + entity.getFormation().getFormationTriggerRange() + "\n                  \n                "))));
    }

    public final void testMagic(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(5, 240, () -> DebuggerItem.testMagic$lambda$1(this, world, user));
        this.testExplosionMagicBallStyle(world, user);
        CooScheduler scheduler = CooParticlesAPI.scheduler;
        scheduler.runTask(120, () -> DebuggerItem.testMagic$lambda$4(this, world, user));
        scheduler.runTask(240, () -> DebuggerItem.testMagic$lambda$6(this, world, user, scheduler));
    }

    public final void testExplosionMagicBallStyle(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ExplosionMagicBallStyle style = new ExplosionMagicBallStyle(uUID, null, 2, null);
        Level level = (Level)world;
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(level, vec3, (ParticleGroupStyle)style);
    }

    public final void testExplosionMagicStyle(@NotNull ServerLevel world, @NotNull ServerPlayer user, @NotNull RelativeLocation rotate) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)rotate, (String)"rotate");
        ExplosionMagicStyle style = new ExplosionMagicStyle(null, 1, null);
        style.setRotateDirection(rotate);
        Level level = (Level)world;
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(level, vec3, (ParticleGroupStyle)style);
    }

    public final void testImpact(@NotNull ServerLevel world, @NotNull ServerPlayer user, @NotNull Vec3 toPoint) {
        PresetLaserEmitters presetLaserEmitters;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)toPoint, (String)"toPoint");
        Vec3 vec3 = user.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        PresetLaserEmitters emitters = new PresetLaserEmitters(vec3, (Level)world);
        emitters.setTargetPoint(toPoint);
        PresetLaserEmitters $this$testImpact_u24lambda_u247 = presetLaserEmitters = emitters;
        boolean bl = false;
        $this$testImpact_u24lambda_u247.setLineStartScale(1.0f);
        $this$testImpact_u24lambda_u247.setLineScaleMin(0.01f);
        $this$testImpact_u24lambda_u247.setLineScaleMax(5.0f);
        $this$testImpact_u24lambda_u247.setParticleCountPreBlock(1);
        $this$testImpact_u24lambda_u247.setLineStartIncreaseTick(10);
        $this$testImpact_u24lambda_u247.setLineStartDecreaseTick(120);
        $this$testImpact_u24lambda_u247.setIncreaseAcceleration(0.01f);
        $this$testImpact_u24lambda_u247.setDefaultIncreaseSpeed(0.1f);
        $this$testImpact_u24lambda_u247.setDefaultDecreaseSpeed(0.2f);
        $this$testImpact_u24lambda_u247.setDecreaseAcceleration(0.3f);
        $this$testImpact_u24lambda_u247.setMaxDecreaseSpeed(3.0f);
        $this$testImpact_u24lambda_u247.setLineMaxTick(260);
        $this$testImpact_u24lambda_u247.setMarkDeadWhenArriveMinScale(true);
        $this$testImpact_u24lambda_u247.setParticleAge($this$testImpact_u24lambda_u247.getLineMaxTick() / 6 + 1);
        $this$testImpact_u24lambda_u247.getTemplateData().setColor(Math3DUtil.INSTANCE.colorOf(255, 100, 100));
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
    }

    public final void testStar(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ExplosionStarStyle style = new ExplosionStarStyle(uUID, null, 2, null);
        double r = this.random.nextDouble(2.0, 5.0);
        RelativeLocation p = (RelativeLocation)CollectionsKt.random((Collection)new PointsBuilder().addBall(r, 1).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI)).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI), RelativeLocation.Companion.xAxis()).create(), (Random)((Random)Random.Default));
        Level level = (Level)world;
        Vec3 vec3 = user.getEyePosition().add(p.toVector());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(level, vec3, (ParticleGroupStyle)style);
    }

    public final void testEmitters(@NotNull ServerLevel world, @NotNull ServerPlayer user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        double r = 45.0;
        RelativeLocation p = (RelativeLocation)CollectionsKt.random((Collection)new PointsBuilder().addBall(r, 1).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI)).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI), RelativeLocation.Companion.xAxis()).create(), (Random)((Random)Random.Default));
        Vec3 spawnPos = user.getEyePosition().add(p.toVector());
        Intrinsics.checkNotNull((Object)spawnPos);
        ExplosionLineEmitters emitters = new ExplosionLineEmitters(spawnPos, (Level)world);
        Vec3 targetPoint = user.getEyePosition().add(user.getForward().normalize().scale(5.0));
        emitters.setTargetPoint(targetPoint);
        emitters.getTemplateData().setMaxAge(120);
        emitters.getTemplateData().setSpeed(1.2);
        emitters.getTemplateData().setVelocity(new Vec3(this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0)));
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(1, 160, () -> DebuggerItem.testEmitters$lambda$8(emitters, user));
    }

    public final void testBlock(@NotNull Level world, @NotNull Player user, @NotNull BlockPos block) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BlockEntity blockEntity = world.getBlockEntity(block);
        if (blockEntity == null) {
            return;
        }
        BlockEntity entity = blockEntity;
        if (!world.isClientSide) {
            return;
        }
        if (entity instanceof AltarEntity) {
            user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                        \u796d\u575b\u65b9\u5757\u5c5e\u6027: \n                        \u83b7\u53d6\u5230\u7684\u9b54\u529b\u6700\u5927\u503c" + ((AltarEntity)entity).getDownActiveBlocksMaxMana() + "\n                        \u83b7\u53d6\u5230\u7684\u9b54\u529b\u6062\u590d\u901f\u5ea6" + ((AltarEntity)entity).getDownActiveBlocksManaReviveSpeed() + "\n                        \u796d\u575b\u7269\u54c1:" + ((AltarEntity)entity).getAltarStack() + "\n                    "))));
        }
        if (entity instanceof MagicCoreBlockEntity) {
            user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                        \u796d\u575b\u6838\u5fc3\u65b9\u5757\u5c5e\u6027: \n                        \u5f53\u524d\u9b54\u529b\u503c" + ((MagicCoreBlockEntity)entity).getCurrentMana() + "\n                        \u83b7\u53d6\u5230\u7684\u9b54\u529b\u6700\u5927\u503c" + ((MagicCoreBlockEntity)entity).getMaxMana() + "\n                        \u83b7\u53d6\u5230\u7684\u9b54\u529b\u6062\u590d\u901f\u5ea6" + ((MagicCoreBlockEntity)entity).getCurrentReviveSpeed() + "\n                        \u5408\u6210\u8fdb\u5ea6" + ((MagicCoreBlockEntity)entity).getCraftingTick() + "\n                        \u662f\u5426\u6b63\u5728\u5408\u6210" + ((MagicCoreBlockEntity)entity).getCrafting() + "\n                    "))));
        }
    }

    public final void testLight(@NotNull Level world, @NotNull Player user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return;
        }
        LightStyle style = new LightStyle(new Vec3(210.0, 120.0, 200.0), 40.0, 0.4f, 2.0f, 1.0f, 120, null, 64, null);
        Level level = (Level)((ServerLevel)world);
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(level, vec3, (ParticleGroupStyle)style);
    }

    public final void testMath(@NotNull Level world, @NotNull Player user) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return;
        }
        ServerPlayer cfr_ignored_0 = (ServerPlayer)user;
        ServerLevel cfr_ignored_1 = (ServerLevel)world;
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        RelativeLocation randomDirection = new RelativeLocation(0.0, random.nextDouble(-5.0, 5.0), random.nextDouble(-5.0, 5.0));
        randomDirection.multiply(3.0 / randomDirection.length());
        UUID uUID = ((ServerPlayer)user).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        TestStyle style = new TestStyle(uUID, null, 2, null);
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
    }

    public final void testMeteorite(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world.isClientSide) {
            return;
        }
        ServerPlayer cfr_ignored_0 = (ServerPlayer)user;
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(5, 60, () -> DebuggerItem.testMeteorite$lambda$10(user, random, world));
    }

    public final void testMana(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (!world.isClientSide) {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MagicPlayerData data = manaServerState.getDataFromServer(uUID);
            user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                    \u73a9\u5bb6 " + user.getName().getString() + " \u7684\u9b54\u529b\u5c5e\u6027\u503c\n                    \u9b54\u529b: " + data.getMana() + "\n                    \u6700\u5927\u9b54\u529b\u503c: " + data.getMaxMana() + "\n                    \u9b54\u529b\u6062\u590d/\u79d2 :" + data.getManaRegeneration() + "\n                    \u5f53\u524d\u89c6\u56fe \u670d\u52a1\u5668\n                "))));
            Map $this$forEach$iv = UsefulMagic.INSTANCE.getState().getMagicPlayerData();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ServerPlayer player;
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                MinecraftServer minecraftServer = world.getServer();
                Intrinsics.checkNotNull((Object)minecraftServer);
                if (minecraftServer.getPlayerList().getPlayer((UUID)it.getKey()) == null) continue;
                MagicPlayerData data2 = (MagicPlayerData)it.getValue();
                user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                    \u73a9\u5bb6 " + player.getName().getString() + " \u7684\u9b54\u529b\u5c5e\u6027\u503c\n                    \u9b54\u529b: " + data2.getMana() + "\n                    \u6700\u5927\u9b54\u529b\u503c: " + data2.getMaxMana() + "\n                    \u9b54\u529b\u6062\u590d/\u79d2 :" + data2.getManaRegeneration() + "\n                    \u5f53\u524d\u89c6\u56fe \u670d\u52a1\u5668 - \u5176\u4f59\u73a9\u5bb6\n                "))));
            }
            return;
        }
        MagicPlayerData data = ClientManaManager.INSTANCE.getSelfMana();
        user.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                    \u73a9\u5bb6 " + user.getName().getString() + " \u7684\u9b54\u529b\u5c5e\u6027\u503c\n                    \u9b54\u529b: " + data.getMana() + "\n                    \u6700\u5927\u9b54\u529b\u503c: " + data.getMaxMana() + "\n                    \u9b54\u529b\u6062\u590d/\u79d2 :" + data.getManaRegeneration() + "\n                    \u5f53\u524d\u89c6\u56fe \u5ba2\u6237\u7aef\n                "))));
    }

    private static final void testMagic$lambda$1(DebuggerItem this$0, ServerLevel $world, ServerPlayer $user) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this$0.testEmitters($world, $user);
        }
    }

    private static final void testMagic$lambda$4$lambda$3(DebuggerItem this$0, ServerLevel $world, ServerPlayer $user) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this$0.testStar($world, $user);
        }
    }

    private static final void testMagic$lambda$4(DebuggerItem this$0, ServerLevel $world, ServerPlayer $user) {
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(120, () -> DebuggerItem.testMagic$lambda$4$lambda$3(this$0, $world, $user));
    }

    private static final void testMagic$lambda$6$lambda$5(DebuggerItem this$0, ServerLevel $world, ServerPlayer $user) {
        this$0.testImpact($world, $user, new Vec3(0.0, 100.0, 0.0));
    }

    private static final void testMagic$lambda$6(DebuggerItem this$0, ServerLevel $world, ServerPlayer $user, CooScheduler $scheduler) {
        this$0.testExplosionMagicStyle($world, $user, RelativeLocation.Companion.yAxis());
        $scheduler.runTask(120, () -> DebuggerItem.testMagic$lambda$6$lambda$5(this$0, $world, $user));
    }

    private static final void testEmitters$lambda$8(ExplosionLineEmitters $emitters, ServerPlayer $user) {
        $emitters.setTargetPoint($user.getEyePosition().add($user.getForward().normalize().scale(3.0)));
    }

    private static final void testMeteorite$lambda$10(Player $user, Random $random, Level $world) {
        TestMeteorite testMeteorite;
        Vec3 origin = ((ServerPlayer)$user).getEyePosition().add($random.nextDouble(-16.0, 16.0), 50.0, $random.nextDouble(-16.0, 16.0));
        TestMeteorite $this$testMeteorite_u24lambda_u2410_u24lambda_u249 = testMeteorite = new TestMeteorite();
        boolean bl = false;
        $this$testMeteorite_u24lambda_u2410_u24lambda_u249.setShooter((LivingEntity)$user);
        $this$testMeteorite_u24lambda_u2410_u24lambda_u249.setDirection(RelativeLocation.Companion.yAxis().multiply(-1));
        TestMeteorite meteorite = testMeteorite;
        Intrinsics.checkNotNull((Object)origin);
        Intrinsics.checkNotNull((Object)$world, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        meteorite.spawn(origin, (ServerLevel)$world);
    }
}

