/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.consumer;

import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.items.UsefulMagicItems;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J(\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006)"}, d2={"Lcn/coostack/usefulmagic/items/consumer/SmallManaRevive;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "drinkTime", "", "getDrinkTime", "()I", "manaRevive", "getManaRevive", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "finishUsingItem", "level", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "getUseDuration", "entity", "getDrinkingSound", "Lnet/minecraft/sounds/SoundEvent;", "getEatingSound", "use", "Lnet/minecraft/world/InteractionResultHolder;", "world", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "usefulmagic-neoforge-1.21.1"})
public final class SmallManaRevive
extends Item {
    private final int drinkTime;
    private final int manaRevive;

    public SmallManaRevive(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.drinkTime = 20;
        this.manaRevive = 100;
    }

    public final int getDrinkTime() {
        return this.drinkTime;
    }

    public final int getManaRevive() {
        return this.manaRevive;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        MutableComponent mutableComponent = Component.translatable((String)"item.small_mana_bottle.revive");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!(user instanceof Player)) {
            return stack;
        }
        if (!level.isClientSide) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)user, stack);
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = ((ServerPlayer)user).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            MagicPlayerData magicPlayerData = manaServerState.getDataFromServer(uUID);
            magicPlayerData.setMana(magicPlayerData.getMana() + this.manaRevive);
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)UsefulMagicItems.INSTANCE.getSMALL_MANA_BOTTLE().getItem());
        }
        if (!((Player)user).isCreative()) {
            ItemStack stack2 = new ItemStack((ItemLike)UsefulMagicItems.INSTANCE.getSMALL_MANA_BOTTLE().getItem());
            if (!((Player)user).getInventory().add(stack2)) {
                ((Player)user).drop(stack2, false);
            }
        }
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.drinkTime;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        MagicPlayerData data;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world.isClientSide) {
            v0 = ClientManaManager.INSTANCE.getData();
        } else {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v0 = data = manaServerState.getDataFromServer(uUID);
        }
        if (data.isFull() && !user.isCreative()) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)user.getItemInHand(hand));
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"startUsingInstantly(...)");
        return interactionResultHolder;
    }
}

