/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.type.EmittersShootTypes;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.usefulmagic.items.UsefulMagicToolMaterials;
import cn.coostack.usefulmagic.particles.barrages.wand.NetheriteSwordBarrage;
import cn.coostack.usefulmagic.particles.emitters.DirectionShootEmitters;
import cn.coostack.usefulmagic.particles.emitters.LineEmitters;
import cn.coostack.usefulmagic.skill.api.EntitySkillManager;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.player.ComboCondition;
import cn.coostack.usefulmagic.skill.player.HeavyHitSkill;
import cn.coostack.usefulmagic.skill.player.PlayerSwordLightSkill;
import cn.coostack.usefulmagic.skill.player.PlayerSwordSlashSkill;
import cn.coostack.usefulmagic.states.ComboState;
import cn.coostack.usefulmagic.utils.ComboUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J(\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J0\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010&\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020!H\u0002J \u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0*2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020!H\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00060"}, d2={"Lcn/coostack/usefulmagic/items/weapon/MagicAxe;", "Lnet/minecraft/world/item/AxeItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "postHurtEnemy", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "attacker", "hurtEnemy", "", "use", "Lnet/minecraft/world/InteractionResultHolder;", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "releaseUsing", "remainingUseTicks", "", "finishUsingItem", "inventoryTick", "entity", "Lnet/minecraft/world/entity/Entity;", "slot", "selected", "getUseDuration", "maceHit", "knockbackNearbyEntities", "player", "attacked", "getKnockbackPredicate", "Ljava/util/function/Predicate;", "getKnockback", "", "distance", "Lnet/minecraft/world/phys/Vec3;", "Companion", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMagicAxe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicAxe.kt\ncn/coostack/usefulmagic/items/weapon/MagicAxe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n1#2:345\n1869#3,2:346\n1869#3,2:348\n*S KotlinDebug\n*F\n+ 1 MagicAxe.kt\ncn/coostack/usefulmagic/items/weapon/MagicAxe\n*L\n309#1:346,2\n150#1:348,2\n*E\n"})
public final class MagicAxe
extends AxeItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Random random;
    @NotNull
    private static final HashMap<UUID, EntitySkillManager> playerSkills = new HashMap();

    public MagicAxe(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super((Tier)UsefulMagicToolMaterials.MAGIC, settings);
        this.random = new Random(System.currentTimeMillis());
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public void postHurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        if (!(attacker instanceof ServerPlayer)) {
            super.postHurtEnemy(stack, target, attacker);
            return;
        }
        UUID uUID = ((ServerPlayer)attacker).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ComboState state = ComboUtil.INSTANCE.getComboState(uUID);
        state.increase();
        super.postHurtEnemy(stack, target, attacker);
        if (state.getCount() > 6 && this.random.nextDouble() > 0.8) {
            Vec3 direction = ((ServerPlayer)attacker).getForward();
            CooParticlesAPI.scheduler.runTaskTimerMaxTick(2, 6, () -> MagicAxe.postHurtEnemy$lambda$0(attacker, this, direction));
        }
        if (state.getCount() < 3) {
            return;
        }
        Vec3 targetPos = target.getEyePosition().add(0.0, -0.5, 0.0);
        Vec3 spawnPos = targetPos.add(this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0));
        Intrinsics.checkNotNull((Object)spawnPos);
        Intrinsics.checkNotNull((Object)targetPos);
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)spawnPos, (Vec3)targetPos);
        CooParticlesAPI.scheduler.runTask(10, () -> MagicAxe.postHurtEnemy$lambda$6(spawnPos, attacker, targetPos, dir));
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        this.maceHit(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Skill skill;
        Object v2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world.isClientSide || !(user instanceof ServerPlayer)) {
            InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
            return interactionResultHolder;
        }
        ItemStack stack = user.getItemInHand(hand);
        EntitySkillManager skillManager = Companion.getSkillManager((ServerPlayer)user);
        if (skillManager.hasActiveSkill()) {
            InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
            return interactionResultHolder;
        }
        Iterable iterable = skillManager.getSkills(arg_0 -> MagicAxe.use$lambda$7(user, arg_0)).entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v2 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v2 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.skill.player.ComboCondition");
                int n = ((ComboCondition)v).getTriggerComboMin();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-MagicAxe$use$choice$2 = false;
                    Object v3 = it2.getValue();
                    Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.skill.player.ComboCondition");
                    int n2 = ((ComboCondition)v3).getTriggerComboMin();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator.hasNext());
                v2 = t;
            }
        }
        Map.Entry entry = v2;
        if (entry == null || (skill = (Skill)entry.getValue()) == null) {
            InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
            return interactionResultHolder;
        }
        Skill choice = skill;
        skillManager.setActiveSkill(choice, false);
        user.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        super.releaseUsing(stack, world, user, remainingUseTicks);
        if (world.isClientSide) {
            return;
        }
        if (!(user instanceof ServerPlayer)) {
            return;
        }
        EntitySkillManager skillManager = Companion.getSkillManager((ServerPlayer)user);
        if (skillManager.hasActiveSkill()) {
            skillManager.resetActiveSkill(false);
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            ItemStack itemStack = super.finishUsingItem(stack, world, user);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
            return itemStack;
        }
        if (!(user instanceof ServerPlayer)) {
            ItemStack itemStack = super.finishUsingItem(stack, world, user);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
            return itemStack;
        }
        EntitySkillManager skillManager = Companion.getSkillManager((ServerPlayer)user);
        if (skillManager.hasActiveSkill()) {
            skillManager.resetActiveSkill(false);
        }
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity entity, int slot, boolean selected) {
        ControlableParticleData controlableParticleData;
        DirectionShootEmitters directionShootEmitters;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!selected) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        UUID uUID = ((ServerPlayer)entity).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ComboState state = ComboUtil.INSTANCE.getComboState(uUID);
        if (state.getCount() < 3) {
            return;
        }
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        DirectionShootEmitters $this$inventoryTick_u24lambda_u2410 = directionShootEmitters = new DirectionShootEmitters(vec3, world);
        boolean bl = false;
        $this$inventoryTick_u24lambda_u2410.setMaxTick(1);
        $this$inventoryTick_u24lambda_u2410.setShootDirection(new Vec3(0.0, 1.0, 0.0));
        $this$inventoryTick_u24lambda_u2410.setRandomX(0.2);
        $this$inventoryTick_u24lambda_u2410.setRandomZ(0.2);
        $this$inventoryTick_u24lambda_u2410.setRandomY(0.1);
        $this$inventoryTick_u24lambda_u2410.setSpeedDrag(0.98);
        $this$inventoryTick_u24lambda_u2410.setCount(3);
        $this$inventoryTick_u24lambda_u2410.setShootType(EmittersShootTypes.box((HitBox)HitBox.Companion.of(1.0, 0.5, 1.0)));
        $this$inventoryTick_u24lambda_u2410.setGravity(0.05);
        ControlableParticleData $this$inventoryTick_u24lambda_u2410_u24lambda_u249 = controlableParticleData = $this$inventoryTick_u24lambda_u2410.getTemplateData();
        boolean bl2 = false;
        $this$inventoryTick_u24lambda_u2410_u24lambda_u249.setSpeed(0.3);
        $this$inventoryTick_u24lambda_u2410_u24lambda_u249.setMaxAge(20);
        UUID uUID2 = $this$inventoryTick_u24lambda_u2410_u24lambda_u249.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
        $this$inventoryTick_u24lambda_u2410_u24lambda_u249.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID2, false, 2, null));
        DirectionShootEmitters emitter = directionShootEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!(user instanceof ServerPlayer)) {
            return super.getUseDuration(stack, user);
        }
        EntitySkillManager manager = Companion.getSkillManager((ServerPlayer)user);
        if (!manager.hasActiveSkill()) {
            return super.getUseDuration(stack, user);
        }
        Skill skill = manager.getActive();
        Intrinsics.checkNotNull((Object)skill);
        return skill.getMaxHoldingTick(user);
    }

    private final void maceHit(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof ServerPlayer)) {
            return;
        }
        if (!MaceItem.canSmashAttack((LivingEntity)attacker)) {
            return;
        }
        Level level = attacker.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverWorld = (ServerLevel)level;
        if (((ServerPlayer)attacker).isIgnoringFallDamageFromCurrentImpulse() && ((ServerPlayer)attacker).currentImpulseImpactPos != null) {
            Vec3 vec3 = ((ServerPlayer)attacker).currentImpulseImpactPos;
            Intrinsics.checkNotNull((Object)vec3);
            if (vec3.y > attacker.position().y) {
                ((ServerPlayer)attacker).currentImpulseImpactPos = attacker.position();
            }
        } else {
            ((ServerPlayer)attacker).currentImpulseImpactPos = attacker.position();
        }
        ((ServerPlayer)attacker).setIgnoreFallDamageFromCurrentImpulse(true);
        Vec3 vel = ((ServerPlayer)attacker).getDeltaMovement();
        ((ServerPlayer)attacker).setDeltaMovement(vel.with(Direction.Axis.Y, 0.01));
        ((ServerPlayer)attacker).connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)attacker));
        if (target.onGround()) {
            ((ServerPlayer)attacker).setSpawnExtraParticlesOnFall(true);
            SoundEvent soundEvent = attacker.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
            serverWorld.playSound(null, ((ServerPlayer)attacker).getX(), ((ServerPlayer)attacker).getY(), ((ServerPlayer)attacker).getZ(), soundEvent, ((ServerPlayer)attacker).getSoundSource(), 1.0f, 1.0f);
        } else {
            serverWorld.playSound(null, ((ServerPlayer)attacker).getX(), ((ServerPlayer)attacker).getY(), ((ServerPlayer)attacker).getZ(), SoundEvents.MACE_SMASH_AIR, ((ServerPlayer)attacker).getSoundSource(), 1.0f, 1.0f);
        }
        this.knockbackNearbyEntities((Level)serverWorld, (Player)attacker, (Entity)target);
    }

    /*
     * WARNING - void declaration
     */
    private final void knockbackNearbyEntities(Level world, Player player, Entity attacked) {
        void $this$forEach$iv;
        world.levelEvent(2013, attacked.blockPosition(), 750);
        List list = world.getEntitiesOfClass(LivingEntity.class, attacked.getBoundingBox().inflate(3.5), this.getKnockbackPredicate(player, attacked));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        Iterable iterable = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity entity = (LivingEntity)element$iv;
            boolean bl = false;
            if (entity == null) continue;
            Vec3 vec = entity.position().subtract(attacked.position());
            Intrinsics.checkNotNull((Object)vec);
            double d = this.getKnockback(player, entity, vec);
            Vec3 pushVec = vec.normalize().scale(d);
            if (!(d > 0.0)) continue;
            entity.push(pushVec.x, 0.7, pushVec.z);
            if (!(entity instanceof ServerPlayer)) continue;
            ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        }
    }

    private final Predicate<LivingEntity> getKnockbackPredicate(Player player, Entity attacked) {
        return arg_0 -> MagicAxe.getKnockbackPredicate$lambda$12(player, attacked, arg_0);
    }

    public final double getKnockback(@NotNull Player player, @NotNull LivingEntity attacked, @NotNull Vec3 distance) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)attacked, (String)"attacked");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        return (3.5 - distance.length()) * (double)0.7f * (double)(player.fallDistance > 5.0f ? 2 : 1) * (1.0 - attacked.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    private static final void postHurtEnemy$lambda$0(LivingEntity $attacker, MagicAxe this$0, Vec3 $direction) {
        Vec3 spawnPos = ((ServerPlayer)$attacker).getEyePosition().add(this$0.random.nextDouble(-3.0, 3.0), this$0.random.nextDouble(-0.5, 2.0), this$0.random.nextDouble(-3.0, 3.0));
        Intrinsics.checkNotNull((Object)spawnPos);
        Level level = $attacker.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        NetheriteSwordBarrage barrage = new NetheriteSwordBarrage(spawnPos, (ServerLevel)level, 5.0, (Player)$attacker, 1.5);
        Intrinsics.checkNotNull((Object)$direction);
        barrage.setDirection($direction);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        Vec3 loc = barrage.getLoc();
        $attacker.level().playSound(null, loc.x, loc.y, loc.z, SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.PLAYERS, 3.0f, 1.5f);
    }

    private static final boolean postHurtEnemy$lambda$6$lambda$3(LivingEntity $attacker, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$attacker).getUUID());
    }

    private static final boolean postHurtEnemy$lambda$6$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void postHurtEnemy$lambda$6(Vec3 $spawnPos, LivingEntity $attacker, Vec3 $targetPos, Vec3 $dir) {
        void $this$forEach$iv;
        LineEmitters lineEmitters;
        Intrinsics.checkNotNull((Object)$spawnPos);
        Object $this$postHurtEnemy_u24lambda_u246_u24lambda_u242 = lineEmitters = new LineEmitters($spawnPos, $attacker.level());
        boolean bl = false;
        ControlableParticleData controlableParticleData = $this$postHurtEnemy_u24lambda_u246_u24lambda_u242.getTemplateData();
        ControlableParticleData $this$postHurtEnemy_u24lambda_u246_u24lambda_u242_u24lambda_u241 = controlableParticleData;
        boolean bl2 = false;
        UUID uUID = $this$postHurtEnemy_u24lambda_u246_u24lambda_u242_u24lambda_u241.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242_u24lambda_u241.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242_u24lambda_u241.setMaxAge(15);
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242_u24lambda_u241.setSize(0.1f);
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242.setMaxTick(1);
        Vec3 vec3 = $dir.scale(2.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242.setEndPos(vec3);
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242.setCount((int)($dir.length() * (double)3));
        LineEmitters emitter = lineEmitters;
        Level world = $attacker.level();
        world.playSound(null, ((ServerPlayer)$attacker).getX(), ((ServerPlayer)$attacker).getY(), ((ServerPlayer)$attacker).getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 10.0f, 2.0f);
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        List list = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)$targetPos, (double)4.0, (double)4.0, (double)4.0), arg_0 -> MagicAxe.postHurtEnemy$lambda$6$lambda$4(arg_0 -> MagicAxe.postHurtEnemy$lambda$6$lambda$3($attacker, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        $this$postHurtEnemy_u24lambda_u246_u24lambda_u242 = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl3 = false;
            DamageSource source = it.damageSources().playerAttack((Player)$attacker);
            it.invulnerableTime = 0;
            it.hurt(source, 5.0f);
        }
    }

    private static final boolean use$lambda$7(Player $user, Skill it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ComboCondition && ((ComboCondition)((Object)it)).canTrigger((LivingEntity)$user);
    }

    private static final boolean getKnockbackPredicate$lambda$12(Player $player, Entity $attacked, LivingEntity entity) {
        LivingEntity livingEntity = entity;
        Intrinsics.checkNotNull((Object)livingEntity);
        boolean bl = !livingEntity.isSpectator();
        boolean bl2 = entity != $player && entity != $attacked;
        boolean bl3 = !$player.isAlliedTo((Entity)entity);
        boolean bl4 = !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).isTame() || !Intrinsics.areEqual((Object)$player.getUUID(), (Object)((TamableAnimal)entity).getOwnerUUID());
        boolean bl5 = !(entity instanceof ArmorStand) || !((ArmorStand)entity).isMarker();
        boolean bl6 = $attacked.distanceToSqr((Entity)entity) <= Math.pow(3.5, 2.0);
        return bl && bl2 && bl3 && bl4 && bl5 && bl6;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcn/coostack/usefulmagic/items/weapon/MagicAxe$Companion;", "", "<init>", "()V", "playerSkills", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcn/coostack/usefulmagic/skill/api/EntitySkillManager;", "getPlayerSkills", "()Ljava/util/HashMap;", "getSkillManager", "player", "Lnet/minecraft/server/level/ServerPlayer;", "postPlayerAxeSkillTick", "", "usefulmagic-neoforge-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nMagicAxe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicAxe.kt\ncn/coostack/usefulmagic/items/weapon/MagicAxe$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,344:1\n382#2,7:345\n216#3,2:352\n*S KotlinDebug\n*F\n+ 1 MagicAxe.kt\ncn/coostack/usefulmagic/items/weapon/MagicAxe$Companion\n*L\n63#1:345,7\n78#1:352,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<UUID, EntitySkillManager> getPlayerSkills() {
            return playerSkills;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final EntitySkillManager getSkillManager(@NotNull ServerPlayer player) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Map map = this.getPlayerSkills();
            UUID key$iv = player.getUUID();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                EntitySkillManager entitySkillManager;
                boolean bl = false;
                EntitySkillManager $this$getSkillManager_u24lambda_u241_u24lambda_u240 = entitySkillManager = new EntitySkillManager((LivingEntity)player);
                boolean bl2 = false;
                $this$getSkillManager_u24lambda_u241_u24lambda_u240.addSkill(new HeavyHitSkill(7.0f));
                $this$getSkillManager_u24lambda_u241_u24lambda_u240.addSkill(new PlayerSwordSlashSkill(4.0f));
                $this$getSkillManager_u24lambda_u241_u24lambda_u240.addSkill(new PlayerSwordLightSkill());
                EntitySkillManager answer$iv = entitySkillManager;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map = object;
            EntitySkillManager it = (EntitySkillManager)((Object)map);
            boolean bl = false;
            it.setOwner((LivingEntity)player);
            return (EntitySkillManager)((Object)map);
        }

        public final void postPlayerAxeSkillTick() {
            Map $this$forEach$iv = this.getPlayerSkills();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                ((EntitySkillManager)it.getValue()).tick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

