/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.particles.barrages.wand.CopperBarrage;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J(\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016\u00a8\u0006 "}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/CopperWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "repairCandidate", "onUseTick", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "remainingUseTicks", "", "finishUsingItem", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCopperWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopperWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/CopperWand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n*S KotlinDebug\n*F\n+ 1 CopperWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/CopperWand\n*L\n82#1:137,2\n*E\n"})
public final class CopperWand
extends WandItem {
    public CopperWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 50, 20.0);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.copper_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack repairCandidate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)repairCandidate, (String)"repairCandidate");
        Item item = Items.COPPER_INGOT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"COPPER_INGOT");
        return ItemExtendKt.isOf(repairCandidate, item);
    }

    /*
     * WARNING - void declaration
     */
    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        int times;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (world.isClientSide) {
            return;
        }
        int usingTime = this.getUseDuration(stack, user) - remainingUseTicks;
        Vec3 newPos = user.getEyePosition().add(user.getForward().scale(5.0));
        if (usingTime % 2 == 0) {
            SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            ServerLevel serverLevel = (ServerLevel)world;
            Intrinsics.checkNotNull((Object)newPos);
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, newPos, new Vec3(1.0, 1.0, 1.0), true, 0.04, 3, 60.0);
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        if (usingTime % 10 == 0 && (times = usingTime / 10) > 0 && times != 6) {
            void $this$forEach$iv;
            world.playSound(null, user.position().x, user.position().y, user.position().z, SoundEvents.TRIDENT_HIT_GROUND, SoundSource.PLAYERS, 10.0f, (float)times * 0.6f);
            PointsBuilder pointsBuilder = new PointsBuilder().addCircle(3.0, 300);
            Vec3 vec3 = user.getForward();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getForward(...)");
            Iterable iterable = pointsBuilder.rotateTo(vec3).create();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RelativeLocation it = (RelativeLocation)element$iv;
                boolean bl = false;
                SimpleParticleType simpleParticleType = ParticleTypes.SMOKE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"SMOKE");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Vec3 vec32 = it.toVector().add(newPos);
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec32, it.normalize().multiply(-0.2).toVector(), 64.0);
            }
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return stack;
        }
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        stack.hurtAndBreak(1, (ServerLevel)world, (ServerPlayer)user, arg_0 -> CopperWand.finishUsingItem$lambda$1(world, user, arg_0));
        world.playSound(null, user.position().x, user.position().y, user.position().z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 10.0f, 3.0f);
        double d = this.getDamage();
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        CopperBarrage barrage = new CopperBarrage(d, user, vec3, (ServerLevel)world);
        Vec3 vec32 = ((ServerPlayer)user).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getForward(...)");
        barrage.setDirection(vec32);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        this.cost((ServerPlayer)user);
        ((ServerPlayer)user).getCooldowns().addCooldown((Item)this, 60);
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 60;
    }

    private static final void finishUsingItem$lambda$1(Level $world, LivingEntity $user, Item it) {
        ServerLevel serverLevel = (ServerLevel)$world;
        Vec3 vec3 = $user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        serverLevel.playSound(null, BlockPosExtendsKt.ofFloored((Vec3)vec3), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 5.0f, 1.0f);
    }
}

