/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.particles.barrages.wand.DiamondSwordBarrage;
import cn.coostack.usefulmagic.particles.style.wand.DiamondWandStyle;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0016J \u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010$\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0012H\u0016J(\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u001eH\u0016R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/DiamondWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "options", "", "getOptions", "()I", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "ingredient", "finishUsingItem", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "rangeBall", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getRangeBall", "()Ljava/util/List;", "onUseTick", "remainingUseTicks", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
public final class DiamondWand
extends WandItem {
    @NotNull
    private final List<RelativeLocation> rangeBall;

    public DiamondWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 100, 6.0);
        this.rangeBall = new PointsBuilder().addBall(64.0, 6 * this.getOptions()).create();
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.diamond_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Item item = Items.DIAMOND;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"DIAMOND");
        return ItemExtendKt.isOf(ingredient, item);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return stack;
        }
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        ((ServerPlayer)user).getCooldowns().addCooldown((Item)this, 20);
        List rounds = Math3DUtil.INSTANCE.getRoundScapeLocations(8.0, 0.5, 10, 100);
        Vec3 vec3 = ((ServerPlayer)user).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getForward(...)");
        Math3DUtil.INSTANCE.rotatePointsToPoint(rounds, RelativeLocation.Companion.of(vec3), RelativeLocation.Companion.yAxis());
        Vec3 direction = ((ServerPlayer)user).getForward();
        Vec3 pos = ((ServerPlayer)user).getEyePosition();
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(2, 48, () -> DiamondWand.finishUsingItem$lambda$0(pos, rounds, world, this, user, direction));
        this.cost((ServerPlayer)user);
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    @NotNull
    public final List<RelativeLocation> getRangeBall() {
        return this.rangeBall;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        int max = this.getUseDuration(stack, user);
        if (world.isClientSide) {
            return;
        }
        if (tick2 % 3 == 0) {
            int n = tick2 < max / 2 ? 10 : 20;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                RelativeLocation it2 = (RelativeLocation)CollectionsKt.random((Collection)this.rangeBall, (Random)((Random)Random.Default));
                Vec3 pos = user.position().add(it2.toVector());
                RelativeLocation dir = it2.normalize().multiply(-5.8);
                SimpleParticleType simpleParticleType = ParticleTypes.END_ROD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"END_ROD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Intrinsics.checkNotNull((Object)pos);
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, pos, dir.toVector());
            }
        }
        if (tick2 % 5 == 0) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 1.5f);
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder<ItemStack> res = super.use(world, user, hand);
        if (!res.getResult().consumesAction()) {
            return res;
        }
        if (world.isClientSide) {
            return res;
        }
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        DiamondWandStyle style = new DiamondWandStyle(uUID, null, 2, null);
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
        return res;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 100;
    }

    private static final void finishUsingItem$lambda$0(Vec3 $pos, List $rounds, Level $world, DiamondWand this$0, LivingEntity $user, Vec3 $direction) {
        Vec3 vec3 = $pos.add(((RelativeLocation)CollectionsKt.random((Collection)$rounds, (Random)((Random)Random.Default))).toVector());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        DiamondSwordBarrage barrage = new DiamondSwordBarrage(vec3, (ServerLevel)$world, this$0.getDamage(), (Player)$user, 1.0);
        Intrinsics.checkNotNull((Object)$direction);
        barrage.setDirection($direction);
        barrage.setShooter($user);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        Vec3 loc = barrage.getLoc();
        $world.playSound(null, loc.x, loc.y, loc.z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 1.5f);
    }
}

