/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.particles.barrages.wand.GoldenMagicBallBarrage;
import cn.coostack.usefulmagic.particles.style.wand.GoldenWandStyle;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J \u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001aH\u0016\u00a8\u0006%"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/GoldenWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "ingredient", "finishUsingItem", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "onUseTick", "remainingUseTicks", "", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
public final class GoldenWand
extends WandItem {
    public GoldenWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 80, 4.0);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.golden_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Item item = Items.GOLD_INGOT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"GOLD_INGOT");
        return ItemExtendKt.isOf(ingredient, item);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return stack;
        }
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        GoldenMagicBallBarrage barrage = new GoldenMagicBallBarrage(vec3, (ServerLevel)world, this.getDamage());
        barrage.setShooter(user);
        Vec3 vec32 = ((ServerPlayer)user).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getForward(...)");
        barrage.setDirection(vec32);
        world.playSound(null, ((ServerPlayer)user).getX(), ((ServerPlayer)user).getY(), ((ServerPlayer)user).getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 1.2f);
        ((ServerPlayer)user).getCooldowns().addCooldown((Item)this, 30);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        this.cost((ServerPlayer)user);
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        if (world.isClientSide) {
            return;
        }
        Vec3 newPos = user.getEyePosition().add(user.getForward().scale(5.0));
        if (tick2 % 10 == 0) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 3.0f, 0.8f);
        }
        if (tick2 % 2 == 0) {
            SimpleParticleType simpleParticleType = ParticleTypes.ENCHANT;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"ENCHANT");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            ServerLevel serverLevel = (ServerLevel)world;
            Intrinsics.checkNotNull((Object)newPos);
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, newPos, new Vec3(2.0, 2.0, 2.0), true, 0.04, 10, 60.0);
            PointsBuilder pointsBuilder = new PointsBuilder().addCircle(6.0, 32);
            Vec3 vec3 = user.getForward();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getForward(...)");
            List points = pointsBuilder.rotateTo(vec3).create();
            int n = 16;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                RelativeLocation it2 = (RelativeLocation)CollectionsKt.random((Collection)points, (Random)((Random)Random.Default));
                SimpleParticleType simpleParticleType2 = ParticleTypes.CLOUD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType2, (String)"CLOUD");
                ParticleOptions particleOptions2 = (ParticleOptions)simpleParticleType2;
                ServerLevel serverLevel2 = (ServerLevel)world;
                Vec3 vec32 = newPos.add(it2.toVector());
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions2, serverLevel2, vec32, it2.normalize().multiply(-0.3).toVector(), 60.0);
            }
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder<ItemStack> res = super.use(world, user, hand);
        if (!res.getResult().consumesAction()) {
            return res;
        }
        if (world.isClientSide) {
            return res;
        }
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        GoldenWandStyle style = new GoldenWandStyle(uUID, null, 2, null);
        Vec3 vec3 = user.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
        return res;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 60;
    }
}

