/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.items.UsefulMagicItems;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.particles.style.EnchantLineStyle;
import cn.coostack.usefulmagic.particles.style.wand.HealthReviveStyle;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001c\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J(\u0010%\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0007H\u0016J(\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u001a\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/HealthReviveWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "reviveAmount", "", "getReviveAmount", "()I", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getUseDuration", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "options", "getOptions", "finishUsingItem", "world", "Lnet/minecraft/world/level/Level;", "user", "rangeBall", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getRangeBall", "()Ljava/util/List;", "onUseTick", "remainingUseTicks", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "isValidRepairItem", "", "ingredient", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHealthReviveWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealthReviveWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/HealthReviveWand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1869#2:278\n1869#2,2:279\n1870#2:281\n1869#2,2:282\n1869#2,2:284\n*S KotlinDebug\n*F\n+ 1 HealthReviveWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/HealthReviveWand\n*L\n99#1:278\n102#1:279,2\n99#1:281\n147#1:282,2\n155#1:284,2\n*E\n"})
public final class HealthReviveWand
extends WandItem {
    private final int reviveAmount;
    @NotNull
    private final List<RelativeLocation> rangeBall;

    public HealthReviveWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 500, 0.0);
        this.reviveAmount = 60;
        this.rangeBall = new PointsBuilder().addBall(12.0, 6 * this.getOptions()).create();
    }

    public final int getReviveAmount() {
        return this.reviveAmount;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.health_revive_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        String string = Component.translatable((String)"item.health_wand.amount").getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        tooltip.set(2, (Component)Component.literal((String)StringsKt.replace$default((String)string, (String)"%amount%", (String)String.valueOf(this.reviveAmount), (boolean)false, (int)4, null)));
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 120;
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Iterable $this$forEach$iv;
        void $this$forEach$iv2;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ItemStack res = super.finishUsingItem(stack, world, user);
        if (!(user instanceof Player)) {
            Intrinsics.checkNotNull((Object)res);
            return res;
        }
        ((Player)user).getCooldowns().addCooldown(UsefulMagicItems.INSTANCE.getHEALTH_REVIVE_WAND().getItem(), 60);
        if (world.isClientSide) {
            return stack;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        ServerPlayer cfr_ignored_1 = (ServerPlayer)user;
        this.cost((ServerPlayer)user);
        world.playSound(null, ((ServerPlayer)user).getX(), ((ServerPlayer)user).getY(), ((ServerPlayer)user).getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 3.0f, 1.0f);
        Iterable iterable = Math3DUtil.INSTANCE.generateExplosionCurve(1.2, 8.0, 12.0, 0.5, 3 * this.getOptions(), 15 * this.getOptions());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv3 = new PointsBuilder().addLine(new RelativeLocation(), it, (int)(it.length() * (double)3)).create();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                RelativeLocation pos = (RelativeLocation)element$iv2;
                boolean bl2 = false;
                SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Vec3 vec3 = user.position().add(pos.toVector());
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec3, it.normalize().multiply(it.getY() / (double)3).toVector());
            }
        }
        Vec3 direction = ((ServerPlayer)user).getForward().normalize();
        Vec3 currentPos = ((ServerPlayer)user).getEyePosition();
        Object find = null;
        find = user;
        for (int i = 1; i < 31; ++i) {
            currentPos = currentPos.add(direction);
            List entities = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)currentPos, (double)1.0, (double)1.0, (double)1.0), arg_0 -> HealthReviveWand.finishUsingItem$lambda$3(arg_0 -> HealthReviveWand.finishUsingItem$lambda$2(user, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)entities);
            if (!(!((Collection)entities).isEmpty())) continue;
            Object object = CollectionsKt.first((List)entities);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            find = object;
            break;
        }
        LivingEntity i = find;
        i.setHealth(i.getHealth() + (float)this.reviveAmount);
        find.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 4800, 2), (Entity)user);
        find.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 4800, 0), (Entity)user);
        find.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 4800, 2), (Entity)user);
        find.addEffect(new MobEffectInstance(MobEffects.HEAL, 200, 1), (Entity)user);
        if (!Intrinsics.areEqual((Object)find, (Object)user)) {
            PointsBuilder pointsBuilder = new PointsBuilder();
            Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
            i = currentPos;
            Intrinsics.checkNotNull((Object)i);
            $this$forEach$iv = pointsBuilder.addLine(vec3, (Vec3)i, MathKt.roundToInt((double)currentPos.distanceTo(((ServerPlayer)user).getEyePosition())) * 10).create();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                RelativeLocation it = (RelativeLocation)element$iv;
                boolean bl = false;
                SimpleParticleType simpleParticleType = ParticleTypes.END_ROD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"END_ROD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Vec3 vec32 = it.toVector();
                Vec3 vec33 = Vec3.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec32, vec33, 64.0);
            }
        }
        $this$forEach$iv = new PointsBuilder().addBall(1.0, 8).create();
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl = false;
            SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 vec3 = find.getEyePosition();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec3, it.toVector(), 64.0);
        }
        List create = new PointsBuilder().addRoundShape(16.0, 2.0, 10, 60).pointsOnEach(HealthReviveWand::finishUsingItem$lambda$6).create();
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(1, 30, () -> HealthReviveWand.finishUsingItem$lambda$10(create, world, user));
        return stack;
    }

    @NotNull
    public final List<RelativeLocation> getRangeBall() {
        return this.rangeBall;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        int it;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int max = this.getUseDuration(stack, user);
        int tick2 = max - remainingUseTicks;
        if (world.isClientSide) {
            return;
        }
        Random random = new Random(System.currentTimeMillis());
        if (tick2 % 3 == 0) {
            n2 = tick2 < max / 2 ? 10 : 20;
            n = 0;
            while (n < n2) {
                it = n++;
                boolean bl = false;
                RelativeLocation it2 = (RelativeLocation)CollectionsKt.random((Collection)this.rangeBall, (kotlin.random.Random)((kotlin.random.Random)kotlin.random.Random.Default));
                Vec3 pos = user.position().add(it2.toVector());
                RelativeLocation dir = it2.normalize().multiply(-0.6);
                SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Intrinsics.checkNotNull((Object)pos);
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, pos, dir.toVector());
            }
        }
        if (tick2 % 4 == 0) {
            n2 = 6;
            n = 0;
            while (n < n2) {
                EnchantLineStyle style;
                EnchantLineStyle enchantLineStyle;
                it = n++;
                boolean bl = false;
                double x = random.nextDouble(-10.0, 10.0);
                double y = random.nextDouble(-5.0, 10.0);
                double z = random.nextDouble(-10.0, 10.0);
                Vec3 pos = user.getEyePosition().add(x, y, z);
                RelativeLocation line = new RelativeLocation(0.0, random.nextDouble(2.0, 4.0), 0.0);
                int count = MathKt.roundToInt((double)(line.length() * (double)2));
                EnchantLineStyle $this$onUseTick_u24lambda_u2413_u24lambda_u2412 = enchantLineStyle = (style = new EnchantLineStyle(line, count, random.nextInt(40, 60), null, 8, null));
                boolean bl2 = false;
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.setParticleRandomAgePreTick(true);
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.setFade(true);
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.setFadeInTick(30);
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.setFadeOutTick(30);
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.colorOf(144, 252, 167);
                $this$onUseTick_u24lambda_u2413_u24lambda_u2412.setSpeedDirection(new RelativeLocation(0.0, random.nextDouble(-0.1, 0.1), 0.0));
                Intrinsics.checkNotNull((Object)pos);
                ParticleStyleManager.INSTANCE.spawnStyle(world, pos, (ParticleGroupStyle)style);
            }
        }
        if (tick2 % 5 == 0) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 1.5f);
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder<ItemStack> res = super.use(world, user, hand);
        if (!res.getResult().consumesAction()) {
            return res;
        }
        if (world.isClientSide) {
            return res;
        }
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        UUID uUID2 = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
        HealthReviveStyle style = new HealthReviveStyle(uUID, uUID2);
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
        return res;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return false;
    }

    private static final boolean finishUsingItem$lambda$2(LivingEntity $user, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$user).getUUID());
    }

    private static final boolean finishUsingItem$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit finishUsingItem$lambda$6(RelativeLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setY(it.getY() - 1.0);
        return Unit.INSTANCE;
    }

    private static final void finishUsingItem$lambda$10(List $create, Level $world, LivingEntity $user) {
        RelativeLocation point;
        int it;
        int n = 30;
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            point = (RelativeLocation)CollectionsKt.random((Collection)$create, (kotlin.random.Random)((kotlin.random.Random)kotlin.random.Random.Default));
            SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            Level level = $world;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = $user.position().add(point.toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec3, new Vec3(0.0, 3.0, 0.0));
        }
        n = 10;
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            point = (RelativeLocation)CollectionsKt.random((Collection)$create, (kotlin.random.Random)((kotlin.random.Random)kotlin.random.Random.Default));
            SimpleParticleType simpleParticleType = ParticleTypes.END_ROD;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"END_ROD");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            Level level = $world;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = $user.position().add(point.toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec3, new Vec3(0.0, 5.0, 0.0));
        }
        n = 5;
        n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            point = (RelativeLocation)CollectionsKt.random((Collection)$create, (kotlin.random.Random)((kotlin.random.Random)kotlin.random.Random.Default));
            SimpleParticleType simpleParticleType = ParticleTypes.FLAME;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"FLAME");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            Level level = $world;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = $user.position().add(point.toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec3, new Vec3(0.0, 2.0, 0.0));
        }
    }
}

