/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.formation.CrystalFormation;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.particles.emitters.LightningParticleEmitters;
import cn.coostack.usefulmagic.sounds.UsefulMagicSoundEvents;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J(\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/LightningWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "attenuation", "", "getAttenuation", "()D", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "ingredient", "onUseTick", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "remainingUseTicks", "", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nLightningWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightningWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/LightningWand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n2423#2,14:183\n*S KotlinDebug\n*F\n+ 1 LightningWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/LightningWand\n*L\n114#1:183,14\n*E\n"})
public final class LightningWand
extends WandItem {
    private final double attenuation;

    public LightningWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 20, 8.0);
        this.attenuation = 0.9;
    }

    public final double getAttenuation() {
        return this.attenuation;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.lightning_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        TagKey tagKey = ItemTags.PLANKS;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"PLANKS");
        return ItemExtendKt.isIn(ingredient, (TagKey<Item>)tagKey);
    }

    /*
     * WARNING - void declaration
     */
    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        ControlableParticleData controlableParticleData;
        LightningParticleEmitters lightningParticleEmitters;
        boolean canUse;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!world.isClientSide) {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v2 = manaServerState.getDataFromServer(uUID).canCost(this.getCost(), false);
        } else {
            v2 = canUse = ClientManaManager.INSTANCE.getSelfMana().canCost(this.getCost(), true);
        }
        if (!canUse) {
            user.stopUsingItem();
            return;
        }
        if (world.isClientSide) {
            return;
        }
        if (!(user instanceof ServerPlayer)) {
            return;
        }
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        if (tick2 % 5 != 0 || tick2 < 5) {
            return;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        world.playSound(null, ((ServerPlayer)user).getX(), ((ServerPlayer)user).getY(), ((ServerPlayer)user).getZ(), UsefulMagicSoundEvents.getELECTRIC_EFFECT().get(), SoundSource.PLAYERS, 6.0f, 1.0f);
        Vec3 direction = ((ServerPlayer)user).getForward().normalize();
        Ref.ObjectRef currentPos = new Ref.ObjectRef();
        currentPos.element = ((ServerPlayer)user).getEyePosition();
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID = ((ServerPlayer)user).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        MagicPlayerData data = manaServerState.getDataFromServer(uUID);
        for (int i = 1; i < 51; ++i) {
            boolean cant;
            currentPos.element = ((Vec3)currentPos.element).add(direction);
            List entities = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)((Vec3)currentPos.element), (double)4.0, (double)4.0, (double)4.0), arg_0 -> LightningWand.onUseTick$lambda$1(arg_0 -> LightningWand.onUseTick$lambda$0(user, data, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)entities);
            if (!((Collection)entities).isEmpty()) {
                HashSet<LivingEntity> damagedEntitySet = new HashSet<LivingEntity>();
                LivingEntity entity = (LivingEntity)CollectionsKt.first((List)entities);
                damagedEntitySet.add(entity);
                DamageSource source = entity.damageSources().playerAttack((Player)user);
                entity.setRemainingFireTicks(60);
                entity.hurt(source, (float)this.getDamage());
                entity.invulnerableTime = 0;
                Object prePos = null;
                prePos = currentPos.element;
                Object nextPos = null;
                nextPos = prePos;
                Object object = prePos;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
                Vec3 vec3 = (Vec3)object;
                Object object2 = nextPos;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)((Vec3)object2)).normalize().scale(4.5);
                for (int j = 1; j < 6; ++j) {
                    ControlableParticleData controlableParticleData2;
                    LivingEntity next;
                    Object v9;
                    void $this$minByOrNull$iv;
                    List list = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)((Vec3)prePos), (double)48.0, (double)48.0, (double)48.0), arg_0 -> LightningWand.onUseTick$lambda$4(arg_0 -> LightningWand.onUseTick$lambda$3(currentPos, world, user, damagedEntitySet, data, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
                    Object object3 = list;
                    boolean $i$f$minByOrNull = false;
                    Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v9 = null;
                    } else {
                        Object minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v9 = minElem$iv;
                        } else {
                            LivingEntity it = (LivingEntity)minElem$iv;
                            boolean bl = false;
                            double minValue$iv = ((Vec3)prePos).distanceTo(it.position());
                            do {
                                Object e$iv = iterator$iv.next();
                                LivingEntity it2 = (LivingEntity)e$iv;
                                $i$a$-minByOrNull-LightningWand$onUseTick$next$2 = false;
                                double v$iv = ((Vec3)prePos).distanceTo(it2.position());
                                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v9 = minElem$iv;
                        }
                    }
                    if ((LivingEntity)v9 == null) continue;
                    prePos = nextPos;
                    nextPos = next.getEyePosition();
                    next.setRemainingFireTicks(60);
                    next.hurt(source, (float)(this.getDamage() * Math.pow(this.attenuation, j)));
                    next.invulnerableTime = 0;
                    damagedEntitySet.add(next);
                    Object object4 = prePos;
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
                    Object $this$onUseTick_u24lambda_u247 = object3 = new LightningParticleEmitters((Vec3)object4, world);
                    boolean bl = false;
                    Object object5 = prePos;
                    Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"element");
                    Vec3 vec32 = (Vec3)object5;
                    Vec3 vec33 = nextPos.add(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
                    ((LightningParticleEmitters)((Object)$this$onUseTick_u24lambda_u247)).setEndPos(RelativeLocation.Companion.of(Vec3ExtendsKt.relativize((Vec3)vec32, (Vec3)vec33)));
                    $this$onUseTick_u24lambda_u247.setMaxTick(random.nextInt(1, 3));
                    ControlableParticleData it = controlableParticleData2 = ((LightningParticleEmitters)((Object)$this$onUseTick_u24lambda_u247)).getTemplateData();
                    boolean bl2 = false;
                    it.setColor(Math3DUtil.INSTANCE.colorOf(121, 211, 249));
                    it.setMaxAge(5);
                    Object lightning = object3;
                    ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)lightning);
                }
                break;
            }
            Object object = currentPos.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            BlockPos blockPos = BlockPosExtendsKt.ofFloored((Vec3)((Vec3)object));
            BlockState state = ((ServerLevel)world).getBlockState(blockPos);
            if (!state.isAir() && !state.getCollisionShape((BlockGetter)world, blockPos).isEmpty()) break;
            Object object6 = currentPos.element;
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"element");
            if (ServerFormationManager.INSTANCE.getFormationFromPos((Vec3)object6, (ServerLevel)world) != null) {
                BlockFormation it;
                boolean bl = false;
                LivingEntityTargetOption option = new LivingEntityTargetOption(user, false);
                if (it instanceof CrystalFormation && ((CrystalFormation)it).getHasDefend() && !((CrystalFormation)it).isFriendly(option)) {
                    CrystalFormation crystalFormation = (CrystalFormation)it;
                    FormationTargetOption formationTargetOption = option;
                    Object object7 = currentPos.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"element");
                    crystalFormation.attack(5.0f, formationTargetOption, (Vec3)object7);
                    v19 = true;
                } else {
                    v19 = false;
                }
            } else {
                v19 = cant = false;
            }
            if (cant) break;
        }
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        Object object = currentPos.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)((Vec3)object)).normalize().scale(4.5);
        Vec3 vec34 = ((ServerPlayer)user).getEyePosition().add(random.nextDouble(-1.0, 1.0), random.nextDouble(-1.0, 1.0), random.nextDouble(-1.0, 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"add(...)");
        LightningParticleEmitters $this$onUseTick_u24lambda_u2410 = lightningParticleEmitters = new LightningParticleEmitters(vec34, world);
        boolean bl = false;
        Vec3 vec35 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"getEyePosition(...)");
        Vec3 vec36 = ((Vec3)currentPos.element).add(dir);
        Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"add(...)");
        $this$onUseTick_u24lambda_u2410.setEndPos(RelativeLocation.Companion.of(Vec3ExtendsKt.relativize((Vec3)vec35, (Vec3)vec36)));
        $this$onUseTick_u24lambda_u2410.setMaxTick(random.nextInt(1, 6));
        ControlableParticleData it = controlableParticleData = $this$onUseTick_u24lambda_u2410.getTemplateData();
        boolean bl3 = false;
        it.setColor(Math3DUtil.INSTANCE.colorOf(121, 211, 249));
        it.setMaxAge(5);
        $this$onUseTick_u24lambda_u2410.setOffsetRange(3.0);
        LightningParticleEmitters lightning = lightningParticleEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)lightning);
        this.cost((ServerPlayer)user);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean onUseTick$lambda$0(LivingEntity $user, MagicPlayerData $data, LivingEntity it) {
        if (Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$user).getUUID())) return false;
        UUID uUID = it.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if ($data.isFriend(uUID)) return false;
        return true;
    }

    private static final boolean onUseTick$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean onUseTick$lambda$3(Ref.ObjectRef $currentPos, Level $world, LivingEntity $user, HashSet $damagedEntitySet, MagicPlayerData $data, LivingEntity it) {
        boolean bl;
        Object object = $currentPos.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        BlockFormation blockFormation = ServerFormationManager.INSTANCE.getFormationFromPos((Vec3)object, (ServerLevel)$world);
        if (blockFormation != null) {
            BlockFormation it2 = blockFormation;
            boolean bl2 = false;
            bl = it2 instanceof CrystalFormation && ((CrystalFormation)it2).getHasDefend();
        } else {
            bl = false;
        }
        boolean cant = bl;
        if (Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$user).getUUID())) return false;
        if ($damagedEntitySet.contains(it)) return false;
        if (cant) return false;
        UUID uUID = it.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        if ($data.isFriend(uUID)) return false;
        return true;
    }

    private static final boolean onUseTick$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

