/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.extend.Vec3ExtendKt;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.DefendCrystal;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.meteorite.impl.OptionMeteorite;
import cn.coostack.usefulmagic.particles.emitters.ExplodeMagicEmitters;
import cn.coostack.usefulmagic.particles.emitters.StarryMeteoriteLocusEmitters;
import cn.coostack.usefulmagic.particles.style.explosion.ExplosionStarStyle;
import cn.coostack.usefulmagic.particles.style.wand.starry.StarryMagicStyle;
import cn.coostack.usefulmagic.particles.style.wand.starry.StarrySpellcasterMagicStyle;
import cn.coostack.usefulmagic.sounds.UsefulMagicSoundEvents;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001dH\u0016J(\u0010\"\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0012H\u0016J(\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/StarryWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "options", "", "getOptions", "()I", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getUseDuration", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "finishUsingItem", "world", "Lnet/minecraft/world/level/Level;", "user", "onUseTick", "remainingUseTicks", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "Companion", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nStarryWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarryWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StarryWand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1869#2,2:312\n*S KotlinDebug\n*F\n+ 1 StarryWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StarryWand\n*L\n182#1:312,2\n*E\n"})
public final class StarryWand
extends WandItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Random random;

    public StarryWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 1000, 50.0);
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.starry_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 160;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return stack;
        }
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        Vec3 target = Companion.getTargetLocation((Player)user);
        world.playSound(null, user.position().x, user.position().y, user.position().z, UsefulMagicSoundEvents.getMAGIC_ACTIVATE().get(), SoundSource.PLAYERS, 10.0f, 2.0f);
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        Vec3 randomOffset = new Vec3(random.nextDouble(-32.0, 32.0), 100.0, random.nextDouble(-32.0, 32.0));
        Vec3 randomSpawn = user.position().add(randomOffset);
        StarryMagicStyle style = new StarryMagicStyle(null, 1, null);
        Intrinsics.checkNotNull((Object)randomSpawn);
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)randomSpawn, (Vec3)target);
        style.setDirection(dir);
        UUID uUID = ((ServerPlayer)user).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        style.setPlayer(uUID);
        int maxAge = style.getMaxAge();
        ParticleStyleManager.INSTANCE.spawnStyle(world, randomSpawn, (ParticleGroupStyle)style);
        PointsBuilder shape = new PointsBuilder().addRoundShape(40.0, 0.5, 18, 180);
        Ref.IntRef tick2 = new Ref.IntRef();
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(3, maxAge, () -> StarryWand.finishUsingItem$lambda$10(tick2, shape, style, randomSpawn, world, user, this));
        this.cost((ServerPlayer)user);
        ((ServerPlayer)user).getCooldowns().addCooldown((Item)this, 1200);
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        int n;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        int max = this.getUseDuration(stack, user);
        if (world.isClientSide) {
            return;
        }
        if (tick2 > 40 && tick2 % 2 == 0) {
            int n2 = 4;
            n = 0;
            while (n < n2) {
                int it = n++;
                boolean bl = false;
                UUID uUID = user.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                ExplosionStarStyle style = new ExplosionStarStyle(uUID, null, 2, null);
                double r = this.random.nextDouble(5.0, 16.0);
                RelativeLocation p = (RelativeLocation)CollectionsKt.random((Collection)new PointsBuilder().addBall(r, 1).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI)).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI), RelativeLocation.Companion.xAxis()).create(), (Random)((Random)Random.Default));
                Vec3 vec3 = user.getEyePosition().add(p.toVector());
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
                ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
            }
        }
        if (tick2 % 10 == 0 && tick2 >= 40) {
            Vec3 randomPos = Vec3ExtendKt.multiply(new Vec3(this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0)), this.random.nextDouble(-5.0, 5.0));
            Vec3 pos = user.position().add(randomPos);
            world.playSound(null, pos.x, pos.y, pos.z, UsefulMagicSoundEvents.getSTAR().get(), SoundSource.PLAYERS, 3.0f, 0.7f + this.random.nextFloat() * 0.6f);
        }
        if (tick2 % 3 == 0) {
            List rangeBall = new PointsBuilder().addBall(12.0, 6 * this.getOptions()).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI), RelativeLocation.Companion.yAxis()).rotateAsAxis(this.random.nextDouble(-Math.PI, Math.PI), RelativeLocation.Companion.xAxis()).create();
            n = tick2 < max / 2 ? 10 : 20;
            int n3 = 0;
            while (n3 < n) {
                int it = n3++;
                boolean bl = false;
                RelativeLocation it2 = (RelativeLocation)CollectionsKt.random((Collection)rangeBall, (Random)((Random)Random.Default));
                Vec3 pos = user.position().add(it2.toVector());
                RelativeLocation dir = it2.normalize().multiply(-0.6);
                SimpleParticleType simpleParticleType = ParticleTypes.CLOUD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"CLOUD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Intrinsics.checkNotNull((Object)pos);
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, pos, dir.toVector());
            }
        }
        if (tick2 % 5 == 0) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 2.0f);
        }
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder<ItemStack> res = super.use(world, user, hand);
        if (!res.getResult().consumesAction()) {
            return res;
        }
        if (world.isClientSide) {
            return res;
        }
        StarrySpellcasterMagicStyle style = new StarrySpellcasterMagicStyle(null, 1, null);
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        style.setPlayer(uUID);
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
        return super.use(world, user, hand);
    }

    private static final boolean finishUsingItem$lambda$10$lambda$9$lambda$7$lambda$2(LivingEntity $user, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)$user);
    }

    private static final boolean finishUsingItem$lambda$10$lambda$9$lambda$7$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit finishUsingItem$lambda$10$lambda$9$lambda$7(Level $world, LivingEntity $user, StarryMeteoriteLocusEmitters $emitters, StarryWand this$0, Vec3 loc) {
        ControlableParticleData controlableParticleData;
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        AABB box = AABB.ofSize((Vec3)loc, (double)8.0, (double)8.0, (double)8.0);
        DamageSources damageSources = $world.damageSources();
        LivingEntity livingEntity = $user;
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        DamageSource source = damageSources.playerAttack((Player)livingEntity);
        Iterable iterable = $world.getEntitiesOfClass(LivingEntity.class, box, arg_0 -> StarryWand.finishUsingItem$lambda$10$lambda$9$lambda$7$lambda$3(arg_0 -> StarryWand.finishUsingItem$lambda$10$lambda$9$lambda$7$lambda$2($user, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getEntitiesOfClass(...)");
        iterable = iterable;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl = false;
            it.hurt(source, (float)this$0.getDamage());
            it.invulnerableTime = 0;
        }
        int countDouble = ParticleOption.INSTANCE.getParticleCounts();
        Object $this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246 = object = new ExplodeMagicEmitters(loc, $world);
        boolean bl = false;
        ControlableParticleData it = controlableParticleData = ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).getTemplateData();
        boolean bl2 = false;
        it.setColor(Math3DUtil.INSTANCE.colorOf(255, 170, 200));
        it.setSize(0.4f);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setRandomParticleAgeMin(10);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setRandomParticleAgeMax(15);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setPrecentDrag(0.95);
        $this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246.setMaxTick(5);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setBallCountPow(countDouble * 15);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setMinSpeed(0.5);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setMaxSpeed(3.0);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setRandomCountMin(3 * countDouble);
        ((ExplodeMagicEmitters)((Object)$this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u247_u24lambda_u246)).setRandomCountMax(8 * countDouble);
        Object explosion = object;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)explosion);
        $world.explode((Entity)$user, source, null, loc, 8.0f, false, Level.ExplosionInteraction.TNT);
        $emitters.setCancelled(true);
        return Unit.INSTANCE;
    }

    private static final Unit finishUsingItem$lambda$10$lambda$9$lambda$8(StarryMeteoriteLocusEmitters $emitters, OptionMeteorite $this$withTick) {
        Intrinsics.checkNotNullParameter((Object)$this$withTick, (String)"$this$withTick");
        $emitters.setPos($this$withTick.getOrigin());
        return Unit.INSTANCE;
    }

    private static final void finishUsingItem$lambda$10(Ref.IntRef $tick, PointsBuilder $shape, StarryMagicStyle $style, Vec3 $randomSpawn, Level $world, LivingEntity $user, StarryWand this$0) {
        $tick.element += 3;
        if ($tick.element < 60) {
            return;
        }
        Vec3 vec3 = $style.getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"<get-direction>(...)");
        $shape.rotateTo(vec3);
        List create = $shape.create();
        int n = 6;
        int n2 = 0;
        while (n2 < n) {
            ControlableParticleData controlableParticleData;
            StarryMeteoriteLocusEmitters starryMeteoriteLocusEmitters;
            int it = n2++;
            boolean bl = false;
            Vec3 meteoritePos = $randomSpawn.add(((RelativeLocation)CollectionsKt.random((Collection)create, (Random)((Random)Random.Default))).toVector());
            Intrinsics.checkNotNull((Object)meteoritePos);
            StarryMeteoriteLocusEmitters $this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u241 = starryMeteoriteLocusEmitters = new StarryMeteoriteLocusEmitters(meteoritePos, $world);
            boolean bl2 = false;
            ControlableParticleData it2 = controlableParticleData = $this$finishUsingItem_u24lambda_u2410_u24lambda_u249_u24lambda_u241.getTemplateData();
            boolean bl3 = false;
            it2.setMaxAge(10);
            it2.setSize(0.5f);
            it2.setColor(Math3DUtil.INSTANCE.colorOf(255, 0, 0));
            StarryMeteoriteLocusEmitters emitters = starryMeteoriteLocusEmitters;
            ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
            Block block = Blocks.MAGMA_BLOCK;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"MAGMA_BLOCK");
            OptionMeteorite optionMeteorite = new OptionMeteorite(block, 1, (Function1<? super Vec3, Unit>)((Function1)arg_0 -> StarryWand.finishUsingItem$lambda$10$lambda$9$lambda$7($world, $user, emitters, this$0, arg_0))).withTick((Function1<? super OptionMeteorite, Unit>)((Function1)arg_0 -> StarryWand.finishUsingItem$lambda$10$lambda$9$lambda$8(emitters, arg_0)));
            optionMeteorite.setMaxAge(60);
            Vec3 vec32 = $style.getDirection().normalize();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
            optionMeteorite.setDirection(RelativeLocation.Companion.of(vec32));
            optionMeteorite.setSpeed(3.5);
            optionMeteorite.spawn(meteoritePos, (ServerLevel)$world);
        }
    }

    @JvmStatic
    @NotNull
    public static final Vec3 getTargetLocation(@NotNull Player user) {
        return Companion.getTargetLocation(user);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/StarryWand$Companion;", "", "<init>", "()V", "getTargetLocation", "Lnet/minecraft/world/phys/Vec3;", "user", "Lnet/minecraft/world/entity/player/Player;", "usefulmagic-neoforge-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nStarryWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarryWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StarryWand$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n2423#2,14:312\n*S KotlinDebug\n*F\n+ 1 StarryWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StarryWand$Companion\n*L\n65#1:312,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Vec3 getTargetLocation(@NotNull Player user) {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Vec3 vec = user.getForward().normalize();
            Vec3 eyePos = user.getEyePosition();
            int range = 100;
            Level world = user.level();
            Vec3 currentPos = eyePos;
            for (int count = 0; count < range; ++count) {
                boolean cant;
                Object v0;
                AABB box = AABB.ofSize((Vec3)currentPos, (double)3.0, (double)3.0, (double)3.0);
                List entities = world.getEntitiesOfClass(LivingEntity.class, box, arg_0 -> Companion.getTargetLocation$lambda$1(arg_0 -> Companion.getTargetLocation$lambda$0(user, arg_0), arg_0));
                Intrinsics.checkNotNull((Object)entities);
                Iterable $this$minByOrNull$iv = entities;
                boolean $i$f$minByOrNull22 = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        LivingEntity it = (LivingEntity)minElem$iv;
                        boolean bl = false;
                        float minValue$iv = it.distanceTo((Entity)user);
                        do {
                            Object e$iv = iterator$iv.next();
                            LivingEntity it2 = (LivingEntity)e$iv;
                            $i$a$-minByOrNull-StarryWand$Companion$getTargetLocation$entity$1 = false;
                            float v$iv = it2.distanceTo((Entity)user);
                            if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                LivingEntity entity = v0;
                if (entity != null) {
                    currentPos = entity.position();
                    break;
                }
                Vec3 $i$f$minByOrNull22 = currentPos;
                Intrinsics.checkNotNull((Object)$i$f$minByOrNull22);
                BlockPos blockPos = BlockPosExtendsKt.ofFloored((Vec3)$i$f$minByOrNull22);
                if (!world.shouldTickBlocksAt(blockPos)) {
                    currentPos = currentPos.add(0.0, 0.5, 0.0);
                    break;
                }
                BlockState block = world.getBlockState(blockPos);
                if (!block.isAir() && !block.getCollisionShape((BlockGetter)world, blockPos).isEmpty()) {
                    currentPos = currentPos.add(0.0, 0.5, 0.0);
                    break;
                }
                Vec3 vec3 = currentPos;
                Intrinsics.checkNotNull((Object)vec3);
                Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                if (ServerFormationManager.INSTANCE.getFormationFromPos(vec3, (ServerLevel)world) != null) {
                    BlockFormation it;
                    boolean bl = false;
                    LivingEntityTargetOption option = new LivingEntityTargetOption((LivingEntity)user, false);
                    v1 = it.hasCrystalType(DefendCrystal.class) && !it.isFriendly(option);
                } else {
                    v1 = cant = false;
                }
                if (cant) break;
                currentPos = currentPos.add(vec);
            }
            Vec3 vec3 = currentPos;
            Intrinsics.checkNotNull((Object)vec3);
            return vec3;
        }

        private static final boolean getTargetLocation$lambda$0(Player $user, LivingEntity it) {
            return !Intrinsics.areEqual((Object)it.getUUID(), (Object)$user.getUUID());
        }

        private static final boolean getTargetLocation$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

