/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.formation.CrystalFormation;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J(\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/StoneWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "attenuation", "", "getAttenuation", "()D", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "ingredient", "onUseTick", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "remainingUseTicks", "", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nStoneWand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoneWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StoneWand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1869#2,2:163\n1869#2,2:165\n*S KotlinDebug\n*F\n+ 1 StoneWand.kt\ncn/coostack/usefulmagic/items/weapon/wands/StoneWand\n*L\n126#1:163,2\n147#1:165,2\n*E\n"})
public final class StoneWand
extends WandItem {
    private final double attenuation;

    public StoneWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 10, 5.0);
        this.attenuation = 0.9;
    }

    public final double getAttenuation() {
        return this.attenuation;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.stone_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        TagKey tagKey = ItemTags.PLANKS;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"PLANKS");
        return ItemExtendKt.isIn(ingredient, (TagKey<Item>)tagKey);
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        boolean canUse;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!world.isClientSide) {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v2 = manaServerState.getDataFromServer(uUID).canCost(this.getCost(), false);
        } else {
            v2 = canUse = ClientManaManager.INSTANCE.getSelfMana().canCost(this.getCost(), true);
        }
        if (!canUse) {
            user.stopUsingItem();
            return;
        }
        if (world.isClientSide) {
            return;
        }
        if (!(user instanceof ServerPlayer)) {
            return;
        }
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        if (tick2 % 10 != 0 || tick2 < 10) {
            return;
        }
        stack.hurtAndBreak(1, (ServerLevel)world, (ServerPlayer)user, arg_0 -> StoneWand.onUseTick$lambda$0(world, user, arg_0));
        world.playSound(null, ((ServerPlayer)user).getX(), ((ServerPlayer)user).getY(), ((ServerPlayer)user).getZ(), SoundEvents.BREEZE_SHOOT, SoundSource.PLAYERS, 6.0f, 1.3f);
        Vec3 direction = ((ServerPlayer)user).getForward().normalize();
        Ref.ObjectRef currentPos = new Ref.ObjectRef();
        currentPos.element = ((ServerPlayer)user).getEyePosition();
        for (int i = 1; i < 31; ++i) {
            boolean cant;
            currentPos.element = ((Vec3)currentPos.element).add(direction);
            List entities = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)((Vec3)currentPos.element), (double)1.0, (double)1.0, (double)1.0), arg_0 -> StoneWand.onUseTick$lambda$2(arg_0 -> StoneWand.onUseTick$lambda$1(user, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)entities);
            if (!((Collection)entities).isEmpty()) {
                Vec3 prePos;
                HashSet<LivingEntity> damagedEntitySet = new HashSet<LivingEntity>();
                LivingEntity entity = (LivingEntity)CollectionsKt.first((List)entities);
                damagedEntitySet.add(entity);
                DamageSource source = entity.damageSources().playerAttack((Player)user);
                entity.hurt(source, (float)this.getDamage());
                Vec3 nextPos = prePos = (Vec3)currentPos.element;
                for (int j = 1; j < 3; ++j) {
                    LivingEntity next;
                    List list = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)prePos, (double)16.0, (double)10.0, (double)16.0), arg_0 -> StoneWand.onUseTick$lambda$5(arg_0 -> StoneWand.onUseTick$lambda$4(currentPos, world, user, damagedEntitySet, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
                    if ((LivingEntity)CollectionsKt.firstOrNull((List)list) == null) continue;
                    prePos = nextPos;
                    nextPos = next.getEyePosition();
                    next.hurt(source, (float)(this.getDamage() * Math.pow(this.attenuation, j)));
                    damagedEntitySet.add(next);
                    PointsBuilder pointsBuilder = new PointsBuilder();
                    Vec3 vec3 = prePos;
                    Intrinsics.checkNotNull((Object)vec3);
                    Vec3 vec32 = vec3;
                    vec3 = nextPos;
                    Intrinsics.checkNotNull((Object)vec3);
                    Iterable $this$forEach$iv = pointsBuilder.addLine(vec32, vec3, MathKt.roundToInt((double)prePos.distanceTo(nextPos)) * 10).create();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RelativeLocation it = (RelativeLocation)element$iv;
                        boolean bl = false;
                        SimpleParticleType simpleParticleType = ParticleTypes.ENCHANT;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"ENCHANT");
                        ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                        ServerLevel serverLevel = (ServerLevel)world;
                        Vec3 vec33 = it.toVector();
                        Vec3 vec34 = Vec3.ZERO;
                        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"ZERO");
                        ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec33, vec34, 64.0);
                    }
                }
                break;
            }
            Object object = currentPos.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            if (ServerFormationManager.INSTANCE.getFormationFromPos((Vec3)object, (ServerLevel)world) != null) {
                BlockFormation it;
                boolean bl = false;
                LivingEntityTargetOption option = new LivingEntityTargetOption(user, false);
                if (it instanceof CrystalFormation && ((CrystalFormation)it).getHasDefend() && !((CrystalFormation)it).isFriendly(option)) {
                    CrystalFormation crystalFormation = (CrystalFormation)it;
                    FormationTargetOption formationTargetOption = option;
                    Object object2 = currentPos.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                    crystalFormation.attack(5.0f, formationTargetOption, (Vec3)object2);
                    v15 = true;
                } else {
                    v15 = false;
                }
            } else {
                v15 = cant = false;
            }
            if (cant) break;
        }
        PointsBuilder pointsBuilder = new PointsBuilder();
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        Object object = currentPos.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        Iterable $this$forEach$iv = pointsBuilder.addLine(vec3, (Vec3)object, MathKt.roundToInt((double)((Vec3)currentPos.element).distanceTo(((ServerPlayer)user).getEyePosition())) * 10).create();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl = false;
            SimpleParticleType simpleParticleType = ParticleTypes.ENCHANT;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"ENCHANT");
            ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 vec35 = it.toVector();
            Vec3 vec36 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"ZERO");
            ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, vec35, vec36, 64.0);
        }
        this.cost((ServerPlayer)user);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    private static final void onUseTick$lambda$0(Level $world, LivingEntity $user, Item it) {
        ServerLevel serverLevel = (ServerLevel)$world;
        Vec3 vec3 = $user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        serverLevel.playSound(null, BlockPosExtendsKt.ofFloored((Vec3)vec3), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 5.0f, 1.0f);
    }

    private static final boolean onUseTick$lambda$1(LivingEntity $user, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$user).getUUID());
    }

    private static final boolean onUseTick$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onUseTick$lambda$4(Ref.ObjectRef $currentPos, Level $world, LivingEntity $user, HashSet $damagedEntitySet, LivingEntity it) {
        boolean bl;
        Object object = $currentPos.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        BlockFormation blockFormation = ServerFormationManager.INSTANCE.getFormationFromPos((Vec3)object, (ServerLevel)$world);
        if (blockFormation != null) {
            BlockFormation it2 = blockFormation;
            boolean bl2 = false;
            bl = it2 instanceof CrystalFormation && ((CrystalFormation)it2).getHasDefend();
        } else {
            bl = false;
        }
        boolean cant = bl;
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((ServerPlayer)$user).getUUID()) && !$damagedEntitySet.contains(it) && !cant;
    }

    private static final boolean onUseTick$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

