/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0004\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "cost", "", "damage", "", "<init>", "(Lnet/minecraft/world/item/Item$Properties;ID)V", "getCost", "()I", "getDamage", "()D", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "usefulmagic-neoforge-1.21.1"})
public class WandItem
extends Item {
    private final int cost;
    private final double damage;

    public WandItem(@NotNull Item.Properties settings, int cost, double damage) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.cost = cost;
        this.damage = damage;
    }

    public final int getCost() {
        return this.cost;
    }

    public final double getDamage() {
        return this.damage;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        String string = Component.translatable((String)"item.wand.damage").getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        tooltip.add((Component)Component.literal((String)StringsKt.replace$default((String)string, (String)"%amount%", (String)String.valueOf(this.damage), (boolean)false, (int)4, null)));
        String string2 = Component.translatable((String)"item.wand.cost").getString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        tooltip.add((Component)Component.literal((String)StringsKt.replace$default((String)string2, (String)"%cost%", (String)String.valueOf(this.cost), (boolean)false, (int)4, null)));
        String string3 = Component.translatable((String)"item.wand.mana").getString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        tooltip.add((Component)Component.literal((String)StringsKt.replace$default((String)string3, (String)"%mana%", (String)String.valueOf(ClientManaManager.INSTANCE.getSelfMana().getMana()), (boolean)false, (int)4, null)));
    }

    public final void cost(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isCreative()) {
            return;
        }
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        MagicPlayerData data = manaServerState.getDataFromServer(uUID);
        data.setMana(data.getMana() - this.cost);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        boolean canUse;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v2 = manaServerState.getDataFromServer(uUID).canCost(this.cost, false);
        } else {
            v2 = canUse = ClientManaManager.INSTANCE.getSelfMana().canCost(this.cost, true);
        }
        if (!canUse) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        user.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }
}

