/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.network.particle.util.ServerParticleUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.particles.barrages.wand.WandMeteoriteBarrage;
import cn.coostack.usefulmagic.particles.style.EnchantLineStyle;
import cn.coostack.usefulmagic.particles.style.wand.meteorite.WandMeteoriteSpellcasterStyle;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0016J(\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0014H\u0016J \u0010'\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016H\u0016J(\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0)2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/WandOfMeteorite;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "getUseDuration", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "options", "getOptions", "()I", "isValidRepairItem", "", "ingredient", "rangeBall", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getRangeBall", "()Ljava/util/List;", "onUseTick", "world", "Lnet/minecraft/world/level/Level;", "user", "remainingUseTicks", "finishUsingItem", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "usefulmagic-neoforge-1.21.1"})
public final class WandOfMeteorite
extends WandItem {
    @NotNull
    private final List<RelativeLocation> rangeBall;

    public WandOfMeteorite(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 1000, 200.0);
        this.rangeBall = new PointsBuilder().addBall(64.0, 8 * this.getOptions()).create();
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.wand_of_meteorite.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 240;
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return false;
    }

    @NotNull
    public final List<RelativeLocation> getRangeBall() {
        return this.rangeBall;
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        int it;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int max = this.getUseDuration(stack, user);
        int tick2 = max - remainingUseTicks;
        if (world.isClientSide) {
            return;
        }
        java.util.Random random = new java.util.Random(System.currentTimeMillis());
        if (tick2 % 3 == 0) {
            n2 = tick2 < max / 2 ? 20 : 40;
            n = 0;
            while (n < n2) {
                it = n++;
                boolean bl = false;
                RelativeLocation it2 = (RelativeLocation)CollectionsKt.random((Collection)this.rangeBall, (Random)((Random)Random.Default));
                Vec3 pos = user.position().add(0.0, 1.5, 0.0).add(it2.toVector());
                RelativeLocation dir = it2.normalize().multiply(-5.75);
                SimpleParticleType simpleParticleType = ParticleTypes.END_ROD;
                Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"END_ROD");
                ParticleOptions particleOptions = (ParticleOptions)simpleParticleType;
                ServerLevel serverLevel = (ServerLevel)world;
                Intrinsics.checkNotNull((Object)pos);
                ServerParticleUtil.INSTANCE.spawnSingle(particleOptions, serverLevel, pos, dir.toVector());
            }
        }
        if (tick2 % 3 == 0) {
            n2 = 6;
            n = 0;
            while (n < n2) {
                EnchantLineStyle style;
                EnchantLineStyle enchantLineStyle;
                it = n++;
                boolean bl = false;
                double x = random.nextDouble(-15.0, 15.0);
                double y = random.nextDouble(-5.0, 10.0);
                double z = random.nextDouble(-15.0, 15.0);
                Vec3 pos = user.getEyePosition().add(x, y, z);
                RelativeLocation line = new RelativeLocation(0.0, random.nextDouble(2.0, 4.0), 0.0);
                int count = MathKt.roundToInt((double)(line.length() * (double)2));
                EnchantLineStyle $this$onUseTick_u24lambda_u242_u24lambda_u241 = enchantLineStyle = (style = new EnchantLineStyle(line, count, random.nextInt(40, 60), null, 8, null));
                boolean bl2 = false;
                $this$onUseTick_u24lambda_u242_u24lambda_u241.setParticleRandomAgePreTick(true);
                $this$onUseTick_u24lambda_u242_u24lambda_u241.setFade(true);
                $this$onUseTick_u24lambda_u242_u24lambda_u241.setFadeInTick(30);
                $this$onUseTick_u24lambda_u242_u24lambda_u241.setFadeOutTick(30);
                $this$onUseTick_u24lambda_u242_u24lambda_u241.colorOf(255, 117, 148);
                $this$onUseTick_u24lambda_u242_u24lambda_u241.setSpeedDirection(new RelativeLocation(0.0, random.nextDouble(-0.1, 0.1), 0.0));
                Intrinsics.checkNotNull((Object)pos);
                ParticleStyleManager.INSTANCE.spawnStyle(world, pos, (ParticleGroupStyle)style);
            }
        }
        if (tick2 % 3 == 0) {
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 3.0f, 1.5f);
        }
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (world.isClientSide) {
            return stack;
        }
        if (!(user instanceof ServerPlayer)) {
            return stack;
        }
        ServerLevel cfr_ignored_0 = (ServerLevel)world;
        world.playSound(null, user.position().x, user.position().y, user.position().z, SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 10.0f, 2.0f);
        double d = this.getDamage();
        Vec3 vec3 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        WandMeteoriteBarrage barrage = new WandMeteoriteBarrage(d, user, vec3, (ServerLevel)world);
        Vec3 vec32 = ((ServerPlayer)user).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getForward(...)");
        barrage.setDirection(vec32);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        this.cost((ServerPlayer)user);
        ((ServerPlayer)user).getCooldowns().addCooldown((Item)this, 240);
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResultHolder<ItemStack> res = super.use(world, user, hand);
        if (!res.getResult().consumesAction()) {
            return res;
        }
        if (world.isClientSide) {
            return res;
        }
        UUID uUID = user.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        WandMeteoriteSpellcasterStyle style = new WandMeteoriteSpellcasterStyle(uUID, null, 2, null);
        Vec3 vec3 = user.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        ParticleStyleManager.INSTANCE.spawnStyle(world, vec3, (ParticleGroupStyle)style);
        return res;
    }
}

