/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.items.weapon.wands;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.extend.ItemExtendKt;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import cn.coostack.usefulmagic.managers.client.ClientManaManager;
import cn.coostack.usefulmagic.particles.barrages.wand.WoodenBarrage;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J(\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/items/weapon/wands/WoodenWand;", "Lcn/coostack/usefulmagic/items/weapon/wands/WandItem;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "chanceBurn", "", "getChanceBurn", "()D", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "getUseAnimation", "Lnet/minecraft/world/item/UseAnim;", "isValidRepairItem", "", "ingredient", "onUseTick", "world", "Lnet/minecraft/world/level/Level;", "user", "Lnet/minecraft/world/entity/LivingEntity;", "remainingUseTicks", "", "getUseDuration", "entity", "usefulmagic-neoforge-1.21.1"})
public final class WoodenWand
extends WandItem {
    private final double chanceBurn;

    public WoodenWand(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings, 2, 4.0);
        this.chanceBurn = 0.1;
    }

    public final double getChanceBurn() {
        return this.chanceBurn;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        tooltip.add((Component)Component.translatable((String)"item.wooden_wand.description"));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, @NotNull ItemStack ingredient) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        TagKey tagKey = ItemTags.PLANKS;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"PLANKS");
        return ItemExtendKt.isIn(ingredient, (TagKey<Item>)tagKey);
    }

    public void onUseTick(@NotNull Level world, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseTicks) {
        boolean canUse;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!world.isClientSide) {
            ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
            UUID uUID = user.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            v2 = manaServerState.getDataFromServer(uUID).canCost(this.getCost(), false);
        } else {
            v2 = canUse = ClientManaManager.INSTANCE.getSelfMana().canCost(this.getCost(), true);
        }
        if (!canUse) {
            user.stopUsingItem();
            return;
        }
        if (world.isClientSide) {
            return;
        }
        int tick2 = this.getUseDuration(stack, user) - remainingUseTicks;
        if (tick2 % 10 != 0 || tick2 < 10) {
            return;
        }
        stack.hurtAndBreak(1, (ServerLevel)world, (ServerPlayer)user, arg_0 -> WoodenWand.onUseTick$lambda$0(world, user, arg_0));
        ServerLevel serverLevel = (ServerLevel)world;
        Vec3 vec3 = user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        serverLevel.playSound(null, BlockPosExtendsKt.ofFloored((Vec3)vec3), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 10.0f, 3.0f);
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        double d = this.getDamage();
        Player player = (Player)user;
        Vec3 vec32 = ((ServerPlayer)user).getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getEyePosition(...)");
        WoodenBarrage barrage = new WoodenBarrage(d, player, vec32, (ServerLevel)world, (double)random.nextInt(100) < (double)100 * this.chanceBurn);
        Vec3 vec33 = ((ServerPlayer)user).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getForward(...)");
        barrage.setDirection(vec33);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        this.cost((ServerPlayer)user);
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 72000;
    }

    private static final void onUseTick$lambda$0(Level $world, LivingEntity $user, Item it) {
        ServerLevel serverLevel = (ServerLevel)$world;
        Vec3 vec3 = $user.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        serverLevel.playSound(null, BlockPosExtendsKt.ofFloored((Vec3)vec3), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 5.0f, 1.0f);
    }
}

