/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.listener;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.items.prop.DefendCoreItem;
import cn.coostack.usefulmagic.particles.emitters.CircleEmitters;
import cn.coostack.usefulmagic.particles.emitters.ExplodeMagicEmitters;
import cn.coostack.usefulmagic.sounds.UsefulMagicSoundEvents;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J8\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u001a"}, d2={"Lcn/coostack/usefulmagic/listener/DefendMagicListener;", "", "<init>", "()V", "showDefendSuccess", "", "direction", "Lnet/minecraft/world/phys/Vec3;", "damagedEntity", "Lnet/minecraft/server/level/ServerPlayer;", "sourceEntity", "Lnet/minecraft/world/entity/Entity;", "barrage", "", "showDefendPartSuccess", "call", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "tryDefend", "attacker", "count", "attackPos", "usefulmagic-neoforge-1.21.1"})
public final class DefendMagicListener {
    @NotNull
    public static final DefendMagicListener INSTANCE = new DefendMagicListener();

    private DefendMagicListener() {
    }

    private final void showDefendSuccess(Vec3 direction, ServerPlayer damagedEntity, Entity sourceEntity, boolean barrage) {
        ControlableParticleData controlableParticleData;
        CircleEmitters emitters;
        CircleEmitters circleEmitters;
        if (direction == null) {
            this.showDefendPartSuccess(null, damagedEntity, null);
            return;
        }
        Level world = damagedEntity.level();
        Vec3 vec3 = damagedEntity.getEyePosition().add(direction.normalize().scale(1.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        CircleEmitters $this$showDefendSuccess_u24lambda_u241 = circleEmitters = (emitters = new CircleEmitters(vec3, world));
        boolean bl = false;
        $this$showDefendSuccess_u24lambda_u241.setMaxTick(1);
        ControlableParticleData it = controlableParticleData = $this$showDefendSuccess_u24lambda_u241.getTemplateData();
        boolean bl2 = false;
        it.setEffect((ControlableParticleEffect)new ControlableCloudEffect($this$showDefendSuccess_u24lambda_u241.getUuid(), false, 2, null));
        it.setSize(0.1f);
        it.setColor(Math3DUtil.INSTANCE.colorOf(147, 242, 255));
        $this$showDefendSuccess_u24lambda_u241.setCircleSpeed(0.5);
        $this$showDefendSuccess_u24lambda_u241.setPrecentDrag(0.7);
        $this$showDefendSuccess_u24lambda_u241.setCircleDirection(direction);
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
        world.playSound(null, damagedEntity.getX(), damagedEntity.getY(), damagedEntity.getZ(), UsefulMagicSoundEvents.getDEFEND_SHIELD_HIT().get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        if (!barrage) {
            Intrinsics.checkNotNull((Object)sourceEntity);
            sourceEntity.hurtMarked = true;
            if (sourceEntity instanceof Projectile) {
                ((Projectile)sourceEntity).setDeltaMovement(direction.normalize().scale(1.5));
            } else if (sourceEntity.distanceTo((Entity)damagedEntity) < 2.0f) {
                sourceEntity.setDeltaMovement(direction.normalize().scale(0.5));
            }
        }
    }

    private final void showDefendPartSuccess(Vec3 direction, ServerPlayer damagedEntity, Entity sourceEntity) {
        ControlableParticleData controlableParticleData;
        ExplodeMagicEmitters emitters;
        ExplodeMagicEmitters explodeMagicEmitters;
        Vec3 vec3 = damagedEntity.getEyePosition().add(0.0, -0.5, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        ExplodeMagicEmitters $this$showDefendPartSuccess_u24lambda_u243 = explodeMagicEmitters = (emitters = new ExplodeMagicEmitters(vec3, damagedEntity.level()));
        boolean bl = false;
        $this$showDefendPartSuccess_u24lambda_u243.setMaxTick(1);
        $this$showDefendPartSuccess_u24lambda_u243.setPrecentDrag(0.5);
        $this$showDefendPartSuccess_u24lambda_u243.setRandomParticleAgeMin(10);
        $this$showDefendPartSuccess_u24lambda_u243.setRandomParticleAgeMax(30);
        $this$showDefendPartSuccess_u24lambda_u243.setRandomCountMin(10);
        $this$showDefendPartSuccess_u24lambda_u243.setRandomCountMax(20);
        $this$showDefendPartSuccess_u24lambda_u243.setBallCountPow(6);
        $this$showDefendPartSuccess_u24lambda_u243.setMaxSpeed(3.0);
        $this$showDefendPartSuccess_u24lambda_u243.setMinSpeed(0.5);
        ControlableParticleData it = controlableParticleData = $this$showDefendPartSuccess_u24lambda_u243.getTemplateData();
        boolean bl2 = false;
        it.setEffect((ControlableParticleEffect)new ControlableCloudEffect($this$showDefendPartSuccess_u24lambda_u243.getUuid(), false, 2, null));
        it.setColor(Math3DUtil.INSTANCE.colorOf(255, 255, 255));
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
    }

    public final boolean call(@NotNull LivingEntity entity, @NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        Entity entity2 = source.getEntity();
        Vec3 vec3 = source.getSourcePosition();
        if (vec3 == null) {
            vec3 = Vec3.ZERO;
        }
        Vec3 vec32 = vec3;
        Intrinsics.checkNotNull((Object)vec32);
        return this.tryDefend(serverPlayer, entity2, amount, vec32, source, false);
    }

    public final boolean tryDefend(@NotNull ServerPlayer entity, @Nullable Entity attacker, float count, @NotNull Vec3 attackPos, @NotNull DamageSource source, boolean barrage) {
        Vec3 sourceDirection;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)attackPos, (String)"attackPos");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!DefendCoreItem.Companion.checkEnabled((Player)entity)) {
            return true;
        }
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID = entity.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        MagicPlayerData data = manaServerState.getDataFromServer(uUID);
        int mana = data.getMana();
        if (mana == 0) {
            return true;
        }
        float manaCost = count * (float)5;
        Entity entity2 = attacker;
        if (entity2 != null) {
            Entity it = entity2;
            boolean bl = false;
            Vec3 vec3 = entity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            v4 = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)attackPos);
        } else {
            v4 = sourceDirection = null;
        }
        if ((float)mana >= manaCost) {
            data.setMana(data.getMana() - MathKt.roundToInt((float)manaCost));
            this.showDefendSuccess(sourceDirection, entity, attacker, barrage);
            return false;
        }
        data.setMana(0);
        float actualDamage = count - (float)(mana / 5);
        entity.hurt(source, actualDamage);
        this.showDefendPartSuccess(sourceDirection, entity, attacker);
        return false;
    }
}

