/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.managers.server;

import cn.coostack.usefulmagic.formation.api.BlockFormation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\fR-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcn/coostack/usefulmagic/managers/server/ServerFormationManager;", "", "<init>", "()V", "activeFormations", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "Lkotlin/collections/HashMap;", "getActiveFormations", "()Ljava/util/HashMap;", "onFormationActive", "", "formation", "checkPosInFormationRange", "", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/server/level/ServerLevel;", "getFormationFromPos", "getActive", "uuid", "removeNotActiveFormations", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nServerFormationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerFormationManager.kt\ncn/coostack/usefulmagic/managers/server/ServerFormationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1761#2,3:50\n295#2,2:53\n*S KotlinDebug\n*F\n+ 1 ServerFormationManager.kt\ncn/coostack/usefulmagic/managers/server/ServerFormationManager\n*L\n18#1:50,3\n25#1:53,2\n*E\n"})
public final class ServerFormationManager {
    @NotNull
    public static final ServerFormationManager INSTANCE = new ServerFormationManager();
    @NotNull
    private static final HashMap<UUID, BlockFormation> activeFormations = new HashMap();

    private ServerFormationManager() {
    }

    @NotNull
    public final HashMap<UUID, BlockFormation> getActiveFormations() {
        return activeFormations;
    }

    public final void onFormationActive(@NotNull BlockFormation formation) {
        Intrinsics.checkNotNullParameter((Object)formation, (String)"formation");
        ((Map)activeFormations).put(formation.getUuid(), formation);
    }

    public final boolean checkPosInFormationRange(@NotNull Vec3 pos, @NotNull ServerLevel world) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Collection<BlockFormation> collection = activeFormations.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockFormation it = (BlockFormation)element$iv;
                    boolean bl2 = false;
                    double distance = it.getFormationCore().distanceTo(pos);
                    if (!(it.getFormationTriggerRange() >= distance && Intrinsics.areEqual((Object)world, (Object)it.getWorld()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final BlockFormation getFormationFromPos(@NotNull Vec3 pos, @NotNull ServerLevel world) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Collection<BlockFormation> collection = activeFormations.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BlockFormation it = (BlockFormation)element$iv;
                boolean bl = false;
                double distance = it.getFormationCore().distanceTo(pos);
                if (!(it.getFormationTriggerRange() >= distance && Intrinsics.areEqual((Object)world, (Object)it.getWorld()))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final BlockFormation getActive(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return activeFormations.get(uuid);
    }

    public final void removeNotActiveFormations() {
        Iterator iterator = ((Map)activeFormations).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            BlockFormation formation = (BlockFormation)entry.getValue();
            boolean removed = false;
            if (!formation.isActiveFormation()) {
                iterator.remove();
                removed = true;
            }
            if (!formation.chunkLoaded() || formation.canBeFormation() || removed) continue;
            iterator.remove();
        }
    }
}

