/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.meteorite;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.meteorite.MeteoriteFallingBlockEntity;
import cn.coostack.usefulmagic.meteorite.MeteoriteManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020H0GH&J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0005H&J\u0016\u0010L\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010M\u001a\u00020JJ\b\u0010N\u001a\u00020JH\u0016J\u000e\u0010\u001e\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010O\u001a\u00020JR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R$\u0010&\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R-\u0010/\u001a\u001e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020200j\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000202`3\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R0\u00106\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020200j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u000202`3X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00105R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010;\"\u0004\b@\u0010=R\u001a\u0010A\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006P"}, d2={"Lcn/coostack/usefulmagic/meteorite/Meteorite;", "", "<init>", "()V", "origin", "Lnet/minecraft/world/phys/Vec3;", "getOrigin", "()Lnet/minecraft/world/phys/Vec3;", "setOrigin", "(Lnet/minecraft/world/phys/Vec3;)V", "world", "Lnet/minecraft/server/level/ServerLevel;", "getWorld", "()Lnet/minecraft/server/level/ServerLevel;", "setWorld", "(Lnet/minecraft/server/level/ServerLevel;)V", "direction", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getDirection", "()Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "setDirection", "(Lcn/coostack/cooparticlesapi/utils/RelativeLocation;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "getShooter", "()Lnet/minecraft/world/entity/LivingEntity;", "setShooter", "(Lnet/minecraft/world/entity/LivingEntity;)V", "value", "", "hit", "getHit", "()Z", "setHit", "(Z)V", "valid", "getValid", "setValid", "spawned", "getSpawned", "setSpawned", "speed", "", "getSpeed", "()D", "setSpeed", "(D)V", "entities", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcn/coostack/usefulmagic/meteorite/MeteoriteFallingBlockEntity;", "Lkotlin/collections/HashMap;", "getEntities", "()Ljava/util/HashMap;", "entityLocations", "getEntityLocations", "maxAge", "", "getMaxAge", "()I", "setMaxAge", "(I)V", "age", "getAge", "setAge", "uuid", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "getBlocks", "", "Lnet/minecraft/world/level/block/state/BlockState;", "onHit", "", "pos", "spawn", "flushRelative", "tick", "clear", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMeteorite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Meteorite.kt\ncn/coostack/usefulmagic/meteorite/Meteorite\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n216#2,2:114\n216#2,2:116\n640#2:118\n1#3:119\n*S KotlinDebug\n*F\n+ 1 Meteorite.kt\ncn/coostack/usefulmagic/meteorite/Meteorite\n*L\n57#1:114,2\n69#1:116,2\n106#1:118\n106#1:119\n*E\n"})
public abstract class Meteorite {
    @NotNull
    private Vec3 origin;
    @Nullable
    private ServerLevel world;
    @NotNull
    private RelativeLocation direction;
    @Nullable
    private LivingEntity shooter;
    private boolean hit;
    private boolean valid;
    private boolean spawned;
    private double speed;
    @NotNull
    private final HashMap<UUID, MeteoriteFallingBlockEntity> entities;
    @NotNull
    private final HashMap<RelativeLocation, MeteoriteFallingBlockEntity> entityLocations;
    private int maxAge;
    private int age;
    @NotNull
    private UUID uuid;

    public Meteorite() {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.origin = vec3;
        this.direction = RelativeLocation.Companion.zero();
        this.valid = true;
        this.speed = 1.0;
        this.entities = new HashMap();
        this.entityLocations = new HashMap();
        this.maxAge = 240;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
    }

    @NotNull
    public final Vec3 getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.origin = vec3;
    }

    @Nullable
    public final ServerLevel getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable ServerLevel serverLevel) {
        this.world = serverLevel;
    }

    @NotNull
    public final RelativeLocation getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull RelativeLocation relativeLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"<set-?>");
        this.direction = relativeLocation;
    }

    @Nullable
    public final LivingEntity getShooter() {
        return this.shooter;
    }

    public final void setShooter(@Nullable LivingEntity livingEntity) {
        this.shooter = livingEntity;
    }

    public final boolean getHit() {
        return this.hit;
    }

    protected final void setHit(boolean bl) {
        this.hit = bl;
    }

    public final boolean getValid() {
        return this.valid;
    }

    protected final void setValid(boolean bl) {
        this.valid = bl;
    }

    public final boolean getSpawned() {
        return this.spawned;
    }

    protected final void setSpawned(boolean bl) {
        this.spawned = bl;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    @NotNull
    public final HashMap<UUID, MeteoriteFallingBlockEntity> getEntities() {
        return this.entities;
    }

    @NotNull
    protected final HashMap<RelativeLocation, MeteoriteFallingBlockEntity> getEntityLocations() {
        return this.entityLocations;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public final void setMaxAge(int n) {
        this.maxAge = n;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    @NotNull
    public abstract Map<RelativeLocation, BlockState> getBlocks();

    public abstract void onHit(@NotNull Vec3 var1);

    public final void spawn(@NotNull Vec3 pos, @NotNull ServerLevel world) {
        Map<RelativeLocation, BlockState> blocks;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (this.spawned) {
            return;
        }
        this.spawned = true;
        this.origin = pos;
        this.world = world;
        Map<RelativeLocation, BlockState> $this$forEach$iv = blocks = this.getBlocks();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<RelativeLocation, BlockState>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RelativeLocation, BlockState> element$iv;
            Map.Entry<RelativeLocation, BlockState> it = element$iv = iterator.next();
            boolean bl = false;
            Level level = (Level)world;
            Vec3 vec3 = pos.add(it.getKey().toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            MeteoriteFallingBlockEntity entity = MeteoriteFallingBlockEntity.Companion.create(level, BlockPosExtendsKt.ofFloored((Vec3)vec3), it.getValue());
            ((Map)this.entities).put(entity.getUUID(), entity);
            ((Map)this.entityLocations).put(it.getKey(), entity);
        }
        MeteoriteManager.INSTANCE.addTicks(this);
    }

    public final void flushRelative() {
        Map $this$forEach$iv = this.entityLocations;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            RelativeLocation key = (RelativeLocation)it.getKey();
            MeteoriteFallingBlockEntity entity = (MeteoriteFallingBlockEntity)((Object)it.getValue());
            Vec3 n = this.origin.add(key.toVector());
            Intrinsics.checkNotNull((Object)n);
            entity.tp(n);
            entity.updateAliveTick();
        }
    }

    public void tick() {
        MeteoriteFallingBlockEntity value;
        if (!this.valid || this.hit) {
            return;
        }
        Map.Entry entry = (Map.Entry)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)this.entities), Meteorite::tick$lambda$2));
        MeteoriteFallingBlockEntity meteoriteFallingBlockEntity = value = entry != null ? (MeteoriteFallingBlockEntity)((Object)entry.getValue()) : null;
        if (value != null) {
            Vec3 vec3 = value.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            this.hit(vec3);
            return;
        }
        int n = this.age;
        this.age = n + 1;
        if (n > this.maxAge) {
            this.hit(this.origin);
        }
        Vec3 vec3 = this.origin.add(this.direction.normalize().multiply(this.speed).toVector());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        this.origin = vec3;
        this.flushRelative();
    }

    public final void hit(@NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.hit = true;
        this.clear();
        this.onHit(pos);
    }

    public final void clear() {
        Map map;
        this.valid = false;
        Map $this$onEach$iv = this.entities;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            ((MeteoriteFallingBlockEntity)((Object)it.getValue())).discard();
        }
        ((HashMap)map).clear();
        this.entityLocations.clear();
    }

    private static final boolean tick$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((MeteoriteFallingBlockEntity)((Object)it.getValue())).checkEntityOrBlockInBox();
    }
}

