/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.meteorite;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.usefulmagic.entity.UsefulMagicEntityTypes;
import cn.coostack.usefulmagic.mixin.FallingBlockEntityAccessor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0006\u0010\u001d\u001a\u00020\u0019J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0002R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006$"}, d2={"Lcn/coostack/usefulmagic/meteorite/MeteoriteFallingBlockEntity;", "Lnet/minecraft/world/entity/item/FallingBlockEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/Vec3;)V", "current", "", "getCurrent", "()I", "setCurrent", "(I)V", "max", "getMax", "setMax", "getStartPos", "Lnet/minecraft/core/BlockPos;", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "tick", "updateAliveTick", "tp", "vec3d", "checkEntityOrBlockInBox", "", "isBlock", "Companion", "usefulmagic-neoforge-1.21.1"})
public final class MeteoriteFallingBlockEntity
extends FallingBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int current;
    private int max;
    private static final EntityDataAccessor<Integer> LAST_UPDATE_TIME = SynchedEntityData.defineId(MeteoriteFallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public MeteoriteFallingBlockEntity(@NotNull EntityType<? extends FallingBlockEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.max = 1200;
        this.dropItem = false;
    }

    public final int getCurrent() {
        return this.current;
    }

    public final void setCurrent(int n) {
        this.current = n;
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @NotNull
    public BlockPos getStartPos() {
        Object object = this.entityData.get(FallingBlockEntity.DATA_START_POS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockPos)object;
    }

    public MeteoriteFallingBlockEntity(@NotNull Level world, @NotNull BlockState state, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this((EntityType<? extends FallingBlockEntity>)UsefulMagicEntityTypes.INSTANCE.getMETEORITE_ENTITY().get(), world);
        Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.mixin.FallingBlockEntityAccessor");
        ((FallingBlockEntityAccessor)((Object)this)).setBlockState(state);
        this.disableDrop();
        this.setPos(pos.x, pos.y, pos.z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = ((Entity)this).getX();
        this.yo = ((Entity)this).getY();
        this.zo = ((Entity)this).getZ();
        this.entityData.set(FallingBlockEntity.DATA_START_POS, (Object)BlockPosExtendsKt.ofFloored((Vec3)pos));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(LAST_UPDATE_TIME, (Object)0);
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        int n = this.current;
        this.current = n + 1;
        if (n > this.max) {
            this.discard();
        }
        Object object = this.entityData.get(LAST_UPDATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (this.current - ((Number)object).intValue() > 20) {
            this.discard();
        }
    }

    public final void updateAliveTick() {
        this.entityData.set(LAST_UPDATE_TIME, (Object)this.current);
    }

    public final void tp(@NotNull Vec3 vec3d) {
        Intrinsics.checkNotNullParameter((Object)vec3d, (String)"vec3d");
        this.setPos(vec3d);
    }

    public final boolean checkEntityOrBlockInBox() {
        List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.2), arg_0 -> MeteoriteFallingBlockEntity.checkEntityOrBlockInBox$lambda$1(arg_0 -> MeteoriteFallingBlockEntity.checkEntityOrBlockInBox$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        return !((Collection)list).isEmpty() || this.isBlock();
    }

    private final boolean isBlock() {
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        BlockPos pos = BlockPosExtendsKt.ofFloored((Vec3)vec3);
        BlockState state = this.level().getBlockState(pos);
        boolean canAcross = !state.getFluidState().isEmpty() || state.isAir() || state.getCollisionShape((BlockGetter)this.level(), pos).isEmpty();
        return !canAcross;
    }

    private static final boolean checkEntityOrBlockInBox$lambda$0(MeteoriteFallingBlockEntity this$0, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it, (Object)((Object)this$0)) && !it.noPhysics;
    }

    private static final boolean checkEntityOrBlockInBox$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R:\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\u0013"}, d2={"Lcn/coostack/usefulmagic/meteorite/MeteoriteFallingBlockEntity$Companion;", "", "<init>", "()V", "LAST_UPDATE_TIME", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "getLAST_UPDATE_TIME$annotations", "create", "Lcn/coostack/usefulmagic/meteorite/MeteoriteFallingBlockEntity;", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "block", "Lnet/minecraft/world/level/block/Block;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "usefulmagic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLAST_UPDATE_TIME$annotations() {
        }

        @NotNull
        public final MeteoriteFallingBlockEntity create(@NotNull Level world, @NotNull BlockPos pos, @NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            BlockState blockState = block.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return this.create(world, pos, blockState);
        }

        @NotNull
        public final MeteoriteFallingBlockEntity create(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Vec3 vec3 = pos.getBottomCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getBottomCenter(...)");
            MeteoriteFallingBlockEntity entity = new MeteoriteFallingBlockEntity(world, state, vec3);
            world.addFreshEntity((Entity)entity);
            return entity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

