/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.packet.listener.client;

import cn.coostack.cooparticlesapi.platform.network.ClientContext;
import cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.formation.FormationCoreBlockEntity;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CEnergyCrystalChange;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFormationBreak;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFormationCreate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lcn/coostack/usefulmagic/packet/listener/client/FormationPacketListener;", "", "<init>", "()V", "handleCreate", "", "payload", "Lcn/coostack/usefulmagic/packet/s2c/PacketS2CFormationCreate;", "context", "Lcn/coostack/cooparticlesapi/platform/network/ClientContext;", "handleBreak", "Lcn/coostack/usefulmagic/packet/s2c/PacketS2CFormationBreak;", "handleEnergyChange", "Lcn/coostack/usefulmagic/packet/s2c/PacketS2CEnergyCrystalChange;", "usefulmagic-neoforge-1.21.1"})
public final class FormationPacketListener {
    @NotNull
    public static final FormationPacketListener INSTANCE = new FormationPacketListener();

    private FormationPacketListener() {
    }

    public final void handleCreate(@NotNull PacketS2CFormationCreate payload, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos pos = payload.getPos();
        ClientLevel clientLevel = context.client().level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel world = clientLevel;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        BlockEntity entity = blockEntity;
        if (!(entity instanceof FormationCoreBlockEntity)) {
            return;
        }
        ((FormationCoreBlockEntity)entity).getFormation().tryBuildFormation();
    }

    public final void handleBreak(@NotNull PacketS2CFormationBreak payload, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos pos = payload.getFormationPos();
        ClientLevel clientLevel = context.client().level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel world = clientLevel;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        BlockEntity entity = blockEntity;
        if (!(entity instanceof FormationCoreBlockEntity)) {
            return;
        }
        ((FormationCoreBlockEntity)entity).getFormation().breakFormation(payload.getDamage(), null);
    }

    public final void handleEnergyChange(@NotNull PacketS2CEnergyCrystalChange payload, @NotNull ClientContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockPos crystal = payload.getCrystal();
        ClientLevel clientLevel = context.client().level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel world = clientLevel;
        BlockEntity blockEntity = world.getBlockEntity(crystal);
        if (blockEntity == null) {
            return;
        }
        BlockEntity entity = blockEntity;
        if (!(entity instanceof EnergyCrystalsBlockEntity)) {
            return;
        }
        ((EnergyCrystalsBlockEntity)entity).setCurrentMana(payload.getMana());
        ((EnergyCrystalsBlockEntity)entity).setMaxMana(payload.getMaxMana());
        entity.setChanged();
    }
}

