/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.packet.listener.server;

import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.platform.network.ServerContext;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.packet.c2s.PacketC2SFriendListRequest;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFriendListResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcn/coostack/usefulmagic/packet/listener/server/FriendListRequestHandler;", "", "<init>", "()V", "receive", "", "payload", "Lcn/coostack/usefulmagic/packet/c2s/PacketC2SFriendListRequest;", "context", "Lcn/coostack/cooparticlesapi/platform/network/ServerContext;", "usefulmagic-neoforge-1.21.1"})
public final class FriendListRequestHandler {
    @NotNull
    public static final FriendListRequestHandler INSTANCE = new FriendListRequestHandler();

    private FriendListRequestHandler() {
    }

    public final void receive(@NotNull PacketC2SFriendListRequest payload, @NotNull ServerContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.player();
        UUID requestUUID = payload.getRequestUUID();
        int page = payload.getPage();
        int start = (page - 1) * 10;
        int end = page * 10;
        MagicPlayerData state = UsefulMagic.INSTANCE.getState().getDataFromServer(requestUUID);
        ArrayList<UUID> stateFriends = state.getFriends$usefulmagic_neoforge_1_21_1();
        if (stateFriends.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<PacketS2CFriendListResponse.PlayerProfile> res = new ArrayList<PacketS2CFriendListResponse.PlayerProfile>();
            int n = RangesKt.coerceAtMost((int)end, (int)stateFriends.size());
            for (int i = start; i < n; ++i) {
                UUID uuid;
                Intrinsics.checkNotNullExpressionValue((Object)stateFriends.get(i), (String)"get(...)");
                ServerPlayer serverPlayer = UsefulMagic.INSTANCE.getServer().getPlayerList().getPlayer(uuid);
                Object name = serverPlayer != null ? serverPlayer.getName() : null;
                Object object = name;
                if (object == null || (object = object.getString()) == null) {
                    object = "the player name not found";
                }
                res.add(new PacketS2CFriendListResponse.PlayerProfile(uuid, (String)object));
            }
            list = res;
        }
        List responseFriends = list;
        PacketS2CFriendListResponse packet = new PacketS2CFriendListResponse(responseFriends, stateFriends.size() / 10 + 1, requestUUID);
        CustomPacketPayload customPacketPayload = packet;
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, (ServerPlayer)player);
    }
}

