/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.particles.group.client;

import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.control.ParticleControler;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroupProvider;
import cn.coostack.cooparticlesapi.particles.impl.ControlableEnchantmentEffect;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/particles/group/client/EnchantBallBarrageParticleClient;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "pColor", "Lnet/minecraft/world/phys/Vec3;", "size", "", "r", "", "countPow", "", "uuid", "Ljava/util/UUID;", "<init>", "(Lnet/minecraft/world/phys/Vec3;FDILjava/util/UUID;)V", "getPColor", "()Lnet/minecraft/world/phys/Vec3;", "getSize", "()F", "getR", "()D", "getCountPow", "()I", "options", "getOptions", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "loadParticleLocations", "", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup$ParticleRelativeData;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "onGroupDisplay", "", "Provider", "usefulmagic-neoforge-1.21.1"})
public final class EnchantBallBarrageParticleClient
extends ControlableParticleGroup {
    @NotNull
    private final Vec3 pColor;
    private final float size;
    private final double r;
    private final int countPow;
    @NotNull
    private final Random random;

    public EnchantBallBarrageParticleClient(@NotNull Vec3 pColor, float size, double r, int countPow, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)pColor, (String)"pColor");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(uuid);
        this.pColor = pColor;
        this.size = size;
        this.r = r;
        this.countPow = countPow;
        this.random = new Random(System.currentTimeMillis());
    }

    @NotNull
    public final Vec3 getPColor() {
        return this.pColor;
    }

    public final float getSize() {
        return this.size;
    }

    public final double getR() {
        return this.r;
    }

    public final int getCountPow() {
        return this.countPow;
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public Map<ControlableParticleGroup.ParticleRelativeData, RelativeLocation> loadParticleLocations() {
        return new PointsBuilder().addBall(this.r, this.countPow * this.getOptions() / 2).createWithParticleEffects(arg_0 -> EnchantBallBarrageParticleClient.loadParticleLocations$lambda$4(this, arg_0));
    }

    public void onGroupDisplay() {
        this.addPreTickAction(arg_0 -> EnchantBallBarrageParticleClient.onGroupDisplay$lambda$5(this, arg_0));
    }

    private static final ParticleDisplayer loadParticleLocations$lambda$4$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParticleDisplayer.Companion.withSingle((ControlableParticleEffect)new ControlableEnchantmentEffect(it, false, 2, null));
    }

    private static final Unit loadParticleLocations$lambda$4$lambda$1(EnchantBallBarrageParticleClient this$0, ControlableParticle $this$withEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$withEffect, (String)"$this$withEffect");
        $this$withEffect.colorOfRGB((int)this$0.pColor.x, (int)this$0.pColor.y, (int)this$0.pColor.z);
        $this$withEffect.setParticleAlpha(0.4f);
        $this$withEffect.setSize(this$0.size);
        $this$withEffect.setCurrentAge(this$0.random.nextInt(0, $this$withEffect.getLifetime()));
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        $this$withEffect.setTextureSheet(particleRenderType);
        return Unit.INSTANCE;
    }

    private static final Unit loadParticleLocations$lambda$4$lambda$3$lambda$2(ParticleControler $it, Ref.BooleanRef $tick, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$addPreTickAction, (String)"$this$addPreTickAction");
        if ($it.getParticle().getParticleAlpha() >= 0.9f) {
            $tick.element = false;
        }
        if ($it.getParticle().getParticleAlpha() <= 0.2f) {
            $tick.element = true;
        }
        ControlableParticle controlableParticle = $it.getParticle();
        controlableParticle.setParticleAlpha(controlableParticle.getParticleAlpha() + ($tick.element ? 0.05f : -0.05f));
        return Unit.INSTANCE;
    }

    private static final Unit loadParticleLocations$lambda$4$lambda$3(ParticleControler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Ref.BooleanRef tick2 = new Ref.BooleanRef();
        tick2.element = true;
        it.addPreTickAction(arg_0 -> EnchantBallBarrageParticleClient.loadParticleLocations$lambda$4$lambda$3$lambda$2(it, tick2, arg_0));
        return Unit.INSTANCE;
    }

    private static final ControlableParticleGroup.ParticleRelativeData loadParticleLocations$lambda$4(EnchantBallBarrageParticleClient this$0, RelativeLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.withEffect(EnchantBallBarrageParticleClient::loadParticleLocations$lambda$4$lambda$0, arg_0 -> EnchantBallBarrageParticleClient.loadParticleLocations$lambda$4$lambda$1(this$0, arg_0)).withControler(EnchantBallBarrageParticleClient::loadParticleLocations$lambda$4$lambda$3);
    }

    private static final Unit onGroupDisplay$lambda$5(EnchantBallBarrageParticleClient this$0, ControlableParticleGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.rotateParticlesAsAxis(0.08726646259971647);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcn/coostack/usefulmagic/particles/group/client/EnchantBallBarrageParticleClient$Provider;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroupProvider;", "<init>", "()V", "createGroup", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "uuid", "Ljava/util/UUID;", "args", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "changeGroup", "", "group", "usefulmagic-neoforge-1.21.1"})
    public static final class Provider
    implements ControlableParticleGroupProvider {
        @NotNull
        public ControlableParticleGroup createGroup(@NotNull UUID uuid, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("r");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object object = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            double r = (Double)object;
            ParticleControlerDataBuffer<?> particleControlerDataBuffer2 = args.get("count_pow");
            Intrinsics.checkNotNull(particleControlerDataBuffer2);
            Object object2 = particleControlerDataBuffer2.getLoadedValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
            int countPow = (Integer)object2;
            ParticleControlerDataBuffer<?> particleControlerDataBuffer3 = args.get("color");
            Intrinsics.checkNotNull(particleControlerDataBuffer3);
            Object object3 = particleControlerDataBuffer3.getLoadedValue();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
            Vec3 color = (Vec3)object3;
            ParticleControlerDataBuffer<?> particleControlerDataBuffer4 = args.get("size_particle");
            Intrinsics.checkNotNull(particleControlerDataBuffer4);
            Object object4 = particleControlerDataBuffer4.getLoadedValue();
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Float");
            float size = ((Float)object4).floatValue();
            return new EnchantBallBarrageParticleClient(color, size, r, countPow, uuid);
        }

        public void changeGroup(@NotNull ControlableParticleGroup group, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(args, (String)"args");
        }
    }
}

