/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.particles.style.explosion;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleShapeStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleProvider;
import cn.coostack.cooparticlesapi.network.particle.style.SequencedParticleStyle;
import cn.coostack.cooparticlesapi.particles.Controlable;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.impl.ControlableFireworkEffect;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.builder.PointsBuilder;
import cn.coostack.cooparticlesapi.utils.helper.HelperUtil;
import cn.coostack.cooparticlesapi.utils.helper.buffer.ControlableBuffer;
import cn.coostack.cooparticlesapi.utils.helper.buffer.ControlableBufferHelper;
import cn.coostack.cooparticlesapi.utils.helper.impl.StyleStatusHelper;
import cn.coostack.usefulmagic.utils.ParticleOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001+B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0016J\u0018\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0%H\u0016J \u0010(\u001a\u00020\u00182\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020&\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0%H\u0016J\b\u0010*\u001a\u00020\u0018H\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lcn/coostack/usefulmagic/particles/style/explosion/ExplosionStarStyle;", "Lcn/coostack/cooparticlesapi/network/particle/style/SequencedParticleStyle;", "player", "Ljava/util/UUID;", "uuid", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;)V", "getPlayer", "()Ljava/util/UUID;", "setPlayer", "(Ljava/util/UUID;)V", "age", "", "getAge", "()I", "setAge", "(I)V", "maxAge", "getMaxAge", "statusHelper", "Lcn/coostack/cooparticlesapi/utils/helper/impl/StyleStatusHelper;", "getStatusHelper", "()Lcn/coostack/cooparticlesapi/utils/helper/impl/StyleStatusHelper;", "remove", "", "getParticlesCount", "options", "getOptions", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "getCurrentFramesSequenced", "Ljava/util/SortedMap;", "Lcn/coostack/cooparticlesapi/network/particle/style/SequencedParticleStyle$SortedStyleData;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "writePacketArgsSequenced", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "readPacketArgsSequenced", "args", "onDisplay", "Provider", "usefulmagic-neoforge-1.21.1"})
public final class ExplosionStarStyle
extends SequencedParticleStyle {
    @ControlableBuffer(name="player")
    @NotNull
    private UUID player;
    @ControlableBuffer(name="age")
    private int age;
    private final int maxAge;
    @NotNull
    private final StyleStatusHelper statusHelper;
    @NotNull
    private final Random random;

    public ExplosionStarStyle(@NotNull UUID player, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(256.0, uuid);
        this.player = player;
        this.maxAge = 20;
        this.statusHelper = HelperUtil.INSTANCE.styleStatus(1);
        this.statusHelper.loadControler((Controlable)this);
        this.random = new Random(System.currentTimeMillis());
    }

    public /* synthetic */ ExplosionStarStyle(UUID uUID, UUID uUID2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            UUID uUID3 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"randomUUID(...)");
            uUID2 = uUID3;
        }
        this(uUID, uUID2);
    }

    @NotNull
    public final UUID getPlayer() {
        return this.player;
    }

    public final void setPlayer(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.player = uUID;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    @NotNull
    public final StyleStatusHelper getStatusHelper() {
        return this.statusHelper;
    }

    public void remove() {
        if (this.statusHelper.getDisplayStatus() == 2) {
            super.remove();
        } else {
            this.statusHelper.setStatus(2);
        }
    }

    public int getParticlesCount() {
        return 2;
    }

    public final int getOptions() {
        return ParticleOption.INSTANCE.getParticleCounts();
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @NotNull
    public SortedMap<SequencedParticleStyle.SortedStyleData, RelativeLocation> getCurrentFramesSequenced() {
        TreeMap res = new TreeMap();
        int order = 1;
        ((Map)res).put(new SequencedParticleStyle.SortedStyleData(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$5(this, arg_0), order++), new RelativeLocation(0.0, 0.01, 0.0));
        ((Map)res).put(new SequencedParticleStyle.SortedStyleData(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$11(this, arg_0), order++), new RelativeLocation(0.0, 0.01, 0.0));
        return res;
    }

    @NotNull
    public Map<String, ParticleControlerDataBuffer<?>> writePacketArgsSequenced() {
        HashMap hashMap;
        HashMap it = hashMap = new HashMap(ControlableBufferHelper.INSTANCE.getPairs((Controlable)this));
        boolean bl = false;
        MapsKt.putAll((Map)it, (Iterable)this.statusHelper.toArgsPairs());
        return hashMap;
    }

    public void readPacketArgsSequenced(@NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.statusHelper.readFromServer(args);
    }

    public void onDisplay() {
        this.addPreTickAction(arg_0 -> ExplosionStarStyle.onDisplay$lambda$13(this, arg_0));
    }

    private static final ParticleDisplayer getCurrentFramesSequenced$lambda$5$lambda$2$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParticleDisplayer.Companion.withSingle((ControlableParticleEffect)new ControlableFireworkEffect(it, false, 2, null));
    }

    private static final Unit getCurrentFramesSequenced$lambda$5$lambda$2$lambda$1(ExplosionStarStyle this$0, ControlableParticle $this$withParticleHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$withParticleHandler, (String)"$this$withParticleHandler");
        $this$withParticleHandler.setSize(0.1f);
        $this$withParticleHandler.colorOfRGB(this$0.random.nextInt(170, 255), this$0.random.nextInt(180, 255), this$0.random.nextInt(230, 255));
        return Unit.INSTANCE;
    }

    private static final ParticleGroupStyle.StyleData getCurrentFramesSequenced$lambda$5$lambda$2(ExplosionStarStyle this$0, RelativeLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ParticleGroupStyle.StyleData(ExplosionStarStyle::getCurrentFramesSequenced$lambda$5$lambda$2$lambda$0).withParticleHandler(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$5$lambda$2$lambda$1(this$0, arg_0));
    }

    private static final Unit getCurrentFramesSequenced$lambda$5$lambda$4$lambda$3(Ref.IntRef $subAge, ParticleShapeStyle $this_toggleOnDisplay, ParticleGroupStyle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$addPreTickAction, (String)"$this$addPreTickAction");
        int n = $subAge.element;
        $subAge.element = n + 1;
        if ($subAge.element >= 10) {
            $this_toggleOnDisplay.scaleReversed(false);
        }
        $this$addPreTickAction.rotateParticlesAsAxis(0.39269908169872414);
        return Unit.INSTANCE;
    }

    private static final Unit getCurrentFramesSequenced$lambda$5$lambda$4(ExplosionStarStyle this$0, ParticleShapeStyle $this$toggleOnDisplay) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleOnDisplay, (String)"$this$toggleOnDisplay");
        $this$toggleOnDisplay.setAxis(RelativeLocation.Companion.zAxis());
        Ref.IntRef subAge = new Ref.IntRef();
        Level level = $this$toggleOnDisplay.getWorld();
        Intrinsics.checkNotNull((Object)level);
        Player player = level.getPlayerByUUID(this$0.player);
        if (player == null) {
            return Unit.INSTANCE;
        }
        Player player2 = player;
        Vec3 vec3 = $this$toggleOnDisplay.getPos();
        Vec3 vec32 = player2.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getEyePosition(...)");
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32);
        $this$toggleOnDisplay.rotateParticlesToPoint(RelativeLocation.Companion.of(dir));
        $this$toggleOnDisplay.addPreTickAction(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$5$lambda$4$lambda$3(subAge, $this$toggleOnDisplay, arg_0));
        return Unit.INSTANCE;
    }

    private static final ParticleDisplayer getCurrentFramesSequenced$lambda$5(ExplosionStarStyle this$0, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParticleDisplayer.Companion.withStyle((ParticleGroupStyle)new ParticleShapeStyle(it).appendBuilder(new PointsBuilder().addLine(new RelativeLocation(-0.5, 0.0, 0.0), new RelativeLocation(0.5, 0.0, 0.0), this$0.getOptions() * 2).addLine(new RelativeLocation(0.0, 0.35, 0.0), new RelativeLocation(0.0, -0.35, 0.0), this$0.getOptions() * 2), arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$5$lambda$2(this$0, arg_0)).toggleOnDisplay(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$5$lambda$4(this$0, arg_0)).loadScaleHelperBezierValue(0.01, 1.0, 10, new RelativeLocation(5.0, 0.99, 0.0), new RelativeLocation(-5.0, 0.0, 0.0)));
    }

    private static final ParticleDisplayer getCurrentFramesSequenced$lambda$11$lambda$8$lambda$6(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParticleDisplayer.Companion.withSingle((ControlableParticleEffect)new ControlableFireworkEffect(it, false, 2, null));
    }

    private static final Unit getCurrentFramesSequenced$lambda$11$lambda$8$lambda$7(ExplosionStarStyle this$0, ControlableParticle $this$withParticleHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$withParticleHandler, (String)"$this$withParticleHandler");
        $this$withParticleHandler.colorOfRGB(this$0.random.nextInt(230, 255), this$0.random.nextInt(130, 180), this$0.random.nextInt(130, 180));
        return Unit.INSTANCE;
    }

    private static final ParticleGroupStyle.StyleData getCurrentFramesSequenced$lambda$11$lambda$8(ExplosionStarStyle this$0, RelativeLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ParticleGroupStyle.StyleData(ExplosionStarStyle::getCurrentFramesSequenced$lambda$11$lambda$8$lambda$6).withParticleHandler(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$11$lambda$8$lambda$7(this$0, arg_0));
    }

    private static final Unit getCurrentFramesSequenced$lambda$11$lambda$10$lambda$9(Ref.IntRef $currentTick, ParticleShapeStyle $this_toggleOnDisplay, ParticleGroupStyle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$addPreTickAction, (String)"$this$addPreTickAction");
        $this$addPreTickAction.rotateParticlesAsAxis(-0.39269908169872414);
        int n = $currentTick.element;
        $currentTick.element = n + 1;
        if ($currentTick.element >= 5) {
            $this_toggleOnDisplay.scaleReversed(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getCurrentFramesSequenced$lambda$11$lambda$10(ExplosionStarStyle this$0, ParticleShapeStyle $this$toggleOnDisplay) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleOnDisplay, (String)"$this$toggleOnDisplay");
        Level level = $this$toggleOnDisplay.getWorld();
        Intrinsics.checkNotNull((Object)level);
        Player player = level.getPlayerByUUID(this$0.player);
        if (player == null) {
            return Unit.INSTANCE;
        }
        Player player2 = player;
        Vec3 vec3 = $this$toggleOnDisplay.getPos();
        Vec3 vec32 = player2.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getEyePosition(...)");
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32);
        $this$toggleOnDisplay.rotateParticlesToPoint(RelativeLocation.Companion.of(dir));
        Ref.IntRef currentTick = new Ref.IntRef();
        $this$toggleOnDisplay.addPreTickAction(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$11$lambda$10$lambda$9(currentTick, $this$toggleOnDisplay, arg_0));
        return Unit.INSTANCE;
    }

    private static final ParticleDisplayer getCurrentFramesSequenced$lambda$11(ExplosionStarStyle this$0, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParticleDisplayer.Companion.withStyle((ParticleGroupStyle)new ParticleShapeStyle(it).appendBuilder(new PointsBuilder().addCircle(0.4, 5 * this$0.getOptions()), arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$11$lambda$8(this$0, arg_0)).toggleOnDisplay(arg_0 -> ExplosionStarStyle.getCurrentFramesSequenced$lambda$11$lambda$10(this$0, arg_0)).loadScaleHelperBezierValue(1.0E-4, 1.0, 5, new RelativeLocation(2.5, 0.99, 0.0), new RelativeLocation(-2.5, 0.0, 0.0)));
    }

    private static final Unit onDisplay$lambda$13(ExplosionStarStyle this$0, ParticleGroupStyle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$addPreTickAction, (String)"$this$addPreTickAction");
        if (this$0.age == 1 && !$this$addPreTickAction.getClient()) {
            this$0.addSingle();
        }
        int n = this$0.age;
        this$0.age = n + 1;
        if (n > this$0.maxAge) {
            this$0.statusHelper.setStatus(2);
        }
        if (this$0.age == this$0.maxAge / 2 && !$this$addPreTickAction.getClient()) {
            this$0.addSingle();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016\u00a8\u0006\f"}, d2={"Lcn/coostack/usefulmagic/particles/style/explosion/ExplosionStarStyle$Provider;", "Lcn/coostack/cooparticlesapi/network/particle/style/ParticleStyleProvider;", "<init>", "()V", "createStyle", "Lcn/coostack/cooparticlesapi/network/particle/style/ParticleGroupStyle;", "uuid", "Ljava/util/UUID;", "args", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "usefulmagic-neoforge-1.21.1"})
    public static final class Provider
    implements ParticleStyleProvider {
        @NotNull
        public ParticleGroupStyle createStyle(@NotNull UUID uuid, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            ExplosionStarStyle explosionStarStyle;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("player");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object object = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.UUID");
            ExplosionStarStyle it = explosionStarStyle = new ExplosionStarStyle((UUID)object, uuid);
            boolean bl = false;
            it.readPacketArgs(args);
            return (ParticleGroupStyle)explosionStarStyle;
        }
    }
}

