/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.renderer;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.data.CooVertexFormat;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.utils.ShaderUtil;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import cn.coostack.usefulmagic.blocks.entity.formation.FormationCoreBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 @2\u00020\u0001:\u0001@B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u0001H\u0016J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u000102H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020.H\u0016J\b\u00107\u001a\u00020.H\u0016J(\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020?H\u0016J\u0006\u0010\u001c\u001a\u00020.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006A"}, d2={"Lcn/coostack/usefulmagic/renderer/DefendCrystalRenderEntity;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "maxRange", "", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;D)V", "getMaxRange", "()D", "color", "Lorg/joml/Vector3f;", "getColor", "()Lorg/joml/Vector3f;", "setColor", "(Lorg/joml/Vector3f;)V", "r", "getR", "setR", "alpha", "getAlpha", "setAlpha", "(D)V", "prevR", "getPrevR", "setPrevR", "over", "", "getOver", "()Z", "setOver", "(Z)V", "overTick", "", "getOverTick", "()I", "setOverTick", "(I)V", "formationPos", "getFormationPos", "()Lnet/minecraft/world/phys/Vec3;", "setFormationPos", "(Lnet/minecraft/world/phys/Vec3;)V", "initialize", "", "loadProfileFromEntity", "another", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getRenderID", "Lnet/minecraft/resources/ResourceLocation;", "release", "tick", "render", "matrices", "Lorg/joml/Matrix4fStack;", "viewMatrix", "Lorg/joml/Matrix4f;", "projMatrix", "tickDelta", "", "Companion", "usefulmagic-neoforge-1.21.1"})
public final class DefendCrystalRenderEntity
extends RenderEntity {
    @NotNull
    public static final Companion Companion;
    private final double maxRange;
    @NotNull
    private Vector3f color;
    @NotNull
    private Vector3f r;
    private double alpha;
    @NotNull
    private Vector3f prevR;
    private boolean over;
    private int overTick;
    @NotNull
    private Vec3 formationPos;
    @NotNull
    private static final SimpleVertexBuffer ballVertexBuffer;
    @NotNull
    private static final CooShaderProgram fresnalShader;
    @NotNull
    private static final CooShaderProgram colorShader;
    @JvmField
    public static boolean initialized;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, RenderEntity> CODEC;
    @JvmField
    @NotNull
    public static final ResourceLocation ID;

    public DefendCrystalRenderEntity(@Nullable Level world, @NotNull Vec3 pos, double maxRange) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(world, pos);
        this.maxRange = maxRange;
        this.color = new Vector3f(0.39215687f, 0.39215687f, 0.54901963f);
        this.r = new Vector3f(2.0f);
        this.alpha = 1.0;
        this.prevR = new Vector3f();
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.formationPos = vec3;
    }

    public final double getMaxRange() {
        return this.maxRange;
    }

    @NotNull
    public final Vector3f getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.color = vector3f;
    }

    @NotNull
    public final Vector3f getR() {
        return this.r;
    }

    public final void setR(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.r = vector3f;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    @NotNull
    public final Vector3f getPrevR() {
        return this.prevR;
    }

    public final void setPrevR(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.prevR = vector3f;
    }

    public final boolean getOver() {
        return this.over;
    }

    public final void setOver(boolean bl) {
        this.over = bl;
    }

    public final int getOverTick() {
        return this.overTick;
    }

    public final void setOverTick(int n) {
        this.overTick = n;
    }

    @NotNull
    public final Vec3 getFormationPos() {
        return this.formationPos;
    }

    public final void setFormationPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.formationPos = vec3;
    }

    public void initialize() {
        Companion.initStatic();
    }

    public void loadProfileFromEntity(@NotNull RenderEntity another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        super.loadProfileFromEntity(another);
        if (!(another instanceof DefendCrystalRenderEntity)) {
            return;
        }
        this.color = ((DefendCrystalRenderEntity)another).color;
        this.r = ((DefendCrystalRenderEntity)another).r;
        this.alpha = ((DefendCrystalRenderEntity)another).alpha;
        this.overTick = ((DefendCrystalRenderEntity)another).overTick;
        this.over = ((DefendCrystalRenderEntity)another).over;
        this.formationPos = ((DefendCrystalRenderEntity)another).formationPos;
    }

    @NotNull
    public StreamCodec<FriendlyByteBuf, RenderEntity> getCodec() {
        return CODEC;
    }

    @NotNull
    public ResourceLocation getRenderID() {
        return ID;
    }

    public void release() {
    }

    public void tick() {
        super.tick();
        this.prevR = this.r;
        if (!this.over) {
            double range = this.maxRange / (double)20.0f * (double)Math.min(this.getAge(), 20);
            this.r = new Vector3f((float)range);
        } else {
            double r1 = this.maxRange - this.maxRange / (double)20 * (double)(this.getAge() - this.overTick);
            if (r1 <= 0.0 || this.getAge() - this.overTick > 20) {
                this.setCanceled(true);
                return;
            }
            this.r = new Vector3f((float)r1);
        }
        Level level = this.getWorld();
        if (level != null ? level.isClientSide : true) {
            return;
        }
        Level level2 = this.getWorld();
        Intrinsics.checkNotNull((Object)level2);
        Level world = level2;
        BlockEntity get = world.getBlockEntity(BlockPosExtendsKt.ofFloored((Vec3)this.formationPos));
        if (!(get instanceof FormationCoreBlockEntity) || !((FormationCoreBlockEntity)get).getFormation().getInTriggerRangeActive() && ((FormationCoreBlockEntity)get).getFormation().getSettings().getDisplayDefendBallOnlyTrigger() || !((FormationCoreBlockEntity)get).getFormation().isActiveFormation() || !((FormationCoreBlockEntity)get).getFormation().getHasDefend()) {
            this.over();
        }
    }

    public void render(@NotNull Matrix4fStack matrices, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        Vector3f deltaR = GraphMathHelper.lerp((Vector3f)new Vector3f(tickDelta), (Vector3f)this.prevR, (Vector3f)this.r);
        RenderSystem.enableBlend();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        matrices.pushMatrix();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)1);
        fresnalShader.useOnContext(arg_0 -> DefendCrystalRenderEntity.render$lambda$0(projMatrix, viewMatrix, matrices, deltaR, this, camera, arg_0));
        RenderSystem.depthMask((boolean)true);
        matrices.popMatrix();
    }

    public final void over() {
        if (this.over) {
            return;
        }
        this.over = true;
        this.overTick = this.getAge();
        this.markDirty();
    }

    private static final Unit render$lambda$0(Matrix4f $projMatrix, Matrix4f $viewMatrix, Matrix4fStack $matrices, Vector3f $deltaR, DefendCrystalRenderEntity this$0, Camera $camera, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        $this$useOnContext.setMatrix4("projMat", $projMatrix);
        $this$useOnContext.setMatrix4("viewMat", $viewMatrix);
        Matrix4f matrix4f = $matrices.scale((Vector3fc)$deltaR);
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"scale(...)");
        $this$useOnContext.setMatrix4("transMat", matrix4f);
        Vec3 vec3 = this$0.getPos();
        Vec3 vec32 = $camera.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getPosition(...)");
        Vector3f vector3f = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32).toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"toVector3f(...)");
        $this$useOnContext.setFloat3("camera", vector3f);
        Vector3f vector3f2 = $camera.getLookVector();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"getLookVector(...)");
        $this$useOnContext.setFloat3("camera_view", vector3f2);
        $this$useOnContext.setFloat3("glowColor", this$0.color);
        $this$useOnContext.setFloat("glowIntensity", 5.0f);
        $this$useOnContext.setFloat("glowFalloff", 5.0f);
        $this$useOnContext.setFloat("emptyAlpha", 0.05f);
        $this$useOnContext.setFloat("fsl", 0.1f);
        ballVertexBuffer.draw();
        return Unit.INSTANCE;
    }

    private static final void CODEC$lambda$2(FriendlyByteBuf buf, RenderEntity data) {
        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.renderer.DefendCrystalRenderEntity");
        DefendCrystalRenderEntity cfr_ignored_0 = (DefendCrystalRenderEntity)data;
        buf.writeDouble(((DefendCrystalRenderEntity)data).maxRange);
        Intrinsics.checkNotNull((Object)buf);
        RenderEntity.Companion.encodeBase(buf, data);
        buf.writeDouble(((DefendCrystalRenderEntity)data).alpha);
        buf.writeVector3f(((DefendCrystalRenderEntity)data).r);
        buf.writeVector3f(((DefendCrystalRenderEntity)data).color);
        buf.writeBoolean(((DefendCrystalRenderEntity)data).over);
        buf.writeInt(((DefendCrystalRenderEntity)data).overTick);
        buf.writeVec3(((DefendCrystalRenderEntity)data).formationPos);
    }

    private static final RenderEntity CODEC$lambda$3(FriendlyByteBuf it) {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        DefendCrystalRenderEntity instance = new DefendCrystalRenderEntity(null, vec3, it.readDouble());
        Intrinsics.checkNotNull((Object)it);
        RenderEntity.Companion.decodeBase(it, (RenderEntity)instance);
        instance.alpha = it.readDouble();
        Vector3f vector3f = it.readVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"readVector3f(...)");
        instance.r = vector3f;
        Vector3f vector3f2 = it.readVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"readVector3f(...)");
        instance.color = vector3f2;
        instance.over = it.readBoolean();
        instance.overTick = it.readInt();
        Vec3 vec32 = it.readVec3();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"readVec3(...)");
        instance.formationPos = vec32;
        return instance;
    }

    @JvmStatic
    public static final void initStatic() {
        Companion.initStatic();
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, RenderEntity> getCODEC() {
        return Companion.getCODEC();
    }

    static {
        SimpleVertexBuffer simpleVertexBuffer;
        Companion = new Companion(null);
        SimpleVertexBuffer $this$ballVertexBuffer_u24lambda_u241 = simpleVertexBuffer = new SimpleVertexBuffer();
        boolean bl = false;
        $this$ballVertexBuffer_u24lambda_u241.setVertexes(ShaderUtil.INSTANCE.genBall(1.0f, 64, 64), CooVertexFormat.POINT_FORMAT);
        ballVertexBuffer = simpleVertexBuffer;
        ShaderProgramBuilder shaderProgramBuilder = new ShaderProgramBuilder();
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/vsh/ball_point.vsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        ShaderProgramBuilder shaderProgramBuilder2 = shaderProgramBuilder.vertex((GlShader)new IdentifierShader(resourceLocation, GlShaderType.VERTEX));
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/fsh/fresnal.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        fresnalShader = shaderProgramBuilder2.fragment((GlShader)new IdentifierShader(resourceLocation2, GlShaderType.FRAGMENT)).build();
        ShaderProgramBuilder shaderProgramBuilder3 = new ShaderProgramBuilder().vertex("core/vertex/point.vsh");
        ResourceLocation resourceLocation3 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/fsh/color.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"fromNamespaceAndPath(...)");
        colorShader = shaderProgramBuilder3.fragment((GlShader)new IdentifierShader(resourceLocation3, GlShaderType.FRAGMENT)).build();
        StreamCodec streamCodec = StreamCodec.of(DefendCrystalRenderEntity::CODEC$lambda$2, DefendCrystalRenderEntity::CODEC$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        CODEC = streamCodec;
        ResourceLocation resourceLocation4 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"defend_crystal_entity");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"fromNamespaceAndPath(...)");
        ID = resourceLocation4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcn/coostack/usefulmagic/renderer/DefendCrystalRenderEntity$Companion;", "", "<init>", "()V", "ballVertexBuffer", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "getBallVertexBuffer", "()Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "fresnalShader", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "getFresnalShader", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "colorShader", "getColorShader", "initialized", "", "initStatic", "", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "getCODEC$annotations", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "usefulmagic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleVertexBuffer getBallVertexBuffer() {
            return ballVertexBuffer;
        }

        @NotNull
        public final CooShaderProgram getFresnalShader() {
            return fresnalShader;
        }

        @NotNull
        public final CooShaderProgram getColorShader() {
            return colorShader;
        }

        @JvmStatic
        public final void initStatic() {
            if (initialized) {
                return;
            }
            initialized = true;
            this.getFresnalShader().init();
            this.getBallVertexBuffer().init();
            this.getColorShader().init();
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, RenderEntity> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

