/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.renderer;

import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.client.ShaderPipeManagers;
import cn.coostack.cooparticlesapi.renderer.shader.ShaderProgramBuilder;
import cn.coostack.cooparticlesapi.renderer.shader.api.CooShaderProgram;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShader;
import cn.coostack.cooparticlesapi.renderer.shader.api.glsl.GlShaderType;
import cn.coostack.cooparticlesapi.renderer.shader.data.CooVertexFormat;
import cn.coostack.cooparticlesapi.renderer.shader.glsl.IdentifierShader;
import cn.coostack.cooparticlesapi.renderer.shader.pipe.manager.ShaderPipeManager;
import cn.coostack.cooparticlesapi.renderer.shader.utils.ShaderUtil;
import cn.coostack.cooparticlesapi.renderer.shader.vertex.SimpleVertexBuffer;
import cn.coostack.cooparticlesapi.utils.GraphMathHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00019B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0001H\u0016J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00010)H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020%H\u0016J(\u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u001fH\u0016J\u0018\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\u001fH\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcn/coostack/usefulmagic/renderer/SkyFallingRenderEntity;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "world", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V", "color", "Lorg/joml/Vector3f;", "getColor", "()Lorg/joml/Vector3f;", "setColor", "(Lorg/joml/Vector3f;)V", "r", "getR", "setR", "alpha", "", "getAlpha", "()D", "setAlpha", "(D)V", "prevR", "getPrevR", "setPrevR", "maxAge", "", "getMaxAge", "()I", "speed", "", "getSpeed", "()F", "setSpeed", "(F)V", "initialize", "", "loadProfileFromEntity", "another", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "getRenderID", "Lnet/minecraft/resources/ResourceLocation;", "release", "tick", "render", "matrices", "Lorg/joml/Matrix4fStack;", "viewMatrix", "Lorg/joml/Matrix4f;", "projMatrix", "tickDelta", "vecMinValue", "vec", "min", "Companion", "usefulmagic-neoforge-1.21.1"})
public final class SkyFallingRenderEntity
extends RenderEntity {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private Vector3f color;
    @NotNull
    private Vector3f r;
    private double alpha;
    @NotNull
    private Vector3f prevR;
    private final int maxAge;
    private float speed;
    @NotNull
    private static final SimpleVertexBuffer cylinderVertexBuffer;
    @NotNull
    private static final ShaderPipeManager bloom;
    @NotNull
    private static final CooShaderProgram fresnalShader;
    @NotNull
    private static final CooShaderProgram colorShader;
    @JvmField
    public static boolean initialized;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, RenderEntity> CODEC;
    @JvmField
    @NotNull
    public static final ResourceLocation ID;

    public SkyFallingRenderEntity(@Nullable Level world, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super(world, pos);
        this.color = new Vector3f(0.39215687f, 0.039215688f, 0.9254902f);
        this.r = new Vector3f(1.0f);
        this.alpha = 1.0;
        this.prevR = new Vector3f();
        this.maxAge = 180;
    }

    @NotNull
    public final Vector3f getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.color = vector3f;
    }

    @NotNull
    public final Vector3f getR() {
        return this.r;
    }

    public final void setR(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.r = vector3f;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    @NotNull
    public final Vector3f getPrevR() {
        return this.prevR;
    }

    public final void setPrevR(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.prevR = vector3f;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public final void setSpeed(float f) {
        this.speed = f;
    }

    public void initialize() {
        Companion.initStatic();
    }

    public void loadProfileFromEntity(@NotNull RenderEntity another) {
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        super.loadProfileFromEntity(another);
        if (!(another instanceof SkyFallingRenderEntity)) {
            return;
        }
        this.color = ((SkyFallingRenderEntity)another).color;
        this.r = ((SkyFallingRenderEntity)another).r;
        this.alpha = ((SkyFallingRenderEntity)another).alpha;
        this.speed = ((SkyFallingRenderEntity)another).speed;
    }

    @NotNull
    public StreamCodec<FriendlyByteBuf, RenderEntity> getCodec() {
        return CODEC;
    }

    @NotNull
    public ResourceLocation getRenderID() {
        return ID;
    }

    public void release() {
    }

    public void tick() {
        float y;
        super.tick();
        this.prevR = this.r;
        int n = this.getAge();
        boolean bl = 0 <= n ? n < 81 : false;
        if (bl) {
            float x = (float)this.getAge() - 1.0f;
            y = -0.0065625f * (float)Math.pow(x - (float)80, 2) + (float)48;
            this.r = new Vector3f(y);
            this.r.y = 360.0f;
        }
        if (this.getAge() > this.maxAge) {
            this.setCanceled(true);
        }
        if (this.getAge() > this.maxAge - 10) {
            int x = 10 + this.getAge() - this.maxAge;
            y = 0.48f * (float)Math.pow((float)x - 10.0f, 2);
            this.r = new Vector3f(y);
            this.r.y = 360.0f;
        }
    }

    public void render(@NotNull Matrix4fStack matrices, @NotNull Matrix4f viewMatrix, @NotNull Matrix4f projMatrix, float tickDelta) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)viewMatrix, (String)"viewMatrix");
        Intrinsics.checkNotNullParameter((Object)projMatrix, (String)"projMatrix");
        Vector3f deltaR = GraphMathHelper.lerp((Vector3f)new Vector3f(tickDelta), (Vector3f)this.prevR, (Vector3f)this.r);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        bloom.writeFrame(() -> SkyFallingRenderEntity.render$lambda$1(matrices, projMatrix, viewMatrix, this, deltaR));
        matrices.pushMatrix();
        RenderSystem.enableBlend();
        fresnalShader.useOnContext(arg_0 -> SkyFallingRenderEntity.render$lambda$2(projMatrix, viewMatrix, matrices, this, tickDelta, deltaR, arg_0));
        matrices.popMatrix();
        RenderSystem.disableDepthTest();
        bloom.render();
    }

    private final Vector3f vecMinValue(Vector3f vec, float min) {
        return new Vector3f(RangesKt.coerceAtLeast((float)vec.x, (float)min), RangesKt.coerceAtLeast((float)vec.y, (float)min), RangesKt.coerceAtLeast((float)vec.z, (float)min));
    }

    private static final Unit render$lambda$1$lambda$0(Matrix4f $projMatrix, Matrix4f $viewMatrix, Matrix4fStack $matrices, SkyFallingRenderEntity this$0, Vector3f $deltaR, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        $this$useOnContext.setMatrix4("projMat", $projMatrix);
        $this$useOnContext.setMatrix4("viewMat", $viewMatrix);
        Matrix4f matrix4f = $matrices.scale((Vector3fc)this$0.vecMinValue($deltaR, 0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"scale(...)");
        $this$useOnContext.setMatrix4("transMat", matrix4f);
        $this$useOnContext.setFloat3("color", this$0.color);
        $this$useOnContext.setFloat("alpha", (float)this$0.alpha);
        cylinderVertexBuffer.draw();
        return Unit.INSTANCE;
    }

    private static final void render$lambda$1(Matrix4fStack $matrices, Matrix4f $projMatrix, Matrix4f $viewMatrix, SkyFallingRenderEntity this$0, Vector3f $deltaR) {
        $matrices.pushMatrix();
        colorShader.useOnContext(arg_0 -> SkyFallingRenderEntity.render$lambda$1$lambda$0($projMatrix, $viewMatrix, $matrices, this$0, $deltaR, arg_0));
        $matrices.popMatrix();
    }

    private static final Unit render$lambda$2(Matrix4f $projMatrix, Matrix4f $viewMatrix, Matrix4fStack $matrices, SkyFallingRenderEntity this$0, float $tickDelta, Vector3f $deltaR, CooShaderProgram $this$useOnContext) {
        Intrinsics.checkNotNullParameter((Object)$this$useOnContext, (String)"$this$useOnContext");
        $this$useOnContext.setMatrix4("projMat", $projMatrix);
        $this$useOnContext.setMatrix4("viewMat", $viewMatrix);
        Vector3f vector3f = new Vector3f(GraphMathHelper.lerp((float)(((float)(this$0.getAge() - 10) + $tickDelta) / 20.0f), (float)0.0f, (float)1.2f)).add((Vector3fc)$deltaR);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"add(...)");
        Matrix4f matrix4f = $matrices.scale((Vector3fc)this$0.vecMinValue(vector3f, 0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"scale(...)");
        $this$useOnContext.setMatrix4("transMat", matrix4f);
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vector3f vector3f2 = camera.getPosition().toVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"toVector3f(...)");
        $this$useOnContext.setFloat3("camera", vector3f2);
        $this$useOnContext.setFloat3("glowColor", this$0.color);
        $this$useOnContext.setFloat("glowIntensity", 10.0f);
        $this$useOnContext.setFloat("glowFalloff", 5.0f);
        $this$useOnContext.setFloat("fsl", 1.3f);
        cylinderVertexBuffer.draw();
        return Unit.INSTANCE;
    }

    private static final void CODEC$lambda$4(FriendlyByteBuf buf, RenderEntity data) {
        Intrinsics.checkNotNull((Object)buf);
        Intrinsics.checkNotNull((Object)data);
        RenderEntity.Companion.encodeBase(buf, data);
        SkyFallingRenderEntity cfr_ignored_0 = (SkyFallingRenderEntity)data;
        buf.writeDouble(((SkyFallingRenderEntity)data).alpha);
        buf.writeFloat(((SkyFallingRenderEntity)data).speed);
        buf.writeVector3f(((SkyFallingRenderEntity)data).r);
        buf.writeVector3f(((SkyFallingRenderEntity)data).color);
    }

    private static final RenderEntity CODEC$lambda$5(FriendlyByteBuf it) {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        SkyFallingRenderEntity instance = new SkyFallingRenderEntity(null, vec3);
        Intrinsics.checkNotNull((Object)it);
        RenderEntity.Companion.decodeBase(it, (RenderEntity)instance);
        instance.alpha = it.readDouble();
        instance.speed = it.readFloat();
        Vector3f vector3f = it.readVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"readVector3f(...)");
        instance.r = vector3f;
        Vector3f vector3f2 = it.readVector3f();
        Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"readVector3f(...)");
        instance.color = vector3f2;
        return instance;
    }

    @JvmStatic
    public static final void initStatic() {
        Companion.initStatic();
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, RenderEntity> getCODEC() {
        return Companion.getCODEC();
    }

    static {
        SimpleVertexBuffer simpleVertexBuffer;
        Companion = new Companion(null);
        SimpleVertexBuffer $this$cylinderVertexBuffer_u24lambda_u243 = simpleVertexBuffer = new SimpleVertexBuffer();
        boolean bl = false;
        $this$cylinderVertexBuffer_u24lambda_u243.setVertexes(ShaderUtil.INSTANCE.genCylinder(1.0f, 72.0f, 1.0f), CooVertexFormat.POINT_FORMAT);
        cylinderVertexBuffer = simpleVertexBuffer;
        bloom = ShaderPipeManagers.INSTANCE.getSimpleBloom();
        ShaderProgramBuilder shaderProgramBuilder = new ShaderProgramBuilder();
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/vsh/cylinder_point.vsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        ShaderProgramBuilder shaderProgramBuilder2 = shaderProgramBuilder.vertex((GlShader)new IdentifierShader(resourceLocation, GlShaderType.VERTEX));
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/fsh/fresnal.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        fresnalShader = shaderProgramBuilder2.fragment((GlShader)new IdentifierShader(resourceLocation2, GlShaderType.FRAGMENT)).build();
        ShaderProgramBuilder shaderProgramBuilder3 = new ShaderProgramBuilder().vertex("core/vertex/point.vsh");
        ResourceLocation resourceLocation3 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"core/fsh/color.fsh");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"fromNamespaceAndPath(...)");
        colorShader = shaderProgramBuilder3.fragment((GlShader)new IdentifierShader(resourceLocation3, GlShaderType.FRAGMENT)).build();
        StreamCodec streamCodec = StreamCodec.of(SkyFallingRenderEntity::CODEC$lambda$4, SkyFallingRenderEntity::CODEC$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        CODEC = streamCodec;
        ResourceLocation resourceLocation4 = ResourceLocation.fromNamespaceAndPath((String)"usefulmagic", (String)"sky_falling_render");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"fromNamespaceAndPath(...)");
        ID = resourceLocation4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u00138\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcn/coostack/usefulmagic/renderer/SkyFallingRenderEntity$Companion;", "", "<init>", "()V", "cylinderVertexBuffer", "Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "getCylinderVertexBuffer", "()Lcn/coostack/cooparticlesapi/renderer/shader/vertex/SimpleVertexBuffer;", "bloom", "Lcn/coostack/cooparticlesapi/renderer/shader/pipe/manager/ShaderPipeManager;", "getBloom", "()Lcn/coostack/cooparticlesapi/renderer/shader/pipe/manager/ShaderPipeManager;", "fresnalShader", "Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "getFresnalShader", "()Lcn/coostack/cooparticlesapi/renderer/shader/api/CooShaderProgram;", "colorShader", "getColorShader", "initialized", "", "initStatic", "", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/renderer/RenderEntity;", "getCODEC$annotations", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "usefulmagic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleVertexBuffer getCylinderVertexBuffer() {
            return cylinderVertexBuffer;
        }

        @NotNull
        public final ShaderPipeManager getBloom() {
            return bloom;
        }

        @NotNull
        public final CooShaderProgram getFresnalShader() {
            return fresnalShader;
        }

        @NotNull
        public final CooShaderProgram getColorShader() {
            return colorShader;
        }

        @JvmStatic
        public final void initStatic() {
            if (initialized) {
                return;
            }
            initialized = true;
            this.getFresnalShader().init();
            this.getCylinderVertexBuffer().init();
            this.getColorShader().init();
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, RenderEntity> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getCODEC$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

