/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.skill.api;

import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.api.SkillCancelCondition;
import cn.coostack.usefulmagic.skill.api.SkillCancelable;
import cn.coostack.usefulmagic.skill.api.SkillCondition;
import cn.coostack.usefulmagic.skill.api.SkillDamageCancelCondition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\"J\b\u0010%\u001a\u0004\u0018\u00010\u0010J\u000e\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010J\u0010\u0010'\u001a\u00020\"2\b\b\u0002\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u000fJ\u0010\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010+\u001a\u00020\u000fJ\u0006\u0010-\u001a\u00020)J\u0018\u0010.\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\b\b\u0002\u0010/\u001a\u00020)J\u0006\u00100\u001a\u00020\"J\b\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020\"H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcn/coostack/usefulmagic/skill/api/EntitySkillManager;", "", "owner", "Lnet/minecraft/world/entity/LivingEntity;", "<init>", "(Lnet/minecraft/world/entity/LivingEntity;)V", "getOwner", "()Lnet/minecraft/world/entity/LivingEntity;", "setOwner", "cacheUUID", "Ljava/util/UUID;", "getCacheUUID", "()Ljava/util/UUID;", "skills", "Ljava/util/HashMap;", "", "Lcn/coostack/usefulmagic/skill/api/Skill;", "Lkotlin/collections/HashMap;", "countdownStorage", "", "activeHoldingTick", "random", "Lkotlin/random/Random;", "value", "active", "getActive", "()Lcn/coostack/usefulmagic/skill/api/Skill;", "setActive$usefulmagic_neoforge_1_21_1", "(Lcn/coostack/usefulmagic/skill/api/Skill;)V", "getSkills", "", "predicate", "Ljava/util/function/Predicate;", "addSkill", "", "skill", "setEntityDeath", "choiceSkill", "setSkillCountdown", "resetActiveSkill", "release", "", "hasCD", "id", "getSkill", "hasActiveSkill", "setActiveSkill", "cancelBefore", "tick", "handleActiveSkill", "handleCountDown", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEntitySkillManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitySkillManager.kt\ncn/coostack/usefulmagic/skill/api/EntitySkillManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,144:1\n536#2:145\n521#2,6:146\n1463#3,14:152\n*S KotlinDebug\n*F\n+ 1 EntitySkillManager.kt\ncn/coostack/usefulmagic/skill/api/EntitySkillManager\n*L\n19#1:145\n19#1:146,6\n45#1:152,14\n*E\n"})
public final class EntitySkillManager {
    @NotNull
    private LivingEntity owner;
    @NotNull
    private final UUID cacheUUID;
    @NotNull
    private final HashMap<String, Skill> skills;
    @NotNull
    private final HashMap<String, Integer> countdownStorage;
    private int activeHoldingTick;
    @NotNull
    private final Random random;
    @Nullable
    private Skill active;

    public EntitySkillManager(@NotNull LivingEntity owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.cacheUUID = uUID;
        this.skills = new HashMap();
        this.countdownStorage = new HashMap();
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    @NotNull
    public final LivingEntity getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"<set-?>");
        this.owner = livingEntity;
    }

    @NotNull
    public final UUID getCacheUUID() {
        return this.cacheUUID;
    }

    @Nullable
    public final Skill getActive() {
        return this.active;
    }

    public final void setActive$usefulmagic_neoforge_1_21_1(@Nullable Skill skill) {
        this.active = skill;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Skill> getSkills(@NotNull Predicate<Skill> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Map $this$filter$iv = this.skills;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!predicate.test((Skill)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final void addSkill(@NotNull Skill skill) {
        Intrinsics.checkNotNullParameter((Object)skill, (String)"skill");
        ((Map)this.skills).put(skill.getSkillID(), skill);
    }

    public final void setEntityDeath() {
        this.resetActiveSkill(false);
    }

    @Nullable
    public final Skill choiceSkill() {
        Object v0;
        Sequence $this$maxByOrNull$iv = SequencesKt.filter((Sequence)MapsKt.asSequence((Map)this.skills), arg_0 -> EntitySkillManager.choiceSkill$lambda$1(this, arg_0));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Map.Entry it = (Map.Entry)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = (double)this.random.nextInt(100) * ((Skill)it.getValue()).getChance();
                do {
                    Object e$iv = iterator$iv.next();
                    Map.Entry it2 = (Map.Entry)e$iv;
                    $i$a$-maxByOrNull-EntitySkillManager$choiceSkill$2 = false;
                    double v$iv = (double)this.random.nextInt(100) * ((Skill)it2.getValue()).getChance();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Map.Entry entry = v0;
        return entry != null ? (Skill)entry.getValue() : null;
    }

    public final void setSkillCountdown(@NotNull Skill skill) {
        Intrinsics.checkNotNullParameter((Object)skill, (String)"skill");
        ((Map)this.countdownStorage).put(skill.getSkillID(), skill.getSkillCountDown(this.owner));
    }

    public final void resetActiveSkill(boolean release) {
        if (!release) {
            Skill skill = this.active;
            if (skill != null) {
                skill.stopHolding(this.owner, this.activeHoldingTick);
            }
        }
        this.active = null;
        this.activeHoldingTick = 0;
    }

    public static /* synthetic */ void resetActiveSkill$default(EntitySkillManager entitySkillManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        entitySkillManager.resetActiveSkill(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCD(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (!this.countdownStorage.containsKey(id)) return false;
        Integer n = this.countdownStorage.get(id);
        if (n == null) return false;
        int n2 = n;
        if (n2 <= 0) return false;
        return true;
    }

    @Nullable
    public final Skill getSkill(@NotNull String id) {
        int cd;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Integer n = this.countdownStorage.get(id);
        int n2 = cd = n != null ? n : 0;
        if (cd > 0) {
            return null;
        }
        return this.skills.get(id);
    }

    public final boolean hasActiveSkill() {
        return this.active != null;
    }

    public final void setActiveSkill(@NotNull Skill skill, boolean cancelBefore) {
        Intrinsics.checkNotNullParameter((Object)skill, (String)"skill");
        if (cancelBefore) {
            Skill skill2 = this.active;
            if (skill2 != null) {
                skill2.stopHolding(this.owner, this.activeHoldingTick);
            }
        }
        skill.onActive(this.owner);
        this.activeHoldingTick = 0;
        this.active = skill;
    }

    public static /* synthetic */ void setActiveSkill$default(EntitySkillManager entitySkillManager, Skill skill, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        entitySkillManager.setActiveSkill(skill, bl);
    }

    public final void tick() {
        this.handleCountDown();
        if (!this.hasActiveSkill()) {
            return;
        }
        this.handleActiveSkill();
    }

    private final void handleActiveSkill() {
        if (this.active == null) {
            return;
        }
        int n = this.activeHoldingTick;
        this.activeHoldingTick = n + 1;
        Skill skill = this.active;
        Intrinsics.checkNotNull((Object)skill);
        if (n >= skill.getMaxHoldingTick(this.owner)) {
            Skill skill2 = this.active;
            Intrinsics.checkNotNull((Object)skill2);
            skill2.onRelease(this.owner, this.activeHoldingTick);
            Skill skill3 = this.active;
            Intrinsics.checkNotNull((Object)skill3);
            this.setSkillCountdown(skill3);
            Skill skill4 = this.active;
            Intrinsics.checkNotNull((Object)skill4);
            skill4.holdingTick(this.owner, this.activeHoldingTick);
            this.resetActiveSkill(true);
            return;
        }
        Skill skill5 = this.active;
        Intrinsics.checkNotNull((Object)skill5);
        skill5.holdingTick(this.owner, this.activeHoldingTick);
        if (this.active instanceof SkillCancelCondition) {
            Skill skill6 = this.active;
            Intrinsics.checkNotNull((Object)skill6, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.skill.api.SkillCancelCondition");
            SkillCancelCondition condition = (SkillCancelCondition)((Object)skill6);
            if (condition.testCancel(this.owner)) {
                condition.setCanceled(true);
            }
        }
        if (this.active instanceof SkillCancelable) {
            Skill skill7 = this.active;
            Intrinsics.checkNotNull((Object)skill7, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.skill.api.SkillCancelable");
            SkillCancelable cancelable = (SkillCancelable)((Object)skill7);
            boolean cd = cancelable.getCancelSetCD();
            if (cancelable.getCanceled()) {
                if (cd) {
                    Skill skill8 = this.active;
                    Intrinsics.checkNotNull((Object)skill8);
                    this.setSkillCountdown(skill8);
                }
                this.resetActiveSkill(false);
                cancelable.setCanceled(false);
                if (this.active instanceof SkillDamageCancelCondition) {
                    Skill skill9 = this.active;
                    Intrinsics.checkNotNull((Object)skill9, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.skill.api.SkillDamageCancelCondition");
                    ((SkillDamageCancelCondition)((Object)skill9)).setDamageAmount(0.0f);
                }
            }
        }
    }

    private final void handleCountDown() {
        Iterator iterator = ((Map)this.countdownStorage).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ((Map)this.countdownStorage).put(entry.getKey(), ((Number)entry.getValue()).intValue() - 1);
            if (((Number)entry.getValue()).intValue() > 0) continue;
            iterator.remove();
        }
    }

    private static final boolean choiceSkill$lambda$1(EntitySkillManager this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean cd = !this$0.hasCD((String)it.getKey());
        Skill value = (Skill)it.getValue();
        return value instanceof SkillCondition ? ((SkillCondition)((Object)value)).canTrigger(this$0.owner) && cd : cd;
    }
}

