/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.skill.player;

import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.type.EmittersShootTypes;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.utils.ServerCameraUtil;
import cn.coostack.usefulmagic.extend.Vec3ExtendKt;
import cn.coostack.usefulmagic.particles.emitters.DirectionShootEmitters;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.player.ComboCondition;
import cn.coostack.usefulmagic.states.ComboState;
import cn.coostack.usefulmagic.utils.ComboUtil;
import cn.coostack.usefulmagic.utils.FallingBlockHelper;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u001e\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcn/coostack/usefulmagic/skill/player/HeavyHitSkill;", "Lcn/coostack/usefulmagic/skill/api/Skill;", "Lcn/coostack/usefulmagic/skill/player/ComboCondition;", "damage", "", "<init>", "(F)V", "getDamage", "()F", "chance", "", "getChance", "()D", "setChance", "(D)V", "getSkillCountDown", "", "source", "Lnet/minecraft/world/entity/LivingEntity;", "onActive", "", "onRelease", "holdingTick", "getMaxHoldingTick", "holdingEntity", "holdTicks", "stopHolding", "entity", "getSkillID", "", "triggerComboMin", "getTriggerComboMin", "()I", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHeavyHitSkill.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeavyHitSkill.kt\ncn/coostack/usefulmagic/skill/player/HeavyHitSkill\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1869#2,2:139\n1869#2,2:141\n*S KotlinDebug\n*F\n+ 1 HeavyHitSkill.kt\ncn/coostack/usefulmagic/skill/player/HeavyHitSkill\n*L\n52#1:139,2\n104#1:141,2\n*E\n"})
public final class HeavyHitSkill
implements Skill,
ComboCondition {
    private final float damage;
    private double chance;

    public HeavyHitSkill(float damage) {
        this.damage = damage;
        this.chance = 1.0;
    }

    public final float getDamage() {
        return this.damage;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    @Override
    public int getSkillCountDown(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return 0;
    }

    @Override
    public void onActive(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRelease(@NotNull LivingEntity source, int holdingTick) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!this.canTrigger(source)) {
            return;
        }
        UUID uUID = source.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ComboState state = ComboUtil.INSTANCE.getComboState(uUID);
        int combo = state.getCount();
        HitBox hitBox = HitBox.Companion.of((double)combo * 2.0, (double)combo * 2.0, (double)combo * 2.0);
        AABB aABB = AABB.ofSize((Vec3)source.position().add(0.0, -1.0, 0.0), (double)((double)combo * 1.0), (double)1.0, (double)((double)combo * 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"ofSize(...)");
        Level level = source.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        List<BlockPos> blockPosList = FallingBlockHelper.INSTANCE.getBoxIncludeBlockPosList(aABB, level);
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        Level level2 = source.level();
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
        List<FallingBlockEntity> entities = FallingBlockHelper.INSTANCE.conversionBlockToFallingBlocks(blockPosList, false, level2);
        Iterable $this$forEach$iv2 = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            FallingBlockEntity it = (FallingBlockEntity)element$iv;
            boolean bl = false;
            it.dropItem = true;
            double v = it.position().distanceTo(source.position()) / ((double)combo * 1.5);
            it.setDeltaMovement(new Vec3(random.nextDouble(-0.5, 0.5), v, random.nextDouble(-0.5, 0.5)));
            it.hurtMarked = true;
        }
        Player cfr_ignored_0 = (Player)source;
        ((Player)source).setDeltaMovement(new Vec3(0.0, (double)combo * 0.5 + 0.2, 0.0));
        source.hurtMarked = true;
        Vec3 vec3 = source.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Object $this$onRelease_u24lambda_u242 = $i$f$forEach = new DirectionShootEmitters(vec3, source.level());
        boolean bl = false;
        $this$onRelease_u24lambda_u242.setMaxTick(4);
        $this$onRelease_u24lambda_u242.setShootDirection(new Vec3(0.0, 1.0, 0.0));
        $this$onRelease_u24lambda_u242.setRandomX(0.2);
        $this$onRelease_u24lambda_u242.setRandomZ(0.2);
        $this$onRelease_u24lambda_u242.setRandomY(0.2);
        $this$onRelease_u24lambda_u242.setSpeedDrag(0.98);
        $this$onRelease_u24lambda_u242.setCount(10 * combo);
        $this$onRelease_u24lambda_u242.setShootType(EmittersShootTypes.box((HitBox)hitBox));
        $this$onRelease_u24lambda_u242.setGravity(0.05);
        ControlableParticleData controlableParticleData = $this$onRelease_u24lambda_u242.getTemplateData();
        ControlableParticleData $this$onRelease_u24lambda_u242_u24lambda_u241 = controlableParticleData;
        boolean bl2 = false;
        $this$onRelease_u24lambda_u242_u24lambda_u241.setSpeed(0.5);
        $this$onRelease_u24lambda_u242_u24lambda_u241.setMaxAge(25);
        UUID uUID2 = $this$onRelease_u24lambda_u242_u24lambda_u241.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
        $this$onRelease_u24lambda_u242_u24lambda_u241.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID2, false, 2, null));
        DirectionShootEmitters emitter = $i$f$forEach;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        Level level3 = source.level();
        Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level3;
        Vec3 vec32 = source.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
        ServerCameraUtil.INSTANCE.sendShake(serverLevel, vec32, 32.0, 0.3, 5);
        Vec3 vec33 = source.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
        AABB box = hitBox.ofBox(vec33);
        $this$onRelease_u24lambda_u242 = source.level().getEntitiesOfClass(LivingEntity.class, box, arg_0 -> HeavyHitSkill.onRelease$lambda$4(arg_0 -> HeavyHitSkill.onRelease$lambda$3(source, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)$this$onRelease_u24lambda_u242, (String)"getEntitiesOfClass(...)");
        $this$onRelease_u24lambda_u242 = (Iterable)$this$onRelease_u24lambda_u242;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl3 = false;
            DamageSource attack = it.damageSources().playerAttack((Player)source);
            it.hurt(attack, this.damage * (float)combo / (float)3);
            float len = RangesKt.coerceAtLeast((float)it.distanceTo((Entity)source), (float)0.1f);
            double hitStrength = (double)combo / (double)(len * (float)2);
            Vec3 vec34 = source.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"position(...)");
            Vec3 vec35 = it.getEyePosition();
            Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"getEyePosition(...)");
            Vec3 vec36 = Vec3ExtendsKt.relativize((Vec3)vec34, (Vec3)vec35).normalize();
            Intrinsics.checkNotNullExpressionValue((Object)vec36, (String)"normalize(...)");
            Vec3 rel = Vec3ExtendKt.multiply(vec36, hitStrength);
            it.setDeltaMovement(rel);
            it.hurtMarked = true;
        }
        source.level().playSound(null, ((Player)source).getX(), ((Player)source).getY(), ((Player)source).getZ(), SoundEvents.MACE_SMASH_GROUND_HEAVY, SoundSource.PLAYERS, 5.0f, 1.2f);
        state.reset();
    }

    @Override
    public int getMaxHoldingTick(@NotNull LivingEntity holdingEntity) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        return 0;
    }

    @Override
    public void holdingTick(@NotNull LivingEntity holdingEntity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
    }

    @Override
    public void stopHolding(@NotNull LivingEntity entity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    @Override
    @NotNull
    public String getSkillID() {
        return "HeavyHitSkill";
    }

    @Override
    public int getTriggerComboMin() {
        return 3;
    }

    @Override
    public boolean canTrigger(@NotNull LivingEntity entity) {
        return ComboCondition.super.canTrigger(entity);
    }

    @Override
    public int compareTo(@NotNull ComboCondition other) {
        return ComboCondition.super.compareTo(other);
    }

    private static final boolean onRelease$lambda$3(LivingEntity $source, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((Player)$source).getUUID());
    }

    private static final boolean onRelease$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

