/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.skill.player;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.barrages.BarrageOption;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.usefulmagic.particles.barrages.entity.skill.GiantSwordLightBarrage;
import cn.coostack.usefulmagic.particles.emitters.ParticleWaveEmitters;
import cn.coostack.usefulmagic.particles.style.skill.SwordLightStyle;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.player.ComboCondition;
import cn.coostack.usefulmagic.states.ComboState;
import cn.coostack.usefulmagic.utils.ComboUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcn/coostack/usefulmagic/skill/player/PlayerSwordLightSkill;", "Lcn/coostack/usefulmagic/skill/api/Skill;", "Lcn/coostack/usefulmagic/skill/player/ComboCondition;", "<init>", "()V", "chance", "", "getChance", "()D", "setChance", "(D)V", "triggerComboMin", "", "getTriggerComboMin", "()I", "getSkillCountDown", "source", "Lnet/minecraft/world/entity/LivingEntity;", "style", "Lcn/coostack/usefulmagic/particles/style/skill/SwordLightStyle;", "getStyle", "()Lcn/coostack/usefulmagic/particles/style/skill/SwordLightStyle;", "setStyle", "(Lcn/coostack/usefulmagic/particles/style/skill/SwordLightStyle;)V", "onActive", "", "onRelease", "holdingTick", "getMaxHoldingTick", "holdingEntity", "holdTicks", "stopHolding", "entity", "getSkillID", "", "usefulmagic-neoforge-1.21.1"})
public final class PlayerSwordLightSkill
implements Skill,
ComboCondition {
    private double chance = 1.0;
    private final int triggerComboMin;
    @NotNull
    private SwordLightStyle style = new SwordLightStyle(null, 1, null);

    public PlayerSwordLightSkill() {
        this.triggerComboMin = 15;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    @Override
    public int getTriggerComboMin() {
        return this.triggerComboMin;
    }

    @Override
    public int getSkillCountDown(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return 0;
    }

    @NotNull
    public final SwordLightStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull SwordLightStyle swordLightStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)swordLightStyle), (String)"<set-?>");
        this.style = swordLightStyle;
    }

    @Override
    public void onActive(@NotNull LivingEntity source) {
        SwordLightStyle spawnedStyle;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        UUID uUID = source.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ComboState combo = ComboUtil.INSTANCE.getComboState(uUID);
        combo.setCount(combo.getCount() - this.getTriggerComboMin());
        this.style = spawnedStyle = new SwordLightStyle(null, 1, null);
        Vec3 currentPos = source.getEyePosition();
        Vec3 direction = source.getForward();
        Level world = source.level();
        Ref.ObjectRef findTarget = new Ref.ObjectRef();
        for (int i = 1; i < 51; ++i) {
            currentPos = currentPos.add(direction);
            List entities = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)currentPos, (double)4.0, (double)4.0, (double)4.0), arg_0 -> PlayerSwordLightSkill.onActive$lambda$1(arg_0 -> PlayerSwordLightSkill.onActive$lambda$0(source, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)entities);
            if (!(!((Collection)entities).isEmpty())) continue;
            findTarget.element = CollectionsKt.random((Collection)entities, (Random)((Random)Random.Default));
            break;
        }
        if (findTarget.element != null) {
            this.style.setLockedEntityID(((LivingEntity)findTarget.element).getId());
        }
        Vec3 spawnPos = source.getEyePosition().add(0.0, 30.0, 0.0);
        Intrinsics.checkNotNull((Object)spawnPos);
        Vec3 vec3 = currentPos;
        Intrinsics.checkNotNull((Object)vec3);
        Vec3 rotateDirection = Vec3ExtendsKt.relativize((Vec3)spawnPos, (Vec3)vec3);
        Intrinsics.checkNotNull((Object)world);
        ParticleStyleManager.INSTANCE.spawnStyle(world, spawnPos, (ParticleGroupStyle)spawnedStyle);
        CooParticlesAPI.scheduler.runTask(20, () -> PlayerSwordLightSkill.onActive$lambda$7(spawnedStyle, findTarget, spawnPos, world, source, rotateDirection));
    }

    @Override
    public void onRelease(@NotNull LivingEntity source, int holdingTick) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
    }

    @Override
    public int getMaxHoldingTick(@NotNull LivingEntity holdingEntity) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        return 0;
    }

    @Override
    public void holdingTick(@NotNull LivingEntity holdingEntity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
    }

    @Override
    public void stopHolding(@NotNull LivingEntity entity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.onRelease(entity, holdTicks);
    }

    @Override
    @NotNull
    public String getSkillID() {
        return "PlayerSwordLightSkill";
    }

    @Override
    public boolean canTrigger(@NotNull LivingEntity entity) {
        return ComboCondition.super.canTrigger(entity);
    }

    @Override
    public int compareTo(@NotNull ComboCondition other) {
        return ComboCondition.super.compareTo(other);
    }

    private static final boolean onActive$lambda$0(LivingEntity $source, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)$source.getUUID());
    }

    private static final boolean onActive$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void onActive$lambda$7$lambda$6(GiantSwordLightBarrage $barrage) {
        ControlableParticleData controlableParticleData;
        ParticleWaveEmitters particleWaveEmitters;
        ParticleWaveEmitters $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245 = particleWaveEmitters = new ParticleWaveEmitters($barrage.getLoc(), (Level)$barrage.getWorld());
        boolean bl = false;
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setWaveSpeed(0.01);
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setWaveSize(5.0);
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setMaxTick(1);
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setWaveAxis($barrage.getDirection());
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setWaveCircleCountMin(50);
        $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.setWaveCircleCountMax(150);
        ControlableParticleData it = controlableParticleData = $this$onActive_u24lambda_u247_u24lambda_u246_u24lambda_u245.getTemplateData();
        boolean bl2 = false;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        it.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        it.setMaxAge(50);
        it.setColor(Math3DUtil.INSTANCE.colorOf(80, 80, 255));
        ParticleWaveEmitters emitter = particleWaveEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        $barrage.getOptions().setSpeed(1.5);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onActive$lambda$7(SwordLightStyle $spawnedStyle, Ref.ObjectRef $findTarget, Vec3 $spawnPos, Level $world, LivingEntity $source, Vec3 $rotateDirection) {
        void $this$onActive_u24lambda_u247_u24lambda_u242;
        Object object;
        LivingEntity livingEntity = (LivingEntity)$findTarget.element;
        int n = livingEntity != null ? livingEntity.getId() : -1;
        Intrinsics.checkNotNull((Object)$spawnPos);
        Intrinsics.checkNotNull((Object)$world, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        BarrageOption barrageOption = object = new BarrageOption();
        ServerLevel serverLevel = (ServerLevel)$world;
        Vec3 vec3 = $spawnPos;
        int n2 = n;
        SwordLightStyle swordLightStyle = $spawnedStyle;
        boolean bl = false;
        $this$onActive_u24lambda_u247_u24lambda_u242.setSpeed(0.05);
        $this$onActive_u24lambda_u247_u24lambda_u242.setEnableSpeed(true);
        $this$onActive_u24lambda_u247_u24lambda_u242.setMaxLivingTick(1200);
        $this$onActive_u24lambda_u247_u24lambda_u242.setNoneHitBoxTick(20);
        Unit unit = Unit.INSTANCE;
        Intrinsics.checkNotNull((Object)$source, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player player = (Player)$source;
        double d = 80.0;
        BarrageOption barrageOption2 = object;
        ServerLevel serverLevel2 = serverLevel;
        Vec3 vec32 = vec3;
        int n3 = n2;
        SwordLightStyle swordLightStyle2 = swordLightStyle;
        GiantSwordLightBarrage barrage = new GiantSwordLightBarrage(swordLightStyle2, n3, vec32, serverLevel2, barrageOption2, d, player);
        Object $this$onActive_u24lambda_u247_u24lambda_u243 = object = barrage;
        boolean bl2 = false;
        $this$onActive_u24lambda_u247_u24lambda_u243.setDirection($rotateDirection);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
        CooParticlesAPI.scheduler.runTask(20, () -> PlayerSwordLightSkill.onActive$lambda$7$lambda$6(barrage));
    }
}

