/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.skill.player;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.extend.Vec3ExtendKt;
import cn.coostack.usefulmagic.particles.emitters.LineEmitters;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.api.SkillCancelCondition;
import cn.coostack.usefulmagic.skill.player.ComboCondition;
import cn.coostack.usefulmagic.states.ComboState;
import cn.coostack.usefulmagic.states.ManaServerState;
import cn.coostack.usefulmagic.utils.ComboUtil;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010%\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010+\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/\u00a8\u00063"}, d2={"Lcn/coostack/usefulmagic/skill/player/PlayerSwordSlashSkill;", "Lcn/coostack/usefulmagic/skill/api/Skill;", "Lcn/coostack/usefulmagic/skill/player/ComboCondition;", "Lcn/coostack/usefulmagic/skill/api/SkillCancelCondition;", "damage", "", "<init>", "(F)V", "getDamage", "()F", "chance", "", "getChance", "()D", "setChance", "(D)V", "getMaxHoldingTick", "", "holdingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getSkillCountDown", "source", "onActive", "", "onRelease", "holdingTick", "holdTicks", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "handleOnceDamage", "attacker", "stopHolding", "entity", "getSkillID", "", "triggerComboMin", "getTriggerComboMin", "()I", "canTrigger", "", "testCancel", "canceled", "getCanceled", "()Z", "setCanceled", "(Z)V", "cancelSetCD", "getCancelSetCD", "setCancelSetCD", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPlayerSwordSlashSkill.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerSwordSlashSkill.kt\ncn/coostack/usefulmagic/skill/player/PlayerSwordSlashSkill\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1869#2,2:128\n*S KotlinDebug\n*F\n+ 1 PlayerSwordSlashSkill.kt\ncn/coostack/usefulmagic/skill/player/PlayerSwordSlashSkill\n*L\n96#1:128,2\n*E\n"})
public final class PlayerSwordSlashSkill
implements Skill,
ComboCondition,
SkillCancelCondition {
    private final float damage;
    private double chance;
    @NotNull
    private final Random random;
    private boolean canceled;
    private boolean cancelSetCD;

    public PlayerSwordSlashSkill(float damage) {
        this.damage = damage;
        this.chance = 0.5;
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    public final float getDamage() {
        return this.damage;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    @Override
    public int getMaxHoldingTick(@NotNull LivingEntity holdingEntity) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        return 0;
    }

    @Override
    public int getSkillCountDown(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return 0;
    }

    @Override
    public void onActive(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.setCanceled(false);
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(2, 20, () -> PlayerSwordSlashSkill.onActive$lambda$0(this, source));
    }

    @Override
    public void onRelease(@NotNull LivingEntity source, int holdingTick) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        UUID uUID = source.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        ComboState state = ComboUtil.INSTANCE.getComboState(uUID);
        state.setCount(state.getCount() - this.getTriggerComboMin());
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID2 = source.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        MagicPlayerData manaData = manaServerState.getDataFromServer(uUID2);
        manaData.setMana(manaData.getMana() - 200);
    }

    @Override
    public void holdingTick(@NotNull LivingEntity holdingEntity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleOnceDamage(LivingEntity attacker) {
        void $this$forEach$iv;
        LineEmitters lineEmitters;
        if (!(attacker instanceof Player)) {
            return;
        }
        Vec3 vec3 = ((Player)attacker).getEyePosition();
        Vec3 vec32 = ((Player)attacker).getForward();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getForward(...)");
        Vec3 targetPos = vec3.add(Vec3ExtendKt.multiply(vec32, 4.0));
        Vec3 spawnPos = targetPos.add(this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0));
        Intrinsics.checkNotNull((Object)spawnPos);
        Intrinsics.checkNotNull((Object)targetPos);
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)spawnPos, (Vec3)targetPos);
        Object $this$handleOnceDamage_u24lambda_u242 = lineEmitters = new LineEmitters(spawnPos, attacker.level());
        boolean bl = false;
        ControlableParticleData controlableParticleData = $this$handleOnceDamage_u24lambda_u242.getTemplateData();
        ControlableParticleData $this$handleOnceDamage_u24lambda_u242_u24lambda_u241 = controlableParticleData;
        boolean bl2 = false;
        UUID uUID = $this$handleOnceDamage_u24lambda_u242_u24lambda_u241.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        $this$handleOnceDamage_u24lambda_u242_u24lambda_u241.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        $this$handleOnceDamage_u24lambda_u242_u24lambda_u241.setMaxAge(10);
        $this$handleOnceDamage_u24lambda_u242_u24lambda_u241.setSize(0.1f);
        $this$handleOnceDamage_u24lambda_u242.setMaxTick(1);
        $this$handleOnceDamage_u24lambda_u242.setEndPos(Vec3ExtendKt.multiply(dir, 2.0));
        $this$handleOnceDamage_u24lambda_u242.setCount((int)(dir.length() * (double)3));
        LineEmitters emitter = lineEmitters;
        Level world = attacker.level();
        world.playSound(null, ((Player)attacker).getX(), ((Player)attacker).getY(), ((Player)attacker).getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 10.0f, 1.5f);
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        List list = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)targetPos, (double)6.0, (double)6.0, (double)6.0), arg_0 -> PlayerSwordSlashSkill.handleOnceDamage$lambda$4(arg_0 -> PlayerSwordSlashSkill.handleOnceDamage$lambda$3(attacker, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        $this$handleOnceDamage_u24lambda_u242 = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl3 = false;
            DamageSource source = it.damageSources().playerAttack((Player)attacker);
            it.invulnerableTime = 0;
            it.hurt(source, this.damage);
        }
    }

    @Override
    public void stopHolding(@NotNull LivingEntity entity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.onRelease(entity, holdTicks);
    }

    @Override
    @NotNull
    public String getSkillID() {
        return "player-sword-slash-skill";
    }

    @Override
    public int getTriggerComboMin() {
        return 7;
    }

    @Override
    public boolean canTrigger(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof ServerPlayer)) {
            return false;
        }
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID = ((ServerPlayer)entity).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        MagicPlayerData manaData = manaServerState.getDataFromServer(uUID);
        return ComboCondition.super.canTrigger(entity) && manaData.getMana() >= 200;
    }

    @Override
    public boolean testCancel(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !this.canTrigger(entity);
    }

    @Override
    public boolean getCanceled() {
        return this.canceled;
    }

    @Override
    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public boolean getCancelSetCD() {
        return this.cancelSetCD;
    }

    @Override
    public void setCancelSetCD(boolean bl) {
        this.cancelSetCD = bl;
    }

    @Override
    public int compareTo(@NotNull ComboCondition other) {
        return ComboCondition.super.compareTo(other);
    }

    private static final void onActive$lambda$0(PlayerSwordSlashSkill this$0, LivingEntity $source) {
        this$0.handleOnceDamage($source);
    }

    private static final boolean handleOnceDamage$lambda$3(LivingEntity $attacker, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((Player)$attacker).getUUID());
    }

    private static final boolean handleOnceDamage$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

