/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.utils;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.DefendCrystal;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.utils.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J:\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ:\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ:\u0010 \u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cR\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Lcn/coostack/usefulmagic/utils/ExplosionUtil;", "", "<init>", "()V", "DEFAULT", "Lnet/minecraft/world/level/ExplosionDamageCalculator;", "getDEFAULT$annotations", "getDEFAULT", "()Lnet/minecraft/world/level/ExplosionDamageCalculator;", "createRoundExplosion", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "center", "Lnet/minecraft/world/phys/Vec3;", "power", "", "radius", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "count", "", "sourceType", "Lnet/minecraft/world/level/Level$ExplosionInteraction;", "createSolidBallExplosion", "maxRadius", "drop", "", "displayBrokenParticles", "createHollowSphereExplosion", "currentRadius", "createHollowSphereExplosionIgnoreWater", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nExplosionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplosionUtil.kt\ncn/coostack/usefulmagic/utils/ExplosionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1869#2,2:171\n1563#2:173\n1634#2,3:174\n1869#2,2:177\n1563#2:179\n1634#2,3:180\n1869#2,2:183\n1563#2:185\n1634#2,3:186\n1869#2,2:189\n*S KotlinDebug\n*F\n+ 1 ExplosionUtil.kt\ncn/coostack/usefulmagic/utils/ExplosionUtil\n*L\n33#1:171,2\n55#1:173\n55#1:174,3\n58#1:177,2\n98#1:179\n98#1:180,3\n101#1:183,2\n138#1:185\n138#1:186,3\n141#1:189,2\n*E\n"})
public final class ExplosionUtil {
    @NotNull
    public static final ExplosionUtil INSTANCE = new ExplosionUtil();
    @NotNull
    private static final ExplosionDamageCalculator DEFAULT = new ExplosionDamageCalculator();

    private ExplosionUtil() {
    }

    @NotNull
    public static final ExplosionDamageCalculator getDEFAULT() {
        return DEFAULT;
    }

    @JvmStatic
    public static /* synthetic */ void getDEFAULT$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final void createRoundExplosion(@NotNull ServerLevel world, @NotNull Vec3 center, float power, double radius, @NotNull LivingEntity entity, int count, @NotNull Level.ExplosionInteraction sourceType) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Iterable iterable = Math3DUtil.INSTANCE.getPolygonInCircleVertices(count, radius);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl = false;
            it.add(RelativeLocation.Companion.of(center));
            Vec3 pos = it.toVector();
            BlockFormation formation = ServerFormationManager.INSTANCE.getFormationFromPos(pos, world);
            if (formation != null && formation.hasCrystalType(DefendCrystal.class) && formation.isActiveFormation()) {
                formation.attack(8.0f * power, new LivingEntityTargetOption(entity, false), pos);
            }
            if (!world.hasChunk((int)it.getX() >> 4, (int)it.getZ() >> 4)) continue;
            world.explode((Entity)entity, it.getX(), it.getY(), it.getZ(), power, sourceType);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createSolidBallExplosion(int maxRadius, @NotNull ServerLevel world, @NotNull Vec3 center, @NotNull LivingEntity entity, boolean drop, boolean displayBrokenParticles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$map$iv = MathUtil.INSTANCE.getSolidBall(maxRadius);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelativeLocation relativeLocation = (RelativeLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BlockPosExtendsKt.ofFloored((Vec3)it.plus(RelativeLocation.Companion.of(center)).toVector()));
        }
        Set solidBall = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = solidBall;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            if (!world.hasChunkAt(it)) continue;
            Vec3 vec3 = it.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            BlockFormation formation = ServerFormationManager.INSTANCE.getFormationFromPos(vec3, world);
            if (formation != null && formation.hasCrystalType(DefendCrystal.class) && formation.isActiveFormation()) {
                FormationTargetOption formationTargetOption = new LivingEntityTargetOption(entity, false);
                Vec3 vec32 = it.getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                formation.attack(0.5f, formationTargetOption, vec32);
                continue;
            }
            BlockState state = world.getBlockState(it);
            FluidState fluid = world.getFluidState(it);
            float resistance = Math.max(state.getBlock().getExplosionResistance(), fluid.getExplosionResistance());
            boolean canBreak = resistance >= 0.0f && resistance < 1000.0f && fluid.isEmpty() && !state.isAir();
            if (!canBreak) continue;
            if (!displayBrokenParticles && !drop) {
                world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (displayBrokenParticles && !drop) {
                world.destroyBlock(it, false, (Entity)entity);
            }
            if (!drop || displayBrokenParticles) continue;
            BlockEntity blockEntity = world.getBlockEntity(it);
            Block.dropResources((BlockState)state, (Level)((Level)world), (BlockPos)it, (BlockEntity)blockEntity, (Entity)((Entity)entity), (ItemStack)ItemStack.EMPTY);
            world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static /* synthetic */ void createSolidBallExplosion$default(ExplosionUtil explosionUtil, int n, ServerLevel serverLevel, Vec3 vec3, LivingEntity livingEntity, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        explosionUtil.createSolidBallExplosion(n, serverLevel, vec3, livingEntity, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void createHollowSphereExplosion(int currentRadius, @NotNull ServerLevel world, @NotNull Vec3 center, @NotNull LivingEntity entity, boolean drop, boolean displayBrokenParticles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$map$iv = MathUtil.INSTANCE.getSolidBall(currentRadius);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelativeLocation relativeLocation = (RelativeLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BlockPosExtendsKt.ofFloored((Vec3)it.plus(RelativeLocation.Companion.of(center)).toVector()));
        }
        Set hollowSphere = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = hollowSphere;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            if (!world.hasChunkAt(it)) continue;
            Vec3 vec3 = it.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            BlockFormation formation = ServerFormationManager.INSTANCE.getFormationFromPos(vec3, world);
            if (formation != null && formation.hasCrystalType(DefendCrystal.class) && formation.isActiveFormation()) {
                FormationTargetOption formationTargetOption = new LivingEntityTargetOption(entity, false);
                Vec3 vec32 = it.getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                formation.attack(0.5f, formationTargetOption, vec32);
                continue;
            }
            BlockState state = world.getBlockState(it);
            FluidState fluid = world.getFluidState(it);
            float resistance = Math.max(state.getBlock().getExplosionResistance(), fluid.getExplosionResistance());
            boolean canBreak = resistance >= 0.0f && resistance < 1000.0f && fluid.isEmpty() && !state.isAir();
            if (!canBreak) continue;
            if (!displayBrokenParticles && !drop) {
                world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (displayBrokenParticles && !drop) {
                world.destroyBlock(it, false, (Entity)entity);
            }
            if (!drop || displayBrokenParticles) continue;
            BlockEntity blockEntity = world.getBlockEntity(it);
            Block.dropResources((BlockState)state, (Level)((Level)world), (BlockPos)it, (BlockEntity)blockEntity, (Entity)((Entity)entity), (ItemStack)ItemStack.EMPTY);
            world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static /* synthetic */ void createHollowSphereExplosion$default(ExplosionUtil explosionUtil, int n, ServerLevel serverLevel, Vec3 vec3, LivingEntity livingEntity, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        explosionUtil.createHollowSphereExplosion(n, serverLevel, vec3, livingEntity, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void createHollowSphereExplosionIgnoreWater(int currentRadius, @NotNull ServerLevel world, @NotNull Vec3 center, @NotNull LivingEntity entity, boolean drop, boolean displayBrokenParticles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Iterable $this$map$iv = MathUtil.INSTANCE.getSolidBall(currentRadius);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RelativeLocation relativeLocation = (RelativeLocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BlockPosExtendsKt.ofFloored((Vec3)it.plus(RelativeLocation.Companion.of(center)).toVector()));
        }
        Set hollowSphere = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = hollowSphere;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            if (!world.hasChunkAt(it)) continue;
            Vec3 vec3 = it.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            BlockFormation formation = ServerFormationManager.INSTANCE.getFormationFromPos(vec3, world);
            if (formation != null && formation.hasCrystalType(DefendCrystal.class) && formation.isActiveFormation()) {
                FormationTargetOption formationTargetOption = new LivingEntityTargetOption(entity, false);
                Vec3 vec32 = it.getCenter();
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
                formation.attack(0.5f, formationTargetOption, vec32);
                continue;
            }
            BlockState state = world.getBlockState(it);
            FluidState fluid = world.getFluidState(it);
            float resistance = Math.max(state.getBlock().getExplosionResistance(), fluid.getExplosionResistance());
            boolean canBreak = resistance >= 0.0f && resistance < 1000.0f && (fluid.isEmpty() || state.is(Blocks.WATER)) && !state.isAir();
            if (!canBreak) continue;
            if (!displayBrokenParticles && !drop) {
                world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (displayBrokenParticles && !drop) {
                world.destroyBlock(it, false, (Entity)entity);
            }
            if (!drop || displayBrokenParticles) continue;
            BlockEntity blockEntity = world.getBlockEntity(it);
            Block.dropResources((BlockState)state, (Level)((Level)world), (BlockPos)it, (BlockEntity)blockEntity, (Entity)((Entity)entity), (ItemStack)ItemStack.EMPTY);
            world.setBlock(it, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static /* synthetic */ void createHollowSphereExplosionIgnoreWater$default(ExplosionUtil explosionUtil, int n, ServerLevel serverLevel, Vec3 vec3, LivingEntity livingEntity, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        explosionUtil.createHollowSphereExplosionIgnoreWater(n, serverLevel, vec3, livingEntity, bl, bl2);
    }
}

