/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.utils;

import cn.coostack.usefulmagic.mixin.FallingBlockEntityAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ<\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u001e\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b0\u00120\u0011J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lcn/coostack/usefulmagic/utils/FallingBlockHelper;", "", "<init>", "()V", "conversionBlockToFallingBlocks", "", "Lnet/minecraft/world/entity/item/FallingBlockEntity;", "blockList", "Lnet/minecraft/core/BlockPos;", "breakOrigin", "", "world", "Lnet/minecraft/world/level/Level;", "getBoxIncludeBlockPosList", "box", "Lnet/minecraft/world/phys/AABB;", "filter", "Ljava/util/function/Predicate;", "Lkotlin/Triple;", "Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getBoxIncludeBlockPosListWithoutHardness", "hardMax", "", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFallingBlockHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FallingBlockHelper.kt\ncn/coostack/usefulmagic/utils/FallingBlockHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1869#2,2:80\n*S KotlinDebug\n*F\n+ 1 FallingBlockHelper.kt\ncn/coostack/usefulmagic/utils/FallingBlockHelper\n*L\n25#1:80,2\n*E\n"})
public final class FallingBlockHelper {
    @NotNull
    public static final FallingBlockHelper INSTANCE = new FallingBlockHelper();

    private FallingBlockHelper() {
    }

    @NotNull
    public final List<FallingBlockEntity> conversionBlockToFallingBlocks(@NotNull List<? extends BlockPos> blockList, boolean breakOrigin, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(blockList, (String)"blockList");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        List res = new ArrayList();
        Iterable $this$forEach$iv = blockList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FallingBlockEntityAccessor fallingBlockEntityAccessor;
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            if (!world.hasChunkAt(it)) continue;
            BlockState state = world.getBlockState(it);
            FallingBlockEntity entity = new FallingBlockEntity(EntityType.FALLING_BLOCK, world);
            entity.setPos(it.getCenter());
            entity.disableDrop();
            FallingBlockEntityAccessor $this$conversionBlockToFallingBlocks_u24lambda_u241_u24lambda_u240 = fallingBlockEntityAccessor = (FallingBlockEntityAccessor)entity;
            boolean bl2 = false;
            $this$conversionBlockToFallingBlocks_u24lambda_u241_u24lambda_u240.setBlockState(state);
            world.addFreshEntity((Entity)entity);
            res.add(entity);
            if (!breakOrigin) continue;
            world.destroyBlock(it, false);
        }
        return res;
    }

    @NotNull
    public final List<BlockPos> getBoxIncludeBlockPosList(@NotNull AABB box, @NotNull Level world, @NotNull Predicate<Triple<BlockState, VoxelShape, BlockPos>> filter) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        List res = new ArrayList();
        BlockPos.betweenClosedStream((AABB)box).forEach(arg_0 -> FallingBlockHelper.getBoxIncludeBlockPosList$lambda$3(arg_0 -> FallingBlockHelper.getBoxIncludeBlockPosList$lambda$2(world, filter, res, arg_0), arg_0));
        return res;
    }

    @NotNull
    public final List<BlockPos> getBoxIncludeBlockPosList(@NotNull AABB box, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.getBoxIncludeBlockPosList(box, world, FallingBlockHelper::getBoxIncludeBlockPosList$lambda$4);
    }

    @NotNull
    public final List<BlockPos> getBoxIncludeBlockPosListWithoutHardness(@NotNull AABB box, @NotNull Level world, float hardMax) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.getBoxIncludeBlockPosList(box, world, arg_0 -> FallingBlockHelper.getBoxIncludeBlockPosListWithoutHardness$lambda$5(world, hardMax, arg_0));
    }

    private static final Unit getBoxIncludeBlockPosList$lambda$2(Level $world, Predicate $filter, List $res, BlockPos pos) {
        VoxelShape shape;
        if (!$world.hasChunkAt(pos)) {
            return Unit.INSTANCE;
        }
        BlockState state = $world.getBlockState(pos);
        if ($filter.test(new Triple((Object)state, (Object)(shape = state.getCollisionShape((BlockGetter)$world, pos)), (Object)pos))) {
            BlockPos blockPos = pos.immutable();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"immutable(...)");
            $res.add(blockPos);
        }
        return Unit.INSTANCE;
    }

    private static final void getBoxIncludeBlockPosList$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean getBoxIncludeBlockPosList$lambda$4(Triple it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BlockState state = (BlockState)it.getFirst();
        VoxelShape shape = (VoxelShape)it.getSecond();
        return !shape.isEmpty() && !state.isAir() && state.getFluidState().isEmpty();
    }

    private static final boolean getBoxIncludeBlockPosListWithoutHardness$lambda$5(Level $world, float $hardMax, Triple it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BlockState state = (BlockState)it.getFirst();
        VoxelShape shape = (VoxelShape)it.getSecond();
        float hardness = state.getDestroySpeed((BlockGetter)$world, (BlockPos)it.getThird());
        return !shape.isEmpty() && !state.isAir() && state.getFluidState().isEmpty() && hardness < $hardMax && hardness > 0.0f;
    }
}

