/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.utils;

import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000bJL\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lcn/coostack/usefulmagic/utils/MathUtil;", "", "<init>", "()V", "getHollowSphere", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "r", "", "getSolidBall", "getPolygonInscribedCircle", "", "n", "discreteCylinderGenerator", "minDiscrete", "maxDiscrete", "maxRadius", "height", "heightStep", "radiusStep", "minCount", "maxCount", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MathUtil.kt\ncn/coostack/usefulmagic/utils/MathUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n2756#2:169\n1#3:170\n*S KotlinDebug\n*F\n+ 1 MathUtil.kt\ncn/coostack/usefulmagic/utils/MathUtil\n*L\n156#1:169\n156#1:170\n*E\n"})
public final class MathUtil {
    @NotNull
    public static final MathUtil INSTANCE = new MathUtil();

    private MathUtil() {
    }

    @NotNull
    public final List<RelativeLocation> getHollowSphere(int r) {
        if (r < 0) {
            return CollectionsKt.emptyList();
        }
        if (r == 0) {
            return CollectionsKt.listOf((Object)new RelativeLocation(0, 0, 0));
        }
        ArrayList<RelativeLocation> points = new ArrayList<RelativeLocation>();
        int rSquared = r * r;
        int x = -r;
        if (x <= r) {
            while (true) {
                int y;
                if ((y = -r) <= r) {
                    while (true) {
                        int xySq;
                        if ((xySq = x * x + y * y) <= rSquared) {
                            int zSq = rSquared - xySq;
                            if (zSq == 0) {
                                points.add(new RelativeLocation(x, y, 0));
                            } else {
                                int zVal = (int)Math.sqrt(zSq);
                                if (zVal * zVal == zSq) {
                                    points.add(new RelativeLocation(x, y, zVal));
                                    points.add(new RelativeLocation(x, y, -zVal));
                                }
                            }
                        }
                        if (y == r) break;
                        ++y;
                    }
                }
                if (x == r) break;
                ++x;
            }
        }
        return points;
    }

    @NotNull
    public final List<RelativeLocation> getSolidBall(int r) {
        int rSq = r * r;
        ArrayList points = new ArrayList(4 * r * r * r / 3);
        int x = 0;
        if (x <= r) {
            int xSq;
            while ((xSq = x * x) <= rSq) {
                int y = 0;
                int yMax = (int)Math.sqrt(rSq - xSq);
                if (y <= yMax) {
                    while (true) {
                        int ySq;
                        int zMax;
                        int z;
                        if ((z = 0) <= (zMax = (int)Math.sqrt(rSq - xSq - (ySq = y * y)))) {
                            while (true) {
                                if (xSq + y * y + z * z <= rSq) {
                                    boolean hasX = x > 0;
                                    boolean hasY = y > 0;
                                    boolean hasZ = z > 0;
                                    if (hasX && hasY && hasZ) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, z));
                                        ((Collection)points).add(new RelativeLocation(x, y, -z));
                                        ((Collection)points).add(new RelativeLocation(-x, -y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, -z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, -z));
                                        ((Collection)points).add(new RelativeLocation(-x, -y, -z));
                                    } else if (hasX && hasY) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, -y, z));
                                    } else if (hasX && hasZ) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, y, -z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, -z));
                                    } else if (hasY && hasZ) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, z));
                                        ((Collection)points).add(new RelativeLocation(x, y, -z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, -z));
                                    } else if (hasX) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(-x, y, z));
                                    } else if (hasY) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, -y, z));
                                    } else if (hasZ) {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                        ((Collection)points).add(new RelativeLocation(x, y, -z));
                                    } else {
                                        ((Collection)points).add(new RelativeLocation(x, y, z));
                                    }
                                }
                                if (z == zMax) break;
                                ++z;
                            }
                        }
                        if (y == yMax) break;
                        ++y;
                    }
                }
                if (x == r) break;
                ++x;
            }
        }
        return points;
    }

    public final double getPolygonInscribedCircle(int n, double r) {
        if (n < 3) {
            return 0.0;
        }
        return r * Math.sin(Math.PI / (double)(2 * n));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RelativeLocation> discreteCylinderGenerator(double minDiscrete, double maxDiscrete, double maxRadius, double height, double heightStep, double radiusStep, int minCount, int maxCount) {
        ArrayList res = new ArrayList();
        double discreteStep = (maxDiscrete - minDiscrete) / (maxRadius / radiusStep);
        int countStep = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)((double)(maxCount - minCount) / (maxRadius / radiusStep))), (int)1);
        for (double currentHeight = 0.0; currentHeight <= height; currentHeight += heightStep) {
            double currentDiscrete = discreteStep;
            int currentCount = minCount;
            for (double currentRadius = radiusStep; currentRadius <= maxRadius; currentRadius += radiusStep) {
                void $this$onEach$iv;
                void var26_18;
                Iterable iterable = Math3DUtil.INSTANCE.getDiscreteCircleXZ(currentRadius, currentCount, currentDiscrete);
                ArrayList arrayList = res;
                boolean $i$f$onEach = false;
                void $this$onEach_u24lambda_u2418$iv = var26_18 = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                    RelativeLocation it = (RelativeLocation)element$iv;
                    boolean bl2 = false;
                    it.setY(it.getY() + currentHeight);
                }
                arrayList.addAll((Collection)var26_18);
                currentCount += countStep;
                currentDiscrete += discreteStep;
            }
        }
        return res;
    }
}

