/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.lukar.init;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcreator.lukar.LukarMod;
import net.mcreator.lukar.init.LukarModScreens;
import net.mcreator.lukar.world.inventory.ASGUIMenu;
import net.mcreator.lukar.world.inventory.CoreGUIMenu;
import net.mcreator.lukar.world.inventory.LaGuidebookguiMenu;
import net.mcreator.lukar.world.inventory.RadarMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LukarModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"lukar");
    public static final RegistryObject<MenuType<CoreGUIMenu>> CORE_GUI = REGISTRY.register("core_gui", () -> IForgeMenuType.create(CoreGUIMenu::new));
    public static final RegistryObject<MenuType<ASGUIMenu>> ASGUI = REGISTRY.register("asgui", () -> IForgeMenuType.create(ASGUIMenu::new));
    public static final RegistryObject<MenuType<RadarMenu>> RADAR = REGISTRY.register("radar", () -> IForgeMenuType.create(RadarMenu::new));
    public static final RegistryObject<MenuType<LaGuidebookguiMenu>> LA_GUIDEBOOKGUI = REGISTRY.register("la_guidebookgui", () -> IForgeMenuType.create(LaGuidebookguiMenu::new));

    public static void setText(String boxname, String value, @Nullable ServerPlayer player) {
        if (player != null) {
            LukarMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GuiSyncMessage(boxname, value));
        } else {
            LukarMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new GuiSyncMessage(boxname, value));
        }
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LukarMod.addNetworkMessage(GuiSyncMessage.class, GuiSyncMessage::buffer, GuiSyncMessage::new, GuiSyncMessage::handleData);
    }

    public static class GuiSyncMessage {
        private final String textboxid;
        private final String data;

        public GuiSyncMessage(FriendlyByteBuf buffer) {
            this.textboxid = buffer.m_130238_().getString();
            this.data = buffer.m_130238_().getString();
        }

        public GuiSyncMessage(String textboxid, String data) {
            this.textboxid = textboxid;
            this.data = data;
        }

        public static void buffer(GuiSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130083_((Component)Component.m_237113_((String)message.textboxid));
            buffer.m_130083_((Component)Component.m_237113_((String)message.data));
        }

        public static void handleData(GuiSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    LukarModScreens.handleTextBoxMessage(message);
                }
            });
            context.setPacketHandled(true);
        }

        String editbox() {
            return this.textboxid;
        }

        String value() {
            return this.data;
        }
    }
}

