/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltsl.client.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class RemoteAdConfig {
    private static final String CONFIG_URL = "https://raw.githubusercontent.com/LordTricker/LT-SlotLock/refs/heads/ad/config.json";
    private static final String DEFAULT_NAME = "LT-SlotLock";
    private static final String DEFAULT_ADDRESS = "pvpstar.pl";
    private static volatile String cachedName = "LT-SlotLock";
    private static volatile String cachedAddress = "pvpstar.pl";
    private static volatile boolean fetched = false;
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final Gson GSON = new Gson();

    private RemoteAdConfig() {
    }

    public static void preloadAsync() {
        if (!started.compareAndSet(false, true)) {
            return;
        }
        Thread t = new Thread(RemoteAdConfig::fetchOnce, "ltsl-remote-ad-fetch");
        t.setDaemon(true);
        t.start();
    }

    public static String serverName() {
        if (!fetched) {
            return DEFAULT_NAME;
        }
        return cachedName != null && !cachedName.isBlank() ? cachedName : DEFAULT_NAME;
    }

    public static String serverAddress() {
        if (!fetched) {
            return null;
        }
        return cachedAddress != null && !cachedAddress.isBlank() ? cachedAddress : null;
    }

    private static void fetchOnce() {
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(2L)).build();
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(CONFIG_URL)).header("Accept", "application/json").header("User-Agent", "LT-SlotLock/1 JavaHttpClient").timeout(Duration.ofSeconds(4L)).GET().build();
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() >= 200 && resp.statusCode() < 300) {
                String body = resp.body();
                JsonObject obj = (JsonObject)GSON.fromJson(body, JsonObject.class);
                if (obj != null) {
                    boolean addrIsNull;
                    boolean hasName = obj.has("serverName");
                    boolean nameIsNull = hasName && obj.get("serverName").isJsonNull();
                    boolean hasAddr = obj.has("serverAddress");
                    boolean bl = addrIsNull = hasAddr && obj.get("serverAddress").isJsonNull();
                    if (hasName) {
                        if (nameIsNull) {
                            cachedName = null;
                        } else {
                            String name = obj.get("serverName").getAsString();
                            if (name != null && !name.isBlank()) {
                                cachedName = name;
                            }
                        }
                    }
                    if (hasAddr) {
                        if (addrIsNull) {
                            cachedAddress = null;
                        } else {
                            String addr = obj.get("serverAddress").getAsString();
                            if (addr != null && !addr.isBlank()) {
                                cachedAddress = RemoteAdConfig.normalizeAddress(addr);
                            }
                        }
                    }
                    fetched = true;
                    System.out.println("[LT-SlotLock] Remote config loaded: name='" + cachedName + "', address='" + cachedAddress + "'");
                }
            } else {
                System.out.println("[LT-SlotLock] Remote config HTTP status: " + resp.statusCode());
            }
        }
        catch (Throwable t) {
            System.out.println("[LT-SlotLock] Remote config fetch failed: " + t.getMessage());
        }
    }

    private static String normalizeAddress(String address) {
        if (address == null) {
            return null;
        }
        String a = address.trim().toLowerCase(Locale.ROOT);
        if (a.endsWith(":25565")) {
            a = a.substring(0, a.length() - 6);
        }
        return a;
    }
}

