/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltsl.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import pl.lordtricker.ltsl.client.config.SettingsConfig;
import pl.lordtricker.ltsl.client.config.SlotSettings;

@Environment(value=EnvType.CLIENT)
public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String MAIN_CONFIG_FILE_NAME = "ltslotlock-config.json";
    private static final Path MOD_CONFIG_DIR;

    public static SettingsConfig loadConfig() {
        SettingsConfig settingsConfig;
        block9: {
            Path configFile = MOD_CONFIG_DIR.resolve(MAIN_CONFIG_FILE_NAME);
            if (!Files.exists(configFile, new LinkOption[0])) {
                SettingsConfig defaultConfig = ConfigLoader.createDefaultConfig();
                ConfigLoader.saveConfig(defaultConfig);
                return defaultConfig;
            }
            BufferedReader reader = Files.newBufferedReader(configFile);
            try {
                SettingsConfig loadedConfig;
                settingsConfig = loadedConfig = (SettingsConfig)GSON.fromJson((Reader)reader, SettingsConfig.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new SettingsConfig();
                }
            }
            ((Reader)reader).close();
        }
        return settingsConfig;
    }

    public static void saveConfig(SettingsConfig config) {
        Path configFile = MOD_CONFIG_DIR.resolve(MAIN_CONFIG_FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static SettingsConfig createDefaultConfig() {
        SettingsConfig cfg = new SettingsConfig();
        cfg.slotSettings.doNotCleanSlots = List.of();
        cfg.adsEnabled = SlotSettings.adsEnabled;
        cfg.slotSettings.activeSlotHex = "#80ccff";
        cfg.slotSettings.blockedSlotHex = "#80cc00";
        cfg.slotLockEnabled = true;
        cfg.itemFrameLockEnabled = true;
        return cfg;
    }

    static {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        MOD_CONFIG_DIR = configDir.resolve("LT-Mods").resolve("LT-SlotLock");
        try {
            if (!Files.exists(MOD_CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(MOD_CONFIG_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

