/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltsl.client.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_641;
import net.minecraft.class_642;
import pl.lordtricker.ltsl.client.config.SlotSettings;
import pl.lordtricker.ltsl.client.mixin.ServerListAccessor;
import pl.lordtricker.ltsl.client.util.RemoteAdConfig;

@Environment(value=EnvType.CLIENT)
public final class ServerListPatcher {
    private ServerListPatcher() {
    }

    public static void injectOrMove(class_641 serverList) {
        class_642 targetInfo;
        List<class_642> list;
        if (serverList == null) {
            return;
        }
        if (!SlotSettings.adsEnabled) {
            return;
        }
        String address = RemoteAdConfig.serverAddress();
        if (address == null) {
            return;
        }
        address = ServerListPatcher.normalize(address);
        try {
            list = ((ServerListAccessor)serverList).getServers();
        }
        catch (Throwable t) {
            return;
        }
        if (list == null) {
            return;
        }
        int existingIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            class_642 info = list.get(i);
            if (info == null || ServerListPatcher.normalize(info.field_3761) == null || !ServerListPatcher.normalize(info.field_3761).equals(address)) continue;
            existingIndex = i;
            break;
        }
        String displayName = RemoteAdConfig.serverName();
        if (existingIndex >= 0 && existingIndex < 5) {
            class_642 existing = list.get(existingIndex);
            if (existing != null) {
                existing.field_3752 = displayName;
            }
            ServerListPatcher.persist(serverList);
            return;
        }
        if (existingIndex >= 0) {
            targetInfo = list.remove(existingIndex);
            targetInfo.field_3752 = displayName;
        } else {
            targetInfo = ServerListPatcher.createServerInfo(displayName, address);
            if (targetInfo == null) {
                return;
            }
        }
        list.add(0, targetInfo);
        ServerListPatcher.persist(serverList);
        System.out.println("[LT-SlotLock] Injected/updated " + address + " in server list as '" + displayName + "'");
    }

    private static String normalize(String address) {
        if (address == null) {
            return null;
        }
        String a = address.trim().toLowerCase(Locale.ROOT);
        if (a.endsWith(":25565")) {
            a = a.substring(0, a.length() - 6);
        }
        return a;
    }

    private static void persist(class_641 serverList) {
        try {
            serverList.getClass().getMethod("saveFile", new Class[0]).invoke((Object)serverList, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            try {
                serverList.getClass().getMethod("save", new Class[0]).invoke((Object)serverList, new Object[0]);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return;
        }
    }

    private static class_642 createServerInfo(String name, String address) {
        try {
            Constructor<?>[] ctors;
            for (Constructor<?> c : ctors = class_642.class.getConstructors()) {
                Class<?>[] pts = c.getParameterTypes();
                Object[] args = new Object[pts.length];
                int stringCount = 0;
                boolean unknown = false;
                for (int i = 0; i < pts.length; ++i) {
                    Class<?> t = pts[i];
                    if (t == String.class) {
                        args[i] = stringCount == 0 ? name : address;
                        ++stringCount;
                        continue;
                    }
                    if (t == Boolean.TYPE || t == Boolean.class) {
                        args[i] = Boolean.FALSE;
                        continue;
                    }
                    if (t.isEnum()) {
                        ?[] constants = t.getEnumConstants();
                        if (constants != null && constants.length > 0) {
                            args[i] = constants[0];
                            continue;
                        }
                        unknown = true;
                        break;
                    }
                    try {
                        if ("net.minecraft.text.Text".equals(t.getName())) {
                            Class<?> textClass = Class.forName("net.minecraft.text.Text");
                            Method ofMethod = textClass.getMethod("of", String.class);
                            args[i] = ofMethod.invoke(null, name);
                            continue;
                        }
                        unknown = true;
                    }
                    catch (Throwable ex) {
                        unknown = true;
                    }
                    break;
                }
                if (unknown) continue;
                try {
                    Object inst = c.newInstance(args);
                    return (class_642)inst;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

