/*
 * Decompiled with CFR 0.152.
 */
package org.powell.guiApi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public final class GuiApi
extends JavaPlugin {
    public void onEnable() {
        System.out.println("GUI API enabled");
    }

    public Inventory createGui(InventoryHolder inventoryHolder, Integer size, String title) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)inventoryHolder, (int)size, (String)title);
        return inventory;
    }

    public void setItem(Inventory inventory, ItemStack item, int slot) {
        inventory.setItem(slot, item);
    }

    public void setItemName(ItemStack item, ChatColor color, String name) {
        ItemMeta meta = item.getItemMeta();
        if (color != null) {
            meta.setDisplayName(String.valueOf(color) + name);
        } else {
            meta.setDisplayName(String.valueOf(ChatColor.WHITE) + name);
        }
        item.setItemMeta(meta);
    }

    public void setItemLore(ItemStack item, ChatColor color, String lore) {
        ItemMeta meta = item.getItemMeta();
        if (color != null) {
            meta.setLore(Arrays.asList(String.valueOf(color) + lore));
        } else {
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + lore));
        }
        item.setItemMeta(meta);
    }

    public void setFrames(Inventory inventory, int frame_number) {
        ItemStack frame = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fmeta = frame.getItemMeta();
        fmeta.setDisplayName(String.valueOf(ChatColor.GRAY) + " ");
        fmeta.setLore(Arrays.asList(""));
        frame.setItemMeta(fmeta);
        inventory.setItem(frame_number, frame);
    }

    public ItemStack getHead(String texture) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        PlayerProfile profile = Bukkit.getServer().createPlayerProfile(UUID.randomUUID());
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL("http://textures.minecraft.net/texture/" + texture));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        profile.setTextures(textures);
        meta.setOwnerProfile(profile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

