/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.GUI;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.powell.rankify.main.Enums.Rank;
import org.powell.rankify.main.Main;

public class GUI
implements InventoryHolder {
    private final Main main;
    private final Player player;
    private final int page;
    private final Map<Integer, Consumer<InventoryClickEvent>> clickHandlers = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    private Inventory inventory;

    public GUI(Main main, Player player, int page) {
        this.main = main;
        this.player = player;
        this.page = page;
        this.openRankMenu();
    }

    private String formatGroupsFor(UUID uuid) {
        Rank r;
        List<String> groups;
        Object disp;
        HashMap<String, Object> displayByArg = new HashMap<String, Object>();
        List cfgRanks = this.main.getConfig().getMapList("ranks");
        if (cfgRanks != null) {
            for (Map m : cfgRanks) {
                Object a = m.get("arg");
                Object n = m.get("name");
                if (!(a instanceof String) || !(n instanceof String)) continue;
                String arg = ((String)a).toLowerCase(Locale.ROOT);
                disp = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)n)) + String.valueOf(ChatColor.RESET);
                displayByArg.put(arg, disp);
            }
        }
        if ((groups = this.main.getRankManager().getGroups(uuid)) != null && !groups.isEmpty()) {
            ArrayList<Object> parts = new ArrayList<Object>();
            for (String g : groups) {
                if (g == null || g.isEmpty()) continue;
                String key = g.toLowerCase(Locale.ROOT);
                disp = displayByArg.getOrDefault(key, g);
                parts.add(disp);
            }
            if (!parts.isEmpty()) {
                return String.join((CharSequence)(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.RESET)), parts);
            }
        }
        return (r = this.main.getRankManager().getRank(uuid)) != null ? r.getDisplay() : String.valueOf(ChatColor.GRAY) + "None" + String.valueOf(ChatColor.RESET);
    }

    private void openRankMenu() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(String.valueOf(ChatColor.DARK_AQUA) + "Rankify Menu"));
        this.clickHandlers.clear();
        this.addFrameItems();
        this.addPlayerHeads();
        this.addNavigationItems();
        this.player.openInventory(this.inventory);
    }

    private void addFrameItems() {
        int[] frameSlots;
        ItemStack frame = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = frame.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            frame.setItemMeta(meta);
        }
        for (int slot : frameSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 50, 51, 52, 53}) {
            this.inventory.setItem(slot, frame);
        }
    }

    private void addPlayerHeads() {
        int slot = 10;
        for (Player onlinePlayer : this.player.getServer().getOnlinePlayers()) {
            if (slot > 43) break;
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer((OfflinePlayer)onlinePlayer);
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + onlinePlayer.getName());
                String ranksDisplay = this.formatGroupsFor(onlinePlayer.getUniqueId());
                meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Ranks: " + ranksDisplay, String.valueOf(ChatColor.YELLOW) + "Click to manage rank"));
                playerHead.setItemMeta((ItemMeta)meta);
            }
            int finalSlot = slot++;
            this.inventory.setItem(finalSlot, playerHead);
            this.clickHandlers.put(finalSlot, event -> {
                event.setCancelled(true);
                this.player.sendMessage(String.valueOf(ChatColor.GOLD) + "Managing rank for " + onlinePlayer.getName());
                this.openRankSelectionMenu(onlinePlayer);
            });
            if ((slot + 1) % 9 != 0) continue;
            slot += 2;
        }
    }

    private void openRankSelectionMenu(Player targetPlayer) {
        ItemStack backButton;
        ItemMeta backMeta;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(String.valueOf(ChatColor.DARK_AQUA) + "Manage ranks for " + targetPlayer.getName()));
        this.clickHandlers.clear();
        List cfgRanks = this.main.getConfig().getMapList("ranks");
        int slot = 10;
        List<String> targetGroups = this.main.getRankManager().getGroups(targetPlayer.getUniqueId());
        if (cfgRanks != null) {
            for (Map m : cfgRanks) {
                ItemStack item;
                ItemMeta meta;
                if (slot > 16) break;
                Object a = m.get("arg");
                Object n = m.get("name");
                if (!(a instanceof String) || ((String)a).length() <= 0) continue;
                String arg = (String)a;
                String argLower = arg.toLowerCase(Locale.ROOT);
                String display = n instanceof String ? ChatColor.translateAlternateColorCodes((char)'&', (String)((String)n)) + String.valueOf(ChatColor.RESET) : arg;
                boolean hasGroup = false;
                for (String g : targetGroups) {
                    if (g == null || !g.equalsIgnoreCase(argLower)) continue;
                    hasGroup = true;
                    break;
                }
                if ((meta = (item = new ItemStack(hasGroup ? Material.LIME_CONCRETE : Material.PAPER)).getItemMeta()) != null) {
                    meta.setDisplayName(display);
                    ArrayList<Object> lore = new ArrayList<Object>();
                    lore.add(String.valueOf(ChatColor.GRAY) + (hasGroup ? "Click to remove from " : "Click to add to ") + targetPlayer.getName());
                    lore.add(String.valueOf(ChatColor.GRAY) + "Group id: " + String.valueOf(ChatColor.YELLOW) + argLower);
                    lore.add("");
                    lore.add(String.valueOf(ChatColor.YELLOW) + "Has group: " + (hasGroup ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                }
                int finalSlot = slot++;
                this.inventory.setItem(finalSlot, item);
                this.clickHandlers.put(finalSlot, event -> {
                    block10: {
                        event.setCancelled(true);
                        if (argLower.equals("owner") || argLower.equals("coowner")) {
                            Rank callerRank = this.main.getRankManager().getRank(this.player.getUniqueId());
                            if (callerRank != Rank.OWNER && callerRank != Rank.COOWNER) {
                                this.player.sendMessage(String.valueOf(ChatColor.RED) + "Only the Owner or CoOwner can modify Owner/CoOwner groups.");
                                this.player.closeInventory();
                                return;
                            }
                        } else if (!this.player.hasPermission("rankify.setrank")) {
                            this.player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to modify ranks.");
                            this.player.closeInventory();
                            return;
                        }
                        boolean currentlyHas = this.main.getRankManager().hasGroup(targetPlayer.getUniqueId(), argLower);
                        try {
                            if (currentlyHas) {
                                this.main.getRankManager().removeGroup(targetPlayer.getUniqueId(), argLower);
                                this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + display + String.valueOf(ChatColor.GREEN) + " from " + targetPlayer.getName() + ".");
                                if (targetPlayer.isOnline()) {
                                    targetPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You have lost the " + display + String.valueOf(ChatColor.RED) + " group by " + this.player.getDisplayName() + String.valueOf(ChatColor.RED) + ".");
                                }
                            } else {
                                this.main.getRankManager().addGroup(targetPlayer.getUniqueId(), argLower);
                                this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + display + String.valueOf(ChatColor.GREEN) + " to " + targetPlayer.getName() + ".");
                                if (targetPlayer.isOnline()) {
                                    targetPlayer.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been given the " + display + String.valueOf(ChatColor.GREEN) + " group by " + this.player.getDisplayName() + String.valueOf(ChatColor.GREEN) + ".");
                                }
                            }
                            this.openRankSelectionMenu(targetPlayer);
                        }
                        catch (Exception e) {
                            this.player.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while updating groups: " + e.getMessage());
                            if (!this.main.getConfig().getBoolean("debug", false)) break block10;
                            e.printStackTrace();
                        }
                    }
                });
                if (slot != 17) continue;
                slot = 19;
            }
        }
        if ((backMeta = (backButton = new ItemStack(Material.ARROW)).getItemMeta()) != null) {
            backMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Go Back");
            backButton.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, backButton);
        this.clickHandlers.put(22, event -> {
            event.setCancelled(true);
            this.openRankMenu();
        });
        this.player.openInventory(this.inventory);
    }

    private void addNavigationItems() {
        ItemStack closeButton = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeButton.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close");
            closeMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Click to close"));
            closeButton.setItemMeta(closeMeta);
        }
        this.inventory.setItem(49, closeButton);
        this.clickHandlers.put(49, event -> this.player.closeInventory());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void handleClick(InventoryClickEvent event) {
        int slot = event.getSlot();
        if (this.clickHandlers.containsKey(slot)) {
            this.clickHandlers.get(slot).accept(event);
        }
    }
}

