/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Listeners;

import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.powell.rankify.main.Enums.Rank;
import org.powell.rankify.main.Main;
import org.powell.rankify.main.Managers.RankManager;

public class RankListener
implements Listener {
    private final Main main;
    private final RankManager rankManager;

    public RankListener(Main main) {
        this.main = main;
        this.rankManager = main.getRankManager();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent e) {
        block5: {
            Player player = e.getPlayer();
            UUID playerId = player.getUniqueId();
            try {
                if (!player.hasPlayedBefore()) {
                    this.rankManager.setRank(playerId, Rank.GUEST, true);
                } else if (this.rankManager.getRank(playerId) == null) {
                    this.main.getLogger().warning("Player " + player.getName() + " had no rank, setting to GUEST");
                    this.rankManager.setRank(playerId, Rank.GUEST, false);
                }
                this.updatePlayerRank(player);
            }
            catch (Exception ex) {
                this.main.getLogger().severe("Error handling player join for " + player.getName() + ": " + ex.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block5;
                ex.printStackTrace();
            }
        }
    }

    private void updatePlayerRank(Player player) {
        block7: {
            UUID playerId = player.getUniqueId();
            try {
                PermissionAttachment attachment;
                if (this.main.getNametagManager() != null) {
                    this.main.getNametagManager().setNametags(player);
                    this.main.getNametagManager().newTag(player);
                }
                if ((attachment = this.rankManager.getPerm().get(playerId)) == null) {
                    attachment = player.addAttachment((Plugin)this.main);
                    this.rankManager.getPerm().put(playerId, attachment);
                }
                for (String perm : attachment.getPermissions().keySet()) {
                    attachment.unsetPermission(perm);
                }
                Rank rank = this.rankManager.getRank(playerId);
                if (rank != null) {
                    for (String perm : rank.getPerms()) {
                        if (perm == null || perm.trim().isEmpty()) continue;
                        attachment.setPermission(perm, true);
                    }
                }
                player.recalculatePermissions();
            }
            catch (Exception e) {
                this.main.getLogger().warning("Failed to update rank for " + player.getName() + ": " + e.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block7;
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        try {
            Player player = e.getPlayer();
            if (this.main.getNametagManager() != null) {
                this.main.getNametagManager().removeTag(player);
            }
            this.rankManager.getPerm().remove(player.getUniqueId());
        }
        catch (Exception ex) {
            this.main.getLogger().warning("Error handling player quit: " + ex.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        try {
            Rank rank = this.rankManager.getRank(player.getUniqueId());
            if (rank == null) {
                rank = Rank.GUEST;
                this.main.getLogger().warning(player.getName() + " had no rank, defaulting to GUEST for chat");
            }
            String format = String.format("%s %s: %s%s", rank.getDisplay(), player.getName(), ChatColor.GRAY, e.getMessage());
            e.setFormat(format);
        }
        catch (Exception ex) {
            e.setFormat("%s: %s");
            this.main.getLogger().warning("Error formatting chat for " + player.getName() + ": " + ex.getMessage());
        }
    }
}

