/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Managers;

import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import org.powell.rankify.main.Enums.Rank;
import org.powell.rankify.main.Main;

public final class PermissionsBridge {
    private final Main main;

    public PermissionsBridge(Main main) {
        this.main = main;
    }

    public boolean isLuckPermsPresent() {
        return Bukkit.getPluginManager().getPlugin("LuckPerms") != null;
    }

    public boolean isPermissionsExPresent() {
        return Bukkit.getPluginManager().getPlugin("PermissionsEx") != null || Bukkit.getPluginManager().getPlugin("Permissions") != null;
    }

    @NotNull
    public String toGroup(Rank rank) {
        if (rank == null) {
            return "guest";
        }
        return rank.name().toLowerCase(Locale.ROOT);
    }

    public void setGroup(UUID uuid, Rank rank) {
        if (uuid == null || rank == null) {
            return;
        }
        String group = this.toGroup(rank);
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (this.isLuckPermsPresent()) {
            String cmd = String.format("lp user %s parent set %s", uuid, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("LuckPerms", uuid, group);
            return;
        }
        if (this.isPermissionsExPresent()) {
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = off != null && off.getName() != null ? off.getName() : uuid.toString();
            String cmd = String.format("pex user %s group set %s", name, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("PermissionsEx", uuid, group);
            return;
        }
        this.main.getLogger().warning("No supported permissions plugin detected (LuckPerms/PermissionsEx). Skipping group apply for " + String.valueOf(uuid));
    }

    public void setGroup(UUID uuid, String group) {
        if (uuid == null || group == null || group.isEmpty()) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (this.isLuckPermsPresent()) {
            String cmd = String.format("lp user %s parent set %s", uuid, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("LuckPerms", uuid, group);
            return;
        }
        if (this.isPermissionsExPresent()) {
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = off != null && off.getName() != null ? off.getName() : uuid.toString();
            String cmd = String.format("pex user %s group set %s", name, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("PermissionsEx", uuid, group);
            return;
        }
        this.main.getLogger().warning("No supported permissions plugin detected (LuckPerms/PermissionsEx). Skipping group apply for " + String.valueOf(uuid));
    }

    public void addGroup(UUID uuid, String group) {
        if (uuid == null || group == null || group.isEmpty()) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (this.isLuckPermsPresent()) {
            String cmd = String.format("lp user %s parent add %s", uuid, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("LuckPerms:add", uuid, group);
            return;
        }
        if (this.isPermissionsExPresent()) {
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = off != null && off.getName() != null ? off.getName() : uuid.toString();
            String cmd = String.format("pex user %s group add %s", name, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("PermissionsEx:add", uuid, group);
            return;
        }
        this.main.getLogger().warning("No supported permissions plugin detected (LuckPerms/PermissionsEx). Skipping group add for " + String.valueOf(uuid));
    }

    public void removeGroup(UUID uuid, String group) {
        if (uuid == null || group == null || group.isEmpty()) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        if (this.isLuckPermsPresent()) {
            String cmd = String.format("lp user %s parent remove %s", uuid, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("LuckPerms:remove", uuid, group);
            return;
        }
        if (this.isPermissionsExPresent()) {
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = off != null && off.getName() != null ? off.getName() : uuid.toString();
            String cmd = String.format("pex user %s group remove %s", name, group);
            Bukkit.dispatchCommand((CommandSender)console, (String)cmd);
            this.logApplied("PermissionsEx:remove", uuid, group);
            return;
        }
        this.main.getLogger().warning("No supported permissions plugin detected (LuckPerms/PermissionsEx). Skipping group remove for " + String.valueOf(uuid));
    }

    private void logApplied(String platform, UUID uuid, String group) {
        if (this.main.getConfig().getBoolean("debug", false)) {
            this.main.getLogger().info("[PermissionsBridge] Applied group '" + group + "' to " + String.valueOf(uuid) + " via " + platform);
        }
    }
}

