/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;

public enum Rank {
    OWNER(String.valueOf(ChatColor.DARK_RED) + "Owner", new String[]{"rankify.setrank", "rankify.reload"}),
    COOWNER(String.valueOf(ChatColor.DARK_GREEN) + "CoOwner", new String[]{"rankify.setrank", "rankify.reload"}),
    YOUTUBE(String.valueOf(ChatColor.GOLD) + "YouTube", new String[0]),
    ADMIN(String.valueOf(ChatColor.DARK_PURPLE) + "Admin", new String[]{"rankify.setrank", "rankify.reload"}),
    MODERATOR(String.valueOf(ChatColor.GREEN) + "Moderator", new String[]{"rankify.setrank", "rankify.reload"}),
    HELPER(String.valueOf(ChatColor.GOLD) + "Helper", new String[0]),
    DONOR(String.valueOf(ChatColor.AQUA) + "Donor", new String[0]),
    DISCORD(String.valueOf(ChatColor.BLUE) + "Discord", new String[0]),
    STRONGEST(String.valueOf(ChatColor.YELLOW) + "Strongest", new String[0]),
    EGIRL(String.valueOf(ChatColor.LIGHT_PURPLE) + "Egirl", new String[0]),
    SUS(String.valueOf(ChatColor.DARK_GREEN) + "Sus", new String[0]),
    MEMBER(String.valueOf(ChatColor.AQUA) + "Member", new String[0]),
    GUEST(String.valueOf(ChatColor.GRAY) + "Guest", new String[0]);

    private static final Map<String, Rank> BY_NAME;
    private final String display;
    private final String[] perms;

    private Rank(String display, String[] perms) {
        this.display = display;
        this.perms = perms != null ? perms : new String[]{};
    }

    public String getDisplay() {
        return this.display;
    }

    public String[] getPerms() {
        return (String[])this.perms.clone();
    }

    @Nullable
    public static Rank fromString(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return BY_NAME.get(name.toUpperCase().replace("-", "_").replace(" ", "_"));
    }

    public static String getAvailableRanks() {
        return String.join((CharSequence)", ", (CharSequence[])Arrays.stream(Rank.values()).map(Enum::name).map(String::toLowerCase).toArray(String[]::new));
    }

    static {
        BY_NAME = new HashMap<String, Rank>();
        for (Rank rank : Rank.values()) {
            BY_NAME.put(rank.name(), rank);
            BY_NAME.put(rank.name().toLowerCase(), rank);
            BY_NAME.put(rank.name().replace("_", ""), rank);
            BY_NAME.put(rank.name().replace("_", "").toLowerCase(), rank);
        }
    }
}

