/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.powell.rankify.main.GUI.GUI;
import org.powell.rankify.main.Main;
import org.powell.rankify.main.Managers.RankManager;

public class RankCommand
implements CommandExecutor,
TabCompleter {
    private final Main main;
    private final RankManager rankManager;

    public RankCommand(Main main, RankManager rankManager) {
        this.main = main;
        this.rankManager = rankManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args2) {
        String sub;
        String string = sub = args2.length > 0 ? args2[0].toLowerCase() : "";
        if (sub.equals("reload")) {
            Player p;
            if (sender instanceof Player && !(p = (Player)sender).hasPermission("rankify.reload")) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to reload Rankify.");
                return true;
            }
            this.main.reloadConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Rankify configuration reloaded.");
            return true;
        }
        if (sub.equals("gui")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
                return true;
            }
            Player p = (Player)sender;
            if (!p.hasPermission("rankify.gui")) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use the GUI.");
                return true;
            }
            new GUI(this.main, p, 1);
            return true;
        }
        if (sub.equals("add")) {
            String desiredGroup;
            UUID targetUuid;
            if (args2.length < 3) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rankify add <player> <rank>");
                return true;
            }
            String targetName = args2[1];
            String rankName = args2[2];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (!target.hasPlayedBefore() && !target.isOnline()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + targetName + " has never joined the server.");
                return true;
            }
            if (!this.isValidArg(rankName)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid rank. Available ranks: " + this.getAvailableRanksFromConfig());
                return true;
            }
            if (sender instanceof Player) {
                Player p = (Player)sender;
                String desiredLower = rankName.toLowerCase();
                if (desiredLower.equals("owner") || desiredLower.equals("coowner")) {
                    if (!p.isOp()) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "Only operators can set the Owner or CoOwner ranks.");
                        return true;
                    }
                } else if (!p.isOp() && !p.hasPermission("rankify.setrank")) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to set ranks.");
                    return true;
                }
            }
            if (this.rankManager.hasGroup(targetUuid = target.getUniqueId(), desiredGroup = rankName.toLowerCase())) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + targetName + " already has the " + this.getDisplayNameFromConfig(desiredGroup) + String.valueOf(ChatColor.YELLOW) + " rank.");
                return true;
            }
            this.rankManager.addGroup(targetUuid, desiredGroup);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Added " + this.getDisplayNameFromConfig(desiredGroup) + String.valueOf(ChatColor.GREEN) + " to " + targetName + ".");
            Player onlineTarget = target.getPlayer();
            if (onlineTarget != null) {
                onlineTarget.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been given the " + this.getDisplayNameFromConfig(desiredGroup) + String.valueOf(ChatColor.GREEN) + " rank by " + sender.getName() + String.valueOf(ChatColor.GREEN) + ".");
            }
            return true;
        }
        if (sub.equals("remove")) {
            String group;
            UUID targetUuid;
            if (args2.length < 3) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rankify remove <player> <rank>");
                return true;
            }
            String targetName = args2[1];
            String rankName = args2[2];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (!target.hasPlayedBefore() && !target.isOnline()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + targetName + " has never joined the server.");
                return true;
            }
            if (!this.isValidArg(rankName)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid rank. Available ranks: " + this.getAvailableRanksFromConfig());
                return true;
            }
            if (sender instanceof Player) {
                Player p = (Player)sender;
                String desiredLower = rankName.toLowerCase();
                if (desiredLower.equals("owner") || desiredLower.equals("coowner")) {
                    if (!p.isOp()) {
                        p.sendMessage(String.valueOf(ChatColor.RED) + "Only operators can modify the Owner or CoOwner ranks.");
                        return true;
                    }
                } else if (!p.isOp() && !p.hasPermission("rankify.setrank")) {
                    p.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to remove ranks.");
                    return true;
                }
            }
            if (!this.rankManager.hasGroup(targetUuid = target.getUniqueId(), group = rankName.toLowerCase())) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + targetName + " does not have the " + this.getDisplayNameFromConfig(group) + String.valueOf(ChatColor.YELLOW) + " rank.");
                return true;
            }
            this.rankManager.removeGroup(targetUuid, group);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed " + this.getDisplayNameFromConfig(group) + String.valueOf(ChatColor.GREEN) + " from " + targetName + ".");
            Player onlineTarget = target.getPlayer();
            if (onlineTarget != null) {
                onlineTarget.sendMessage(String.valueOf(ChatColor.RED) + "You have lost the " + this.getDisplayNameFromConfig(group) + String.valueOf(ChatColor.RED) + " rank by " + sender.getName() + String.valueOf(ChatColor.RED) + ".");
            }
            return true;
        }
        if (sub.equals("list")) {
            if (args2.length < 2) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rankify list <player>");
                return true;
            }
            String targetName = args2[1];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (!target.hasPlayedBefore() && !target.isOnline()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player " + targetName + " has never joined the server.");
                return true;
            }
            List<String> groups2 = this.rankManager.getGroups(target.getUniqueId());
            if (groups2 == null || groups2.isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + targetName + " has no stored groups (guest by default).");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + targetName + String.valueOf(ChatColor.GRAY) + " ranks: " + String.valueOf(ChatColor.RESET) + String.join((CharSequence)(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.RESET)), groups2));
            return true;
        }
        if (sender instanceof Player) {
            this.sendUsage((Player)sender);
        } else {
            sender.sendMessage("Usage: /rankify <add|remove|list|gui|reload> ...");
        }
        return true;
    }

    private void sendUsage(Player player) {
        player.sendMessage(String.valueOf(ChatColor.RED) + "Usage:");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rankify add <player> <rank>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rankify remove <player> <rank>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rankify list <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available ranks: " + this.getAvailableRanksFromConfig());
        if (player.hasPermission("rankify.gui")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Or use: /rankify gui");
        }
        if (player.hasPermission("rankify.reload")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Admin: /rankify reload");
        }
    }

    public RankManager getRankManager() {
        return this.rankManager;
    }

    private String getAvailableRanksFromConfig() {
        List list = this.main.getConfig().getMapList("ranks");
        if (list == null || list.isEmpty()) {
            return "";
        }
        List args2 = list.stream().map(m -> m.get("arg")).filter(v -> v instanceof String && !((String)v).isEmpty()).map(v -> ((String)v).toLowerCase()).collect(Collectors.toList());
        return String.join((CharSequence)", ", args2);
    }

    private boolean isValidArg(String arg) {
        if (arg == null || arg.isEmpty()) {
            return false;
        }
        List list = this.main.getConfig().getMapList("ranks");
        if (list == null || list.isEmpty()) {
            return false;
        }
        String needle = arg.toLowerCase();
        return list.stream().map(m -> m.get("arg")).filter(v -> v instanceof String).map(v -> ((String)v).toLowerCase()).anyMatch(s -> s.equals(needle));
    }

    private String getDisplayNameFromConfig(String arg) {
        List list = this.main.getConfig().getMapList("ranks");
        String colored = null;
        if (list != null) {
            for (Map m : list) {
                Object a = m.get("arg");
                Object n = m.get("name");
                if (!(a instanceof String) || !((String)a).equalsIgnoreCase(arg) || !(n instanceof String)) continue;
                colored = (String)n;
                break;
            }
        }
        if (colored == null) {
            colored = arg;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)colored) + String.valueOf(ChatColor.RESET);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        ArrayList<String> empty = new ArrayList<String>();
        if (!command.getName().equalsIgnoreCase("rankify")) {
            return empty;
        }
        if (args2.length == 1) {
            List<String> subs = Arrays.asList("add", "remove", "list", "gui", "reload");
            String cur = args2[0].toLowerCase();
            ArrayList<String> out = new ArrayList<String>();
            for (String s : subs) {
                if (!s.startsWith(cur)) continue;
                out.add(s);
            }
            return out;
        }
        String sub = args2[0].toLowerCase();
        if (args2.length == 2 && (sub.equals("add") || sub.equals("remove") || sub.equals("list"))) {
            String cur = args2[1].toLowerCase();
            List names = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            ArrayList<String> out = new ArrayList<String>();
            for (String n : names) {
                if (!n.toLowerCase().startsWith(cur)) continue;
                out.add(n);
            }
            return out;
        }
        if (args2.length == 3 && (sub.equals("add") || sub.equals("remove"))) {
            String cur = args2[2].toLowerCase();
            List list = this.main.getConfig().getMapList("ranks");
            ArrayList<String> ranks = new ArrayList<String>();
            if (list != null) {
                for (Map m : list) {
                    Object a = m.get("arg");
                    if (!(a instanceof String)) continue;
                    ranks.add(((String)a).toLowerCase());
                }
            }
            ArrayList<String> out = new ArrayList<String>();
            for (String r : ranks) {
                if (!r.startsWith(cur)) continue;
                out.add(r);
            }
            return out;
        }
        return empty;
    }
}

