/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Listeners;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.powell.rankify.main.Main;

public class RankGuiListener
implements Listener {
    private final Main plugin;

    public RankGuiListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getView().getTitle().equals(String.valueOf(ChatColor.DARK_AQUA) + "Rankify Menu") && e.getCurrentItem() != null) {
            Player player = (Player)e.getWhoClicked();
            ItemStack clickedItem = e.getCurrentItem();
            e.setCancelled(true);
            if (e.getCurrentItem().getType() == Material.PLAYER_HEAD) {
                String player_name = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
                Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)36, (String)player_name);
                ItemStack close = new ItemStack(Material.BARRIER);
                ItemMeta closemeta = close.getItemMeta();
                closemeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close Button");
                close.setItemMeta(closemeta);
                inv.setItem(0, close);
                ItemStack p = new ItemStack(Material.WHITE_STAINED_GLASS_PANE, 90);
                ItemMeta pmeta = p.getItemMeta();
                pmeta.setDisplayName(player_name);
                pmeta.setMaxStackSize(Integer.valueOf(1));
                p.setItemMeta(pmeta);
                inv.setItem(1, p);
                ItemStack frame = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                ItemMeta fmeta = frame.getItemMeta();
                fmeta.setDisplayName(String.valueOf(ChatColor.GRAY) + "_");
                fmeta.setLore(Arrays.asList(""));
                frame.setItemMeta(fmeta);
                List cfgRanks = this.plugin.getConfig().getMapList("ranks");
                boolean[] rankSlotMask = new boolean[36];
                for (Map sec : cfgRanks) {
                    int slot;
                    Object slotObj = sec.get("slot");
                    if (!(slotObj instanceof Number) || (slot = ((Number)slotObj).intValue()) < 0 || slot >= 36) continue;
                    rankSlotMask[slot] = true;
                }
                for (int i = 0; i < 36; ++i) {
                    if (i == 0 || i == 1 || i == 25 || rankSlotMask[i]) continue;
                    inv.setItem(i, frame);
                }
                for (Map sec : cfgRanks) {
                    Material mat;
                    Object nameObj = sec.get("name");
                    String name = nameObj == null ? "Rank" : String.valueOf(nameObj);
                    Object matObj = sec.get("material");
                    String materialStr = matObj == null ? "PAPER" : String.valueOf(matObj);
                    Object slotObj = sec.get("slot");
                    int slot = slotObj instanceof Number ? ((Number)slotObj).intValue() : -1;
                    try {
                        mat = Material.valueOf((String)materialStr.toUpperCase());
                    }
                    catch (Exception ex) {
                        mat = Material.PAPER;
                    }
                    ItemStack item = new ItemStack(mat);
                    ItemMeta meta = item.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                        item.setItemMeta(meta);
                    }
                    if (slot < 0 || slot >= 36) continue;
                    inv.setItem(slot, item);
                }
                player.openInventory(inv);
            }
            if (clickedItem.getType() == Material.BARRIER && clickedItem.hasItemMeta()) {
                player.closeInventory();
            }
            if (clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE && clickedItem.hasItemMeta()) {
                e.setCancelled(true);
            }
        }
    }
}

