/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Managers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.powell.rankify.main.Main;

public class NametagManager {
    private Main main;

    public NametagManager(Main main) {
        this.main = main;
    }

    public void setNametags(Player viewer) {
        viewer.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        List cfgRanks = this.main.getConfig().getMapList("ranks");
        LinkedHashMap<String, CallSite> displayByArg = new LinkedHashMap<String, CallSite>();
        if (cfgRanks != null) {
            for (Map map : cfgRanks) {
                Object a = map.get("arg");
                Object n = map.get("name");
                if (!(a instanceof String) || !(n instanceof String)) continue;
                String arg = ((String)a).toLowerCase(Locale.ROOT);
                String disp = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)n)) + String.valueOf(ChatColor.RESET);
                displayByArg.put(arg, (CallSite)((Object)disp));
            }
        }
        displayByArg.putIfAbsent("guest", (CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Guest" + String.valueOf(ChatColor.RESET))));
        for (Map.Entry entry : displayByArg.entrySet()) {
            String teamName = this.safeTeamName((String)entry.getKey());
            Team team = viewer.getScoreboard().getTeam(teamName);
            if (team == null) {
                team = viewer.getScoreboard().registerNewTeam(teamName);
            }
            team.setPrefix((String)entry.getValue() + " ");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (viewer.getUniqueId().equals(player.getUniqueId())) continue;
            String primary = this.primaryGroupFor(player.getUniqueId(), displayByArg.keySet());
            String teamName = this.safeTeamName(primary);
            Team team = viewer.getScoreboard().getTeam(teamName);
            if (team == null) continue;
            team.addEntry(player.getName());
        }
    }

    public void newTag(Player player) {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.removeFromAllTeams(viewer, player.getName());
            this.ensureTeams(viewer);
            String primary = this.primaryGroupFor(player.getUniqueId(), this.getConfiguredArgs());
            Team team = viewer.getScoreboard().getTeam(this.safeTeamName(primary));
            if (team == null) continue;
            team.addEntry(player.getName());
        }
    }

    public void removeTag(Player player) {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.removeFromAllTeams(viewer, player.getName());
        }
    }

    private void removeFromAllTeams(Player viewer, String entry) {
        Team team = viewer.getScoreboard().getEntryTeam(entry);
        if (team != null) {
            team.removeEntry(entry);
        }
    }

    private void ensureTeams(Player viewer) {
        Map<String, String> displayByArg = this.loadDisplayByArg();
        for (Map.Entry<String, String> e : displayByArg.entrySet()) {
            String name = this.safeTeamName(e.getKey());
            Team t = viewer.getScoreboard().getTeam(name);
            if (t == null) {
                t = viewer.getScoreboard().registerNewTeam(name);
            }
            t.setPrefix(e.getValue() + " ");
        }
    }

    private Map<String, String> loadDisplayByArg() {
        List cfgRanks = this.main.getConfig().getMapList("ranks");
        LinkedHashMap<String, String> displayByArg = new LinkedHashMap<String, String>();
        if (cfgRanks != null) {
            for (Map m : cfgRanks) {
                Object a = m.get("arg");
                Object n = m.get("name");
                if (!(a instanceof String) || !(n instanceof String)) continue;
                String arg = ((String)a).toLowerCase(Locale.ROOT);
                String disp = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)n)) + String.valueOf(ChatColor.RESET);
                displayByArg.put(arg, disp);
            }
        }
        displayByArg.putIfAbsent("guest", String.valueOf(ChatColor.GRAY) + "Guest" + String.valueOf(ChatColor.RESET));
        return displayByArg;
    }

    private List<String> getConfiguredArgs() {
        return new ArrayList<String>(this.loadDisplayByArg().keySet());
    }

    private String primaryGroupFor(UUID uuid, Collection<String> priorityOrder) {
        List<String> groups2 = this.main.getRankManager().getGroups(uuid);
        if (groups2 != null && !groups2.isEmpty()) {
            ArrayList<String> norm = new ArrayList<String>();
            for (String g : groups2) {
                if (g == null || g.isEmpty()) continue;
                norm.add(g.toLowerCase(Locale.ROOT));
            }
            if (norm.isEmpty()) {
                return "guest";
            }
            if (norm.size() > 1) {
                norm.removeIf(s -> s.equals("guest"));
            }
            for (String preferred : priorityOrder) {
                for (String g : norm) {
                    if (!g.equals(preferred)) continue;
                    return preferred;
                }
            }
            return (String)norm.get(0);
        }
        String fallback = this.main.getRankManager().getRank(uuid).name().toLowerCase(Locale.ROOT);
        return fallback != null ? fallback : "guest";
    }

    private String safeTeamName(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "guest";
        }
        String cleaned = raw.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_]", "_");
        if (cleaned.length() > 16) {
            cleaned = cleaned.substring(0, 16);
        }
        return cleaned.isEmpty() ? "guest" : cleaned;
    }
}

