/*
 * Decompiled with CFR 0.152.
 */
package org.powell.rankify.main.Managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.powell.rankify.main.Enums.Rank;
import org.powell.rankify.main.Main;
import org.powell.rankify.main.Managers.PermissionsBridge;

public class RankManager {
    private File file;
    private Main main;
    private YamlConfiguration config;
    private HashMap<UUID, PermissionAttachment> perm = new HashMap();
    private final PermissionsBridge permissionsBridge;
    private HashMap<String, String> configDrivenGroups = new HashMap();

    public RankManager(Main main) {
        this.main = main;
        if (!main.getDataFolder().exists()) {
            main.getDataFolder().mkdir();
        }
        this.file = new File(main.getDataFolder(), "ranks.yml");
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.permissionsBridge = new PermissionsBridge(main);
    }

    public void setRank(UUID uuid, Rank rank, boolean firstJoin) {
        Player player;
        OfflinePlayer offlinePlayer;
        block16: {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            if (rank == null) {
                throw new IllegalArgumentException("Rank cannot be null");
            }
            offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            if (firstJoin && !this.config.contains(uuid.toString())) {
                rank = Rank.GUEST;
            }
            if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
                Rank oldRank;
                PermissionAttachment attachment = this.perm.get(uuid);
                if (attachment == null) {
                    attachment = player.addAttachment((Plugin)this.main);
                    this.perm.put(uuid, attachment);
                }
                if (!firstJoin && (oldRank = this.getRank(uuid)) != null) {
                    String[] stringArray = oldRank.getPerms();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String perm = stringArray[i];
                        attachment.unsetPermission(perm);
                    }
                }
                for (String perm : rank.getPerms()) {
                    if (perm == null || perm.isEmpty()) continue;
                    attachment.setPermission(perm, true);
                }
                player.recalculatePermissions();
            }
            this.config.set(uuid.toString(), (Object)rank.name());
            try {
                this.config.save(this.file);
            }
            catch (IOException e) {
                this.main.getLogger().severe("Could not save rank data for " + String.valueOf(uuid) + ": " + e.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block16;
                e.printStackTrace();
            }
        }
        try {
            this.permissionsBridge.setGroup(uuid, rank);
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to apply permissions group for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            try {
                if (this.main.getNametagManager() != null) {
                    this.main.getNametagManager().removeTag(player);
                    this.main.getNametagManager().newTag(player);
                }
            }
            catch (Exception e) {
                this.main.getLogger().warning("Failed to update nametag for " + player.getName() + ": " + e.getMessage());
            }
        }
    }

    public void setGroup(UUID uuid, String group, boolean firstJoin) {
        Player player;
        OfflinePlayer offlinePlayer;
        block10: {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            if (group == null || group.isEmpty()) {
                throw new IllegalArgumentException("Group cannot be null or empty");
            }
            offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            this.config.set(uuid.toString(), (Object)group);
            try {
                this.config.save(this.file);
            }
            catch (IOException e) {
                this.main.getLogger().severe("Could not save group data for " + String.valueOf(uuid) + ": " + e.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block10;
                e.printStackTrace();
            }
        }
        try {
            this.permissionsBridge.setGroup(uuid, group);
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to apply permissions group '" + group + "' for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            try {
                if (this.main.getNametagManager() != null) {
                    this.main.getNametagManager().removeTag(player);
                    this.main.getNametagManager().newTag(player);
                }
            }
            catch (Exception e) {
                this.main.getLogger().warning("Failed to update nametag for " + player.getName() + ": " + e.getMessage());
            }
        }
    }

    public Rank getRank(UUID uuid) {
        if (uuid == null) {
            return Rank.GUEST;
        }
        String rankName = this.config.getString(uuid.toString());
        if (rankName == null || rankName.isEmpty()) {
            return Rank.GUEST;
        }
        Rank parsed = Rank.fromString(rankName);
        if (parsed == null) {
            return Rank.GUEST;
        }
        return parsed;
    }

    public HashMap<UUID, PermissionAttachment> getPerm() {
        return this.perm;
    }

    public String getGroup(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        String v = this.config.getString(uuid.toString());
        return v != null && !v.isEmpty() ? v : null;
    }

    public List<String> getGroups(UUID uuid) {
        String legacy;
        if (uuid == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> groups2 = this.config.getStringList("groups." + String.valueOf(uuid));
        if (groups2 == null) {
            groups2 = new ArrayList<String>();
        }
        if ((legacy = this.config.getString(uuid.toString())) != null && !legacy.isEmpty() && !groups2.contains(legacy)) {
            groups2.add(legacy);
        }
        return groups2;
    }

    public boolean hasGroup(UUID uuid, String group) {
        if (uuid == null || group == null || group.isEmpty()) {
            return false;
        }
        String needle = group.toLowerCase();
        for (String g : this.getGroups(uuid)) {
            if (g == null || !g.equalsIgnoreCase(needle)) continue;
            return true;
        }
        return false;
    }

    public void addGroup(UUID uuid, String group) {
        Player player;
        boolean hadGuest;
        boolean hasNonGuest;
        block16: {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            if (group == null || group.isEmpty()) {
                throw new IllegalArgumentException("Group cannot be null or empty");
            }
            List<String> current = this.getGroups(uuid);
            LinkedHashSet<String> merged = new LinkedHashSet<String>();
            for (String g : current) {
                if (g == null || g.isEmpty()) continue;
                merged.add(g);
            }
            merged.add(group);
            hasNonGuest = false;
            hadGuest = false;
            for (String string : merged) {
                if (string == null) continue;
                if (string.equalsIgnoreCase("guest")) {
                    hadGuest = true;
                }
                if (string.equalsIgnoreCase("guest")) continue;
                hasNonGuest = true;
            }
            if (hasNonGuest) {
                LinkedHashSet<String> cleaned = new LinkedHashSet<String>();
                for (String g : merged) {
                    if (g == null || g.equalsIgnoreCase("guest")) continue;
                    cleaned.add(g);
                }
                merged = cleaned;
            }
            ArrayList out = new ArrayList(merged);
            this.config.set("groups." + String.valueOf(uuid), out);
            try {
                this.config.save(this.file);
            }
            catch (IOException iOException) {
                this.main.getLogger().severe("Could not save stacked groups for " + String.valueOf(uuid) + ": " + iOException.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block16;
                iOException.printStackTrace();
            }
        }
        try {
            this.permissionsBridge.addGroup(uuid, group);
            if (hasNonGuest && hadGuest) {
                this.permissionsBridge.removeGroup(uuid, "guest");
            }
        }
        catch (Exception exception) {
            this.main.getLogger().warning("Failed to add group '" + group + "' for " + String.valueOf(uuid) + ": " + exception.getMessage());
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            try {
                if (this.main.getNametagManager() != null) {
                    this.main.getNametagManager().removeTag(player);
                    this.main.getNametagManager().newTag(player);
                }
            }
            catch (Exception e) {
                this.main.getLogger().warning("Failed to update nametag for " + player.getName() + ": " + e.getMessage());
            }
        }
    }

    public void removeGroup(UUID uuid, String group) {
        Player player;
        boolean hadGuest;
        boolean hasNonGuest;
        block18: {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            if (group == null || group.isEmpty()) {
                throw new IllegalArgumentException("Group cannot be null or empty");
            }
            List<String> current = this.getGroups(uuid);
            ArrayList<String> updated = new ArrayList<String>();
            for (String g : current) {
                if (g == null || g.equalsIgnoreCase(group)) continue;
                updated.add(g);
            }
            hasNonGuest = false;
            hadGuest = false;
            for (String string : current) {
                if (string == null || !string.equalsIgnoreCase("guest")) continue;
                hadGuest = true;
            }
            for (String string : updated) {
                if (string == null || string.equalsIgnoreCase("guest")) continue;
                hasNonGuest = true;
                break;
            }
            if (!hasNonGuest) {
                updated.clear();
                updated.add("guest");
            } else {
                ArrayList<String> cleaned = new ArrayList<String>();
                for (String g : updated) {
                    if (g == null || g.equalsIgnoreCase("guest")) continue;
                    cleaned.add(g);
                }
                updated = cleaned;
            }
            this.config.set("groups." + String.valueOf(uuid), updated);
            try {
                this.config.save(this.file);
            }
            catch (IOException e) {
                this.main.getLogger().severe("Could not save stacked groups for " + String.valueOf(uuid) + ": " + e.getMessage());
                if (!this.main.getConfig().getBoolean("debug", false)) break block18;
                e.printStackTrace();
            }
        }
        try {
            this.permissionsBridge.removeGroup(uuid, group);
            if (hasNonGuest && hadGuest) {
                this.permissionsBridge.removeGroup(uuid, "guest");
            }
            if (!hasNonGuest) {
                this.permissionsBridge.addGroup(uuid, "guest");
            }
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to remove group '" + group + "' for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offlinePlayer.isOnline() && (player = offlinePlayer.getPlayer()) != null) {
            try {
                if (this.main.getNametagManager() != null) {
                    this.main.getNametagManager().removeTag(player);
                    this.main.getNametagManager().newTag(player);
                }
            }
            catch (Exception e) {
                this.main.getLogger().warning("Failed to update nametag for " + player.getName() + ": " + e.getMessage());
            }
        }
    }
}

