/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.pikamug.quests.Quests;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.actions.BukkitActionFactory;
import me.pikamug.quests.conditions.BukkitConditionFactory;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.config.BukkitConfigSettings;
import me.pikamug.quests.config.ConfigSettings;
import me.pikamug.quests.convo.misc.NpcOfferQuestPrompt;
import me.pikamug.quests.convo.misc.QuestAcceptPrompt;
import me.pikamug.quests.dependencies.BukkitDenizenTrigger;
import me.pikamug.quests.dependencies.BukkitDependencies;
import me.pikamug.quests.interfaces.ReloadCallback;
import me.pikamug.quests.libs.localelib.LocaleManager;
import me.pikamug.quests.listeners.BukkitBlockListener;
import me.pikamug.quests.listeners.BukkitCommandManager;
import me.pikamug.quests.listeners.BukkitConvoListener;
import me.pikamug.quests.listeners.BukkitItemListener;
import me.pikamug.quests.listeners.BukkitPartiesListener;
import me.pikamug.quests.listeners.BukkitPlayerListener;
import me.pikamug.quests.listeners.BukkitUniteListener;
import me.pikamug.quests.logging.BukkitQuestsLog4JFilter;
import me.pikamug.quests.module.CustomObjective;
import me.pikamug.quests.module.CustomRequirement;
import me.pikamug.quests.module.CustomReward;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.BukkitQuestFactory;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.statistics.BukkitMetrics;
import me.pikamug.quests.storage.BukkitStorageFactory;
import me.pikamug.quests.storage.QuesterStorage;
import me.pikamug.quests.storage.implementation.ModuleStorageImpl;
import me.pikamug.quests.storage.implementation.file.BukkitActionYamlStorage;
import me.pikamug.quests.storage.implementation.file.BukkitConditionYamlStorage;
import me.pikamug.quests.storage.implementation.file.BukkitQuestYamlStorage;
import me.pikamug.quests.storage.implementation.jar.BukkitModuleJarStorage;
import me.pikamug.quests.tasks.BukkitNpcEffectThread;
import me.pikamug.quests.tasks.BukkitPlayerMoveThread;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.BukkitUpdateChecker;
import me.pikamug.quests.util.stack.BlockItemStacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitQuestsPlugin
extends JavaPlugin
implements Quests {
    private boolean loading = true;
    private String bukkitVersion = "0";
    private BukkitDependencies depends;
    private BukkitActionYamlStorage actionLoader;
    private BukkitConditionYamlStorage conditionLoader;
    private ConfigSettings configSettings;
    private ModuleStorageImpl customLoader;
    private BukkitQuestYamlStorage questLoader;
    private List<CustomObjective> customObjectives = new LinkedList<CustomObjective>();
    private List<CustomRequirement> customRequirements = new LinkedList<CustomRequirement>();
    private List<CustomReward> customRewards = new LinkedList<CustomReward>();
    private Collection<Quester> questers = new ConcurrentSkipListSet<Quester>();
    private Collection<Quest> quests = new ConcurrentSkipListSet<Quest>();
    private Collection<Action> actions = new ConcurrentSkipListSet<Action>();
    private Collection<Condition> conditions = new ConcurrentSkipListSet<Condition>();
    private Collection<UUID> questNpcUuids = new ConcurrentSkipListSet<UUID>();
    private TabExecutor cmdExecutor;
    private ConversationFactory conversationFactory;
    private ConversationFactory npcConversationFactory;
    private BukkitQuestFactory questFactory;
    private BukkitActionFactory actionFactory;
    private BukkitConditionFactory conditionFactory;
    private BukkitConvoListener convoListener;
    private BukkitBlockListener blockListener;
    private BukkitItemListener itemListener;
    private BukkitPlayerListener playerListener;
    private BukkitNpcEffectThread effectThread;
    private BukkitPlayerMoveThread moveThread;
    private BukkitUniteListener uniteListener;
    private BukkitPartiesListener partiesListener;
    private BukkitDenizenTrigger trigger;
    private LocaleManager localeManager;
    private QuesterStorage storage;

    public void onEnable() {
        try {
            Material.matchMaterial((String)"STONE", (boolean)true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addFilter((Filter)new BukkitQuestsLog4JFilter());
        this.bukkitVersion = Bukkit.getServer().getBukkitVersion().split("-")[0];
        this.actionLoader = new BukkitActionYamlStorage(this);
        this.conditionLoader = new BukkitConditionYamlStorage(this);
        this.configSettings = new BukkitConfigSettings(this);
        this.customLoader = new BukkitModuleJarStorage(this);
        this.questLoader = new BukkitQuestYamlStorage(this);
        try {
            Class.forName("me.pikamug.quests.libs.localelib.LocaleManager");
            this.localeManager = new LocaleManager();
        }
        catch (Exception ignored) {
            this.getLogger().warning("LocaleLib not present! Is this a debug environment?");
        }
        BlockItemStacks.init(!BukkitMiscUtil.isBelow113());
        this.convoListener = new BukkitConvoListener();
        this.blockListener = new BukkitBlockListener(this);
        this.itemListener = new BukkitItemListener(this);
        this.playerListener = new BukkitPlayerListener(this);
        this.uniteListener = new BukkitUniteListener();
        this.partiesListener = new BukkitPartiesListener();
        this.effectThread = new BukkitNpcEffectThread(this);
        this.moveThread = new BukkitPlayerMoveThread(this);
        this.questFactory = new BukkitQuestFactory(this);
        this.actionFactory = new BukkitActionFactory(this);
        this.conditionFactory = new BukkitConditionFactory(this);
        this.depends = new BukkitDependencies(this);
        this.trigger = new BukkitDenizenTrigger(this);
        this.configSettings.init();
        if (this.configSettings.getLanguage().contains("-")) {
            BukkitMetrics metrics = new BukkitMetrics(this);
            metrics.addCustomChart(new BukkitMetrics.SimplePie("language", () -> this.configSettings.getLanguage()));
        }
        try {
            BukkitLang.init(this);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        this.cmdExecutor = new BukkitCommandManager(this);
        this.depends.init();
        this.moveStorageResource("quests.yml");
        this.moveStorageResource("actions.yml");
        this.moveStorageResource("conditions.yml");
        this.saveResourceAs("quests.yml", "storage/quests.yml", false);
        this.saveResourceAs("actions.yml", "storage/actions.yml", false);
        this.saveResourceAs("conditions.yml", "storage/conditions.yml", false);
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().header("See https://pikamug.gitbook.io/quests/setup/configuration");
        this.saveConfig();
        BukkitStorageFactory storageFactory = new BukkitStorageFactory(this);
        this.storage = storageFactory.getInstance();
        if (this.getCommand("quests") != null) {
            Objects.requireNonNull(this.getCommand("quests")).setExecutor((CommandExecutor)this.getTabExecutor());
            Objects.requireNonNull(this.getCommand("quests")).setTabCompleter((TabCompleter)this.getTabExecutor());
        }
        if (this.getCommand("questadmin") != null) {
            Objects.requireNonNull(this.getCommand("questadmin")).setExecutor((CommandExecutor)this.getTabExecutor());
            Objects.requireNonNull(this.getCommand("questadmin")).setTabCompleter((TabCompleter)this.getTabExecutor());
        }
        if (this.getCommand("quest") != null) {
            Objects.requireNonNull(this.getCommand("quest")).setExecutor((CommandExecutor)this.getTabExecutor());
            Objects.requireNonNull(this.getCommand("quest")).setTabCompleter((TabCompleter)this.getTabExecutor());
        }
        this.conversationFactory = new ConversationFactory((Plugin)this).withModality(false).withPrefix(context -> ChatColor.GRAY.toString()).withFirstPrompt((Prompt)new QuestAcceptPrompt(this)).withTimeout(this.configSettings.getAcceptTimeout()).thatExcludesNonPlayersWithMessage("Console may not perform this conversation!").addConversationAbandonedListener((ConversationAbandonedListener)this.convoListener);
        this.npcConversationFactory = new ConversationFactory((Plugin)this).withModality(false).withFirstPrompt((Prompt)new NpcOfferQuestPrompt(this)).withTimeout(this.configSettings.getAcceptTimeout()).withLocalEcho(false).addConversationAbandonedListener((ConversationAbandonedListener)this.convoListener);
        this.getServer().getPluginManager().registerEvents((Listener)this.getBlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.getItemListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.getPlayerListener(), (Plugin)this);
        if (this.configSettings.getStrictPlayerMovement() > 0) {
            long ticks = (long)this.configSettings.getStrictPlayerMovement() * 20L;
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.getPlayerMoveThread(), ticks, ticks);
        }
        if (this.depends.getPartyProvider() != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.getUniteListener(), (Plugin)this);
        } else if (this.depends.getPartiesApi() != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.getPartiesListener(), (Plugin)this);
        }
        new BukkitUpdateChecker(this, 3711).getVersion(version -> {
            if (BukkitUpdateChecker.compareVersions(this.getDescription().getVersion().split("-")[0], version)) {
                this.getLogger().info(ChatColor.DARK_GREEN + BukkitLang.get("updateTo").replace("<version>", (CharSequence)version).replace("<url>", ChatColor.AQUA + this.getDescription().getWebsite()));
            }
        });
        this.delayLoadQuestInfo();
    }

    public void onDisable() {
        this.getLogger().info("Saving Quester data...");
        for (Player p : this.getServer().getOnlinePlayers()) {
            this.getQuester(p.getUniqueId()).saveData();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("Closing storage...");
        if (this.storage != null) {
            this.storage.close();
        }
    }

    public boolean isProVersion() {
        return false;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public File getPluginDataFolder() {
        return this.getDataFolder();
    }

    @Override
    public Logger getPluginLogger() {
        return this.getLogger();
    }

    @Override
    public InputStream getPluginResource(String filename) {
        return this.getResource(filename);
    }

    @Override
    public String getDetectedServerSoftwareVersion() {
        return this.bukkitVersion;
    }

    @Override
    public BukkitDependencies getDependencies() {
        return this.depends;
    }

    @Override
    public BukkitConfigSettings getConfigSettings() {
        return (BukkitConfigSettings)this.configSettings;
    }

    @Override
    public List<CustomObjective> getCustomObjectives() {
        return this.customObjectives;
    }

    public Optional<CustomObjective> getCustomObjective(String className) {
        for (CustomObjective co : this.customObjectives) {
            if (!co.getClass().getName().equals(className)) continue;
            return Optional.of(co);
        }
        return Optional.empty();
    }

    public void setCustomObjectives(List<CustomObjective> customObjectives) {
        this.customObjectives = customObjectives;
    }

    @Override
    public List<CustomRequirement> getCustomRequirements() {
        return this.customRequirements;
    }

    public Optional<CustomRequirement> getCustomRequirement(String className) {
        for (CustomRequirement cr : this.customRequirements) {
            if (!cr.getClass().getName().equals(className)) continue;
            return Optional.of(cr);
        }
        return Optional.empty();
    }

    public void setCustomRequirements(List<CustomRequirement> customRequirements) {
        this.customRequirements = customRequirements;
    }

    @Override
    public List<CustomReward> getCustomRewards() {
        return this.customRewards;
    }

    public Optional<CustomReward> getCustomReward(String className) {
        for (CustomReward cr : this.customRewards) {
            if (!cr.getClass().getName().equals(className)) continue;
            return Optional.of(cr);
        }
        return Optional.empty();
    }

    public void setCustomRewards(List<CustomReward> customRewards) {
        this.customRewards = customRewards;
    }

    @Override
    public Collection<Quest> getLoadedQuests() {
        return this.quests;
    }

    public void setLoadedQuests(Collection<Quest> quests) {
        this.quests = quests;
    }

    @Override
    public Collection<Action> getLoadedActions() {
        return this.actions;
    }

    public void setLoadedActions(Collection<Action> actions) {
        this.actions = actions;
    }

    @Override
    public Collection<Condition> getLoadedConditions() {
        return this.conditions;
    }

    public void setLoadedConditions(Collection<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public BukkitQuester getQuester(@NotNull UUID id) {
        Quester q2;
        ConcurrentSkipListSet set = (ConcurrentSkipListSet)this.questers;
        for (Quester q2 : set) {
            if (q2 == null || !q2.getUUID().equals(id)) continue;
            return (BukkitQuester)q2;
        }
        BukkitQuester quester = new BukkitQuester(this, id);
        if (this.depends.isNpc(id)) {
            return quester;
        }
        q2 = new BukkitQuester(this, id);
        this.questers.add(q2);
        return q2;
    }

    @Override
    public Collection<Quester> getOnlineQuesters() {
        ConcurrentSkipListSet<Quester> questers = new ConcurrentSkipListSet<Quester>();
        for (Quester q : this.getOfflineQuesters()) {
            if (!q.getOfflinePlayer().isOnline()) continue;
            questers.add(q);
        }
        return questers;
    }

    @Override
    public Collection<Quester> getOfflineQuesters() {
        return this.questers;
    }

    @Override
    public void setOfflineQuesters(Collection<Quester> questers) {
        this.questers = new ConcurrentSkipListSet<Quester>(questers);
    }

    public Collection<UUID> getQuestNpcUuids() {
        return this.questNpcUuids;
    }

    public void setQuestNpcUuids(Collection<UUID> questNpcUuids) {
        this.questNpcUuids = new ConcurrentSkipListSet<UUID>(questNpcUuids);
    }

    public CommandExecutor getCommandExecutor() {
        return this.cmdExecutor;
    }

    public TabExecutor getTabExecutor() {
        return this.cmdExecutor;
    }

    public ConversationFactory getConversationFactory() {
        return this.conversationFactory;
    }

    public ConversationFactory getNpcConversationFactory() {
        return this.npcConversationFactory;
    }

    @Override
    public BukkitQuestFactory getQuestFactory() {
        return this.questFactory;
    }

    @Override
    public BukkitActionFactory getActionFactory() {
        return this.actionFactory;
    }

    @Override
    public BukkitConditionFactory getConditionFactory() {
        return this.conditionFactory;
    }

    public BukkitConvoListener getConvoListener() {
        return this.convoListener;
    }

    public BukkitBlockListener getBlockListener() {
        return this.blockListener;
    }

    public BukkitItemListener getItemListener() {
        return this.itemListener;
    }

    public BukkitPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public BukkitUniteListener getUniteListener() {
        return this.uniteListener;
    }

    public BukkitNpcEffectThread getNpcEffectThread() {
        return this.effectThread;
    }

    public BukkitPlayerMoveThread getPlayerMoveThread() {
        return this.moveThread;
    }

    public BukkitPartiesListener getPartiesListener() {
        return this.partiesListener;
    }

    public BukkitDenizenTrigger getDenizenTrigger() {
        return this.trigger;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public QuesterStorage getStorage() {
        return this.storage;
    }

    private void moveStorageResource(String fileName) {
        boolean moved;
        File storageFile = new File(this.getDataFolder(), fileName);
        if (!storageFile.isFile()) {
            return;
        }
        File outFile = new File(this.getDataFolder(), "storage" + File.separatorChar + fileName);
        File outDir = new File(outFile.getPath().replace(fileName, ""));
        if (!outDir.exists() && !outDir.mkdirs()) {
            this.getLogger().log(Level.SEVERE, "Failed to make directories for " + fileName + " (canWrite= " + outDir.canWrite() + ")");
        }
        if (!(moved = storageFile.renameTo(outFile))) {
            this.getLogger().severe("Unable to move " + fileName + " file. Check folder permissions and restart server.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.setEnabled(false);
        }
    }

    @Override
    public void saveResourceAs(String resourcePath, String outputPath, boolean replace) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in Quests jar");
        }
        String outPath = outputPath.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        File outFile = new File(this.getDataFolder(), outPath);
        File outDir = new File(outFile.getPath().replace(outFile.getName(), ""));
        if (!outDir.exists() && !outDir.mkdirs()) {
            this.getLogger().log(Level.SEVERE, "Failed to make directories for " + outFile.getName() + " (canWrite= " + outDir.canWrite() + ")");
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
                if (!outFile.exists()) {
                    this.getLogger().severe("Unable to copy " + outFile.getName() + " (canWrite= " + outFile.canWrite() + ")");
                }
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
        }
    }

    private void delayLoadQuestInfo() {
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            this.conditionLoader.init();
            this.actionLoader.init();
            this.questLoader.init();
            this.getLogger().log(Level.INFO, "Loaded " + this.quests.size() + " Quest(s), " + this.actions.size() + " Action(s), " + this.conditions.size() + " Condition(s) and " + BukkitLang.size() + " Phrase(s)");
            this.customLoader.init();
            this.questLoader.importQuests();
            if (this.getConfigSettings().canDisableCommandFeedback()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"gamerule sendCommandFeedback false");
            }
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                try {
                    this.questers = this.storage.loadOfflineQuesters().get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }, 5L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            for (Player p : this.getServer().getOnlinePlayers()) {
                BukkitQuester quester = new BukkitQuester(this, p.getUniqueId());
                if (!quester.hasData()) {
                    quester.saveData();
                }
                quester.findCompassTarget();
                this.questers.add(quester);
            }
            this.loading = false;
        }, 60L);
    }

    public void reload(ReloadCallback<Boolean> callback) {
        if (this.loading) {
            this.getLogger().warning(ChatColor.YELLOW + BukkitLang.get("errorLoading"));
            return;
        }
        this.loading = true;
        this.reloadConfig();
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                long startTime = System.currentTimeMillis();
                if (this.getConfigSettings().getConsoleLogging() > 3) {
                    this.getLogger().info("Starting save of all questers (may take a while)");
                }
                this.getStorage().saveOfflineQuesters().get();
                if (this.getConfigSettings().getConsoleLogging() > 3) {
                    long finishTime = System.currentTimeMillis() - startTime;
                    this.getLogger().info("Finished saving all questers (took " + finishTime + " ms)");
                }
                BukkitLang.clear();
                this.configSettings.init();
                BukkitLang.load(this, this.configSettings.getLanguage());
                this.quests.clear();
                this.actions.clear();
                this.conditions.clear();
                this.conditionLoader.init();
                this.actionLoader.init();
                this.questLoader.init();
                for (Quester quester : this.questers) {
                    Quester loaded = this.getStorage().loadQuester(quester.getUUID()).get();
                    if (loaded == null) {
                        this.getLogger().severe("Unable to load quester of UUID " + quester.getUUID());
                        continue;
                    }
                    for (Quest quest : loaded.getCurrentQuests().keySet()) {
                        loaded.checkQuest(quest);
                    }
                }
                this.customLoader.init();
                this.questLoader.importQuests();
                this.finishLoading(callback, true, null);
            }
            catch (Exception e) {
                this.finishLoading(callback, false, e);
            }
            this.loading = false;
        });
    }

    private void finishLoading(ReloadCallback<Boolean> callback, boolean result, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        if (callback != null) {
            this.getServer().getScheduler().runTask((Plugin)this, () -> {
                this.loading = false;
                callback.execute(result);
            });
        }
    }

    public boolean canUseQuests(UUID uuid) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (p != null) {
            for (Permission perm : this.getDescription().getPermissions()) {
                if (!p.hasPermission(perm.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLimitedAccess(Conversable conversable) {
        if (!(conversable instanceof Player)) {
            return false;
        }
        Player player = (Player)conversable;
        if (player.isOp() || player.hasPermission("*")) {
            return false;
        }
        return player.hasPermission("quests.mode.trial");
    }

    public Quest getQuestById(String id) {
        if (id == null) {
            return null;
        }
        for (Quest q : this.quests) {
            if (!q.getId().equals(id)) continue;
            return q;
        }
        return null;
    }

    public Quest getQuest(String name) {
        if (name == null) {
            return null;
        }
        for (Quest q : this.quests) {
            if (!q.getName().equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)name))) continue;
            return q;
        }
        for (Quest q : this.quests) {
            if (!q.getName().toLowerCase().startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return q;
        }
        for (Quest q : this.quests) {
            if (!q.getName().toLowerCase().contains(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return q;
        }
        for (Quest q : this.quests) {
            if (!ChatColor.stripColor((String)q.getName()).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)name)))) continue;
            return q;
        }
        return null;
    }

    public Action getAction(String name) {
        if (name == null) {
            return null;
        }
        for (Action a : this.actions) {
            if (!a.getName().equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)name))) continue;
            return a;
        }
        for (Action a : this.actions) {
            if (!a.getName().toLowerCase().startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return a;
        }
        for (Action a : this.actions) {
            if (!a.getName().toLowerCase().contains(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return a;
        }
        for (Action a : this.actions) {
            if (!ChatColor.stripColor((String)a.getName()).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)name)))) continue;
            return a;
        }
        return null;
    }

    public Condition getCondition(String name) {
        if (name == null) {
            return null;
        }
        for (Condition c : this.conditions) {
            if (!c.getName().equalsIgnoreCase(ChatColor.translateAlternateColorCodes((char)'&', (String)name))) continue;
            return c;
        }
        for (Condition c : this.conditions) {
            if (!c.getName().toLowerCase().startsWith(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return c;
        }
        for (Condition c : this.conditions) {
            if (!c.getName().toLowerCase().contains(ChatColor.translateAlternateColorCodes((char)'&', (String)name).toLowerCase())) continue;
            return c;
        }
        for (Condition c : this.conditions) {
            if (!ChatColor.stripColor((String)c.getName()).equalsIgnoreCase(ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)name)))) continue;
            return c;
        }
        return null;
    }
}

