/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.entity.QuestMob;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.tasks.BukkitActionTimer;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitInventoryUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class BukkitAction
implements Action {
    private final BukkitQuestsPlugin plugin;
    private String name = "";
    protected String message = null;
    protected boolean clearInv = false;
    protected boolean failQuest = false;
    protected LinkedList<Location> explosions = new LinkedList();
    protected Map<Location, Effect> effects = new HashMap<Location, Effect>();
    protected LinkedList<ItemStack> items = new LinkedList();
    protected World stormWorld = null;
    protected int stormDuration = 0;
    protected World thunderWorld = null;
    protected int thunderDuration = 0;
    protected int timer = 0;
    protected boolean cancelTimer = false;
    protected LinkedList<QuestMob> mobSpawns = new LinkedList<QuestMob>(){
        private static final long serialVersionUID = -761974607799449780L;

        @Override
        public boolean equals(Object o) {
            if (o instanceof LinkedList) {
                LinkedList other = (LinkedList)o;
                if (this.size() != other.size()) {
                    return false;
                }
                for (int i = 0; i < this.size(); ++i) {
                    if (((QuestMob)this.get(i)).equals(other.get(i))) continue;
                    return false;
                }
            }
            return false;
        }
    };
    protected LinkedList<Location> lightningStrikes = new LinkedList();
    protected LinkedList<String> commands = new LinkedList();
    protected LinkedList<PotionEffect> potionEffects = new LinkedList();
    protected int hunger = -1;
    protected int saturation = -1;
    protected float health = -1.0f;
    protected Location teleport;
    protected String book = "";
    protected String denizenScript;

    public BukkitAction(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int compareTo(Action action) {
        return this.name.compareTo(action.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean isClearInv() {
        return this.clearInv;
    }

    @Override
    public void setClearInv(boolean clearInv) {
        this.clearInv = clearInv;
    }

    @Override
    public boolean isFailQuest() {
        return this.failQuest;
    }

    @Override
    public void setFailQuest(boolean failQuest) {
        this.failQuest = failQuest;
    }

    public LinkedList<Location> getExplosions() {
        return this.explosions;
    }

    public void setExplosions(LinkedList<Location> explosions) {
        this.explosions = explosions;
    }

    public Map<Location, Effect> getEffects() {
        return this.effects;
    }

    public void setEffects(Map<Location, Effect> effects) {
        this.effects = effects;
    }

    public LinkedList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(LinkedList<ItemStack> items) {
        this.items = items;
    }

    public World getStormWorld() {
        return this.stormWorld;
    }

    public void setStormWorld(World stormWorld) {
        this.stormWorld = stormWorld;
    }

    @Override
    public int getStormDuration() {
        return this.stormDuration;
    }

    @Override
    public void setStormDuration(int stormDuration) {
        this.stormDuration = stormDuration;
    }

    public World getThunderWorld() {
        return this.thunderWorld;
    }

    public void setThunderWorld(World thunderWorld) {
        this.thunderWorld = thunderWorld;
    }

    @Override
    public int getThunderDuration() {
        return this.thunderDuration;
    }

    @Override
    public void setThunderDuration(int thunderDuration) {
        this.thunderDuration = thunderDuration;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    @Override
    public void setTimer(int timer) {
        this.timer = timer;
    }

    @Override
    public boolean isCancelTimer() {
        return this.cancelTimer;
    }

    @Override
    public void setCancelTimer(boolean cancelTimer) {
        this.cancelTimer = cancelTimer;
    }

    @Override
    public LinkedList<QuestMob> getMobSpawns() {
        return this.mobSpawns;
    }

    @Override
    public void setMobSpawns(LinkedList<QuestMob> mobSpawns) {
        this.mobSpawns = mobSpawns;
    }

    public LinkedList<Location> getLightningStrikes() {
        return this.lightningStrikes;
    }

    public void setLightningStrikes(LinkedList<Location> lightningStrikes) {
        this.lightningStrikes = lightningStrikes;
    }

    @Override
    public LinkedList<String> getCommands() {
        return this.commands;
    }

    @Override
    public void setCommands(LinkedList<String> commands) {
        this.commands = commands;
    }

    public LinkedList<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public void setPotionEffects(LinkedList<PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    @Override
    public int getSaturation() {
        return this.saturation;
    }

    @Override
    public void setSaturation(int saturation) {
        this.saturation = saturation;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public void setHealth(float health) {
        this.health = health;
    }

    public Location getTeleport() {
        return this.teleport;
    }

    public void setTeleport(Location teleport) {
        this.teleport = teleport;
    }

    @Override
    public String getBook() {
        return this.book;
    }

    @Override
    public void setBook(String book) {
        this.book = book;
    }

    @Override
    public String getDenizenScript() {
        return this.book;
    }

    @Override
    public void setDenizenScript(String scriptName) {
        this.denizenScript = scriptName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fire(Quester quester, Quest quest) {
        Player player = quester.getPlayer();
        if (this.message != null) {
            player.sendMessage(BukkitConfigUtil.parseStringWithPossibleLineBreaks(this.message, quest, player));
        }
        if (this.clearInv) {
            player.getInventory().clear();
        }
        if (!this.explosions.isEmpty()) {
            for (Location location : this.explosions) {
                if (location.getWorld() == null) continue;
                location.getWorld().createExplosion(location, 4.0f, false);
            }
        }
        if (!this.effects.isEmpty()) {
            for (Location location : this.effects.keySet()) {
                if (location.getWorld() == null) continue;
                location.getWorld().playEffect(location, this.effects.get(location), 1);
            }
        }
        if (!this.items.isEmpty()) {
            for (ItemStack itemStack : this.items) {
                try {
                    BukkitInventoryUtil.addItem(player, itemStack);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Unable to add null item to inventory of " + player.getName() + " during quest " + quest.getName() + " event " + this.name);
                    player.sendMessage(ChatColor.RED + "Quests encountered a problem with an item. Please contact an administrator.");
                }
            }
        }
        if (this.stormWorld != null) {
            this.stormWorld.setStorm(true);
            this.stormWorld.setWeatherDuration(this.stormDuration);
        }
        if (this.thunderWorld != null) {
            this.thunderWorld.setThundering(true);
            this.thunderWorld.setThunderDuration(this.thunderDuration);
        }
        if (!this.mobSpawns.isEmpty()) {
            for (QuestMob questMob : this.mobSpawns) {
                questMob.spawn();
            }
        }
        if (!this.lightningStrikes.isEmpty()) {
            for (Location location : this.lightningStrikes) {
                if (location.getWorld() == null) continue;
                location.getWorld().strikeLightning(location);
            }
        }
        if (!this.commands.isEmpty()) {
            for (String string : this.commands) {
                void var5_17;
                if (string.contains("<player>")) {
                    if (!player.isOnline()) continue;
                    String string2 = string.replace("<player>", player.getName());
                }
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)var5_17);
            }
        }
        if (!this.potionEffects.isEmpty()) {
            for (PotionEffect potionEffect : this.potionEffects) {
                player.addPotionEffect(potionEffect);
            }
        }
        if (this.hunger != -1) {
            player.setFoodLevel(this.hunger);
        }
        if (this.saturation != -1) {
            player.setSaturation((float)this.saturation);
        }
        if (this.health != -1.0f) {
            player.setHealth((double)this.health);
        }
        if (this.teleport != null) {
            if (player.isDead()) {
                this.plugin.getLogger().warning("Tried to fire Action " + this.name + " but player " + player.getUniqueId() + " was dead (known Bukkit limitation).");
            } else {
                player.teleport(this.teleport);
            }
        }
        if (this.book != null && !this.book.isEmpty() && this.plugin.getDependencies().getAstralBooksApi() != null && this.plugin.getDependencies().getAstralBooksApi().hasFilterBook(this.book)) {
            this.plugin.getDependencies().getAstralBooksApi().openBook(player, this.plugin.getDependencies().getAstralBooksApi().getFilterBook(this.book));
        }
        if (this.failQuest) {
            quest.failQuest(quester, true);
        }
        if (this.timer > 0) {
            player.sendMessage(ChatColor.GREEN + BukkitLang.get(player, "timerStart").replace("<time>", BukkitMiscUtil.getTime((long)this.timer * 1000L)).replace("<quest>", quest.getName()));
            List<Integer> toNotify = Arrays.asList(60, 30, 10, 5, 4, 3, 2, 1);
            for (int seconds : toNotify) {
                if (this.timer <= seconds) continue;
                quester.getTimers().put(new BukkitActionTimer(quester, quest, seconds).runTaskLater((Plugin)this.plugin, (long)(this.timer - seconds) * 20L).getTaskId(), quest);
            }
            quester.getTimers().put(new BukkitActionTimer(quester, quest, 0).runTaskLater((Plugin)this.plugin, (long)this.timer * 20L).getTaskId(), quest);
        }
        if (this.cancelTimer) {
            for (Map.Entry entry : quester.getTimers().entrySet()) {
                if (!((Quest)entry.getValue()).getId().equals(quest.getId())) continue;
                this.plugin.getServer().getScheduler().cancelTask(((Integer)entry.getKey()).intValue());
                quester.getTimers().remove(entry.getKey());
            }
        }
        if (this.denizenScript != null) {
            this.plugin.getDenizenTrigger().runDenizenScript(this.denizenScript, quester, null);
        }
    }
}

